/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.provider;

import com.sap.jmx.provider.LazyMBeanLoader;
import com.sap.jmx.provider.ProviderConnectionInfo;
import com.sap.jmx.provider.ProviderInterceptor;
import javax.management.ObjectName;

public class LazyMBeanInfo {
    private static LazyMBeanInfo first;
    private static LazyMBeanInfo last;
    private static LazyMBeanInfo mid;
    private static LazyMBeanLoader loader;
    private boolean isRegistered;
    private boolean hasExclusive;
    private int waitForExclusive;
    private int lockCount;
    private LazyMBeanInfo next;
    private LazyMBeanInfo prev;
    private int objectTimeStamp;
    private int lazyLoadTimeStamp;
    private Object mBean;
    private ProviderConnectionInfo provider;
    private ObjectName name;
    private boolean mainFlag;
    private LazyMBeanInfo nextToLoad;
    private LazyMBeanInfo prevToLoad;
    private LazyMBeanInfo nextMBeanInConnection;
    private LazyMBeanInfo prevMBeanInConnection;

    public static String printInfo() {
        String result = "";
        result = first == null ? result + "First: null" : result + "First: " + first.getObjectName();
        result = mid == null ? result + "Mid: null" : result + "Mid: " + mid.getObjectName();
        result = last == null ? result + "Last: null" : result + "Last: " + last.getObjectName();
        return result;
    }

    private static synchronized void moveAhead(LazyMBeanInfo info) {
        if (first == info) {
            return;
        }
        if (info.prev != null) {
            info.prev.next = info.next;
        }
        if (info.next != null) {
            info.next.prev = info.prev;
        }
        if (last == info && info.prev != null) {
            last = info.prev;
        }
        if (mid == info) {
            if (info.next != null) {
                mid = info.next;
            } else if (info.prev != null) {
                mid = info.prev;
            }
        }
        if (first != null) {
            LazyMBeanInfo.first.prev = info;
        }
        info.next = first;
        info.prev = null;
        first = info;
        info.setObjectTimeStamp(LazyMBeanLoader.getTimeStamp());
        if (LazyMBeanInfo.getLowestTimeStamp() > info.getLazyLoadTimeStamp()) {
            loader.lazyLoad(info.getObjectName());
        }
    }

    private static synchronized void addNew(LazyMBeanInfo info) {
        if (first != null) {
            LazyMBeanInfo.first.prev = info;
            info.next = first;
            info.prev = null;
            first = info;
        } else {
            first = info;
            info.next = null;
            info.prev = null;
            last = info;
            mid = info;
        }
    }

    private static synchronized void addNewUnused(LazyMBeanInfo info) {
        if (mid != null) {
            info.next = LazyMBeanInfo.mid.next;
            info.prev = mid;
            if (LazyMBeanInfo.mid.next != null) {
                LazyMBeanInfo.mid.next.prev = info;
            }
            LazyMBeanInfo.mid.next = info;
            if (last == mid) {
                last = info;
            }
        } else {
            first = info;
            info.next = null;
            info.prev = null;
            last = info;
            mid = info;
        }
    }

    private static synchronized void remove(LazyMBeanInfo info) {
        if (info.prev != null) {
            info.prev.next = info.next;
        }
        if (info.next != null) {
            info.next.prev = info.prev;
        }
        if (first == info) {
            first = info.next;
        }
        if (last == info) {
            last = info.prev;
        }
        if (mid == info) {
            mid = info.prev != null ? info.prev : info.next;
        }
        info.prev = null;
        info.next = null;
    }

    public static synchronized LazyMBeanInfo getLast() {
        if (last != null) {
            if (last.getObjectTimeStamp() < mid.getObjectTimeStamp()) {
                if (last.getMainFlag()) {
                    LazyMBeanInfo.moveAhead(last);
                    return null;
                }
                return last;
            }
            if (mid.getMainFlag()) {
                LazyMBeanInfo.moveAhead(mid);
                return null;
            }
            return mid;
        }
        return null;
    }

    public static synchronized int getLowestTimeStamp() {
        if (last == null) {
            return -1;
        }
        if (last.getObjectTimeStamp() < mid.getObjectTimeStamp()) {
            return last.getObjectTimeStamp();
        }
        return mid.getObjectTimeStamp();
    }

    public LazyMBeanInfo(ObjectName name) {
        this.name = name;
        this.isRegistered = false;
        this.hasExclusive = false;
        this.lockCount = 0;
        this.waitForExclusive = 0;
        this.objectTimeStamp = -1;
        this.lazyLoadTimeStamp = -1;
        this.mainFlag = false;
    }

    public synchronized boolean addLock() {
        if (this.hasExclusive || this.waitForExclusive > 0) {
            return false;
        }
        ++this.lockCount;
        LazyMBeanInfo.moveAhead(this);
        return true;
    }

    public synchronized void removeLock() {
        --this.lockCount;
        this.provider.invalidateTimeStamp();
        if (this.lockCount == 0 && this.waitForExclusive > 0) {
            this.notifyAll();
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public boolean register(Object mBean, ProviderConnectionInfo provider, int timeStamp) {
        if (!this.isRegistered) {
            this.isRegistered = true;
            if (timeStamp != -1) {
                this.objectTimeStamp = timeStamp;
                LazyMBeanInfo.addNewUnused(this);
            } else {
                this.objectTimeStamp = LazyMBeanLoader.getTimeStamp();
                LazyMBeanInfo.addNew(this);
            }
            this.mBean = mBean;
            this.provider = provider;
            return true;
        }
        return false;
    }

    public boolean unregister() {
        boolean result = this.isRegistered;
        LazyMBeanInfo.remove(this);
        this.isRegistered = false;
        return result;
    }

    public synchronized void waitForLock() {
        while (this.hasExclusive) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean addExclusiveLock() {
        if (this.hasExclusive || this.lockCount > 0) {
            return false;
        }
        this.hasExclusive = true;
        return true;
    }

    public synchronized void waitForExclusiveLock() {
        while (this.hasExclusive || this.lockCount > 0) {
            Object var3_2;
            try {
                try {
                    ++this.waitForExclusive;
                    this.wait();
                }
                catch (InterruptedException iException) {
                    var3_2 = null;
                    --this.waitForExclusive;
                    continue;
                }
                var3_2 = null;
                --this.waitForExclusive;
            }
            catch (Throwable throwable) {
                var3_2 = null;
                --this.waitForExclusive;
                throw throwable;
            }
        }
    }

    public synchronized void removeExclusiveLock() {
        this.hasExclusive = false;
        this.provider.invalidateTimeStamp();
        this.notifyAll();
    }

    public synchronized void reduceExclusiveLock() {
        this.hasExclusive = false;
        ++this.lockCount;
        this.notifyAll();
        LazyMBeanInfo.moveAhead(this);
    }

    public int getObjectTimeStamp() {
        return this.objectTimeStamp;
    }

    public void setObjectTimeStamp(int timeStamp) {
        this.objectTimeStamp = timeStamp;
    }

    public int getLazyLoadTimeStamp() {
        return this.lazyLoadTimeStamp;
    }

    public void setLazyLoadTimeStamp(int timeStamp) {
        this.lazyLoadTimeStamp = timeStamp;
    }

    public Object getMBean() {
        return this.mBean;
    }

    public ProviderConnectionInfo getProvider() {
        return this.provider;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public void setNextToLoad(LazyMBeanInfo info) {
        this.nextToLoad = info;
    }

    public void setPrevToLoad(LazyMBeanInfo info) {
        this.prevToLoad = info;
    }

    public LazyMBeanInfo getNextToLoad() {
        return this.nextToLoad;
    }

    public LazyMBeanInfo getPrevToLoad() {
        return this.prevToLoad;
    }

    public void setMainFlag(boolean mainFlag) {
        this.mainFlag = mainFlag;
    }

    public boolean getMainFlag() {
        return this.mainFlag;
    }

    public void setNextMBeanInConnection(LazyMBeanInfo next) {
        this.nextMBeanInConnection = next;
    }

    public LazyMBeanInfo getNextMBeanInConnection() {
        return this.nextMBeanInConnection;
    }

    public void setPrevMBeanInConnection(LazyMBeanInfo prev) {
        this.prevMBeanInConnection = prev;
    }

    public LazyMBeanInfo getPrevMBeanInConnection() {
        return this.prevMBeanInConnection;
    }

    public String toString() {
        String result = " IsRegistered: " + this.isRegistered + " HasExclusive: " + this.hasExclusive + " WaitForExclusive: " + this.waitForExclusive + " LockCount: " + this.lockCount + " ObjectTimeStamp: " + this.objectTimeStamp + " LazyLoadTimeStamp: " + this.lazyLoadTimeStamp + " mBean: " + this.mBean + " MainFlag: " + this.mainFlag;
        result = this.next != null ? result + " Next: " + this.next.getObjectName() : result + " Next: null";
        result = this.prev != null ? result + " Prev: " + this.prev.getObjectName() : result + " Prev: null";
        result = this.nextToLoad != null ? result + " NextToLoad: " + this.nextToLoad.getObjectName() : result + " NextToLoad: null";
        result = this.prevToLoad != null ? result + " PrevToLoad: " + this.prevToLoad.getObjectName() : result + " PrevToLoad: null";
        return result;
    }

    static {
        loader = ProviderInterceptor.getLazyMBeanLoader();
    }
}

