/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.monitoring.api;

import com.sap.pj.jmx.exception.IgnoreFirstLinePrintWriter;
import com.sap.pj.jmx.exception.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class MBeanManagerException
extends Exception {
    private Throwable cause;
    private String causeStackTrace;
    private String actionStackTrace;

    public MBeanManagerException() {
        this.cause = null;
    }

    public MBeanManagerException(String message) {
        super(message);
        this.cause = null;
    }

    public MBeanManagerException(Throwable cause) {
        this.cause = cause;
    }

    public MBeanManagerException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(System.err, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(ps, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            this.writeActionStackTrace(pw);
            this.writeCauseStackTrace(pw, true);
        }
    }

    private void writeActionStackTrace(PrintWriter pw) {
        if (this.actionStackTrace != null) {
            pw.print(this.actionStackTrace);
            pw.println("-------- predecessor system --------");
            super.printStackTrace(new IgnoreFirstLinePrintWriter(pw));
        } else {
            super.printStackTrace(pw);
        }
    }

    private void writeCauseStackTrace(PrintWriter pw, boolean writeSeparator) {
        if (this.cause == null) {
            return;
        }
        if (writeSeparator) {
            pw.println("-------- caused by --------");
        }
        if (this.causeStackTrace != null) {
            pw.print(this.causeStackTrace);
            pw.println("-------- predecessor system --------");
            this.cause.printStackTrace(new IgnoreFirstLinePrintWriter(pw));
        } else {
            this.cause.printStackTrace(pw);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        PrintWriter pw;
        StringWriter sw;
        if (this.cause != null && !Util.serializesStackTrace(this.cause) && !(this.cause instanceof MBeanManagerException)) {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            this.writeCauseStackTrace(pw, false);
            this.causeStackTrace = sw.toString();
        }
        sw = new StringWriter();
        pw = new PrintWriter((Writer)sw, true);
        this.writeActionStackTrace(pw);
        this.actionStackTrace = sw.toString();
        stream.defaultWriteObject();
    }
}

