/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.monitoring.api;

import com.sap.jmx.ObjectNameFactory;
import com.sap.jmx.monitoring.api.MBeanManagerException;
import com.sap.jmx.monitoring.api.PartialRegistrationException;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class MBeanManager {
    private static final String NAME_KEY = "name";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jmx$monitoring$api$MBeanManager == null ? (class$com$sap$jmx$monitoring$api$MBeanManager = MBeanManager.class$("com.sap.jmx.monitoring.api.MBeanManager")) : class$com$sap$jmx$monitoring$api$MBeanManager));
    private static final String REGISTER_MBEANS_METHOD = "registerMBeans(String[],Object[])";
    private static final String UNREGISTER_MBEANS_METHOD = "unregisterMBeans()";
    private ObjectName[] jmxObjectNames;
    private MBeanServer mbs;
    static /* synthetic */ Class class$com$sap$jmx$monitoring$api$MBeanManager;

    public synchronized void registerMBeans(String[] mbeanNames, Object[] mbeans) throws MBeanManagerException {
        if (mbeanNames == null || mbeans == null || mbeanNames.length != mbeans.length) {
            throw new IllegalArgumentException("parameters mbeanNames and mbeans must not be null and must have same lenght");
        }
        int objectNameOff = 0;
        if (this.jmxObjectNames == null) {
            this.jmxObjectNames = new ObjectName[mbeanNames.length];
        } else {
            ObjectName[] newJmxObjectNames = new ObjectName[this.jmxObjectNames.length + mbeanNames.length];
            System.arraycopy(this.jmxObjectNames, 0, newJmxObjectNames, 0, this.jmxObjectNames.length);
            objectNameOff = this.jmxObjectNames.length;
            this.jmxObjectNames = newJmxObjectNames;
        }
        int i = 0;
        while (i < mbeanNames.length) {
            try {
                this.jmxObjectNames[i + objectNameOff] = ObjectNameFactory.getNameForApplicationResourcePerNode(mbeanNames[i], null, null, null);
            }
            catch (MalformedObjectNameException e) {
                this.jmxObjectNames = null;
                MBeanManagerException mbmex = new MBeanManagerException("Unable to create object name for resource MBean " + mbeanNames[i], e);
                LOCATION.traceThrowableT(200, REGISTER_MBEANS_METHOD, mbmex.getMessage(), (Throwable)mbmex);
                throw mbmex;
            }
            ++i;
        }
        try {
            InitialContext initCtx = new InitialContext();
            this.mbs = (MBeanServer)initCtx.lookup("jmx");
        }
        catch (Exception e) {
            this.mbs = null;
            this.jmxObjectNames = null;
            MBeanManagerException mbmex = new MBeanManagerException("Unable to get the MBeanServer", e);
            LOCATION.traceThrowableT(200, REGISTER_MBEANS_METHOD, mbmex.getMessage(), (Throwable)mbmex);
            throw mbmex;
        }
        HashMap<String, Exception> failures = new HashMap<String, Exception>();
        int i2 = 0;
        while (i2 < mbeans.length) {
            ObjectName currName = this.jmxObjectNames[i2 + objectNameOff];
            try {
                this.mbs.registerMBean(mbeans[i2], currName);
            }
            catch (Exception e) {
                failures.put(currName.getKeyProperty(NAME_KEY), e);
                LOCATION.traceThrowableT(200, REGISTER_MBEANS_METHOD, "Unable to register MBean " + currName, (Throwable)e);
            }
            ++i2;
        }
        if (failures.size() != 0) {
            throw new PartialRegistrationException("Registration of " + failures.size() + " MBeans failed. Switch on the trace for com.sap.jmx in order to see detailed exceptions.", failures);
        }
    }

    public void registerMBean(String mbeanName, Object mbean) throws MBeanManagerException {
        this.registerMBeans(new String[]{mbeanName}, new Object[]{mbean});
    }

    public synchronized void unregisterMBeans() throws PartialRegistrationException {
        if (this.mbs != null && this.jmxObjectNames != null) {
            HashMap<String, Exception> failures = new HashMap<String, Exception>();
            int i = 0;
            while (i < this.jmxObjectNames.length) {
                ObjectName currName = this.jmxObjectNames[i];
                try {
                    this.mbs.unregisterMBean(currName);
                }
                catch (Exception e) {
                    failures.put(currName.getKeyProperty(NAME_KEY), e);
                    LOCATION.traceThrowableT(200, UNREGISTER_MBEANS_METHOD, "Unable to unregister MBean " + currName, (Throwable)e);
                }
                ++i;
            }
            if (failures.size() != 0) {
                throw new PartialRegistrationException("Un-registration of " + failures.size() + " MBeans failed. Switch on the trace for com.sap.jmx in order to see detailed exceptions.", failures);
            }
        }
        this.mbs = null;
    }

    public synchronized String[] getMBeanNames() {
        if (this.jmxObjectNames == null) {
            return new String[0];
        }
        String[] mbeanNames = new String[this.jmxObjectNames.length];
        int i = 0;
        while (i < this.jmxObjectNames.length) {
            mbeanNames[i] = this.jmxObjectNames[i].getKeyProperty(NAME_KEY);
            ++i;
        }
        return mbeanNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

