/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.monitoring.api;

public abstract class LanguageDependentText {
    public static final int MAX_TEXT_ID_LENGTH = 30;
    public static final int MAX_TEXT_CLASS_LENGTH = 16;
    private static final String DEFAULT_CLASS = "SAP J2EE Engine";
    private String textID;
    private String textClass = "SAP J2EE Engine";

    LanguageDependentText() {
        this.textID = null;
    }

    public LanguageDependentText(String textID) throws IllegalArgumentException {
        this.setTextID(textID);
    }

    public LanguageDependentText(String textID, String textClass) throws IllegalArgumentException {
        this.setTextID(textID);
        this.setTextClass(textClass);
    }

    public final String getTextID() {
        return this.textID;
    }

    public final String getTextClass() {
        return this.textClass;
    }

    public final void setTextID(String textID) throws IllegalArgumentException {
        this.checktTextID(textID);
        this.textID = textID;
    }

    public final void setTextClass(String textClass) throws IllegalArgumentException {
        this.checkTextClass(textClass);
        this.textClass = textClass;
    }

    private void checktTextID(String textID) throws IllegalArgumentException {
        if (textID == null) {
            throw new IllegalArgumentException("Text ID is null.");
        }
        if (textID.length() < 1) {
            throw new IllegalArgumentException("Text ID is empty.");
        }
        if (textID.length() > 30) {
            throw new IllegalArgumentException("Text ID has more than 30 characters.");
        }
    }

    private void checkTextClass(String textClass) throws IllegalArgumentException {
        if (textClass == null) {
            throw new IllegalArgumentException("Text class is null.");
        }
        if (textClass.length() < 1) {
            throw new IllegalArgumentException("Text class is empty.");
        }
        if (textClass.length() > 16) {
            throw new IllegalArgumentException("Text class has more than 16 characters.");
        }
    }
}

