/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.monitoring.api;

import com.sap.jmx.monitoring.api.TwinIterator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class ConfigurationList
implements TwinIterator {
    public static final int MAX_PARAMETER_NAME_LENGTH = 40;
    public static final int MAX_PARAMETER_VALUE_LENGTH = 255;
    private TreeMap properties = new TreeMap();

    public ConfigurationList() {
    }

    public ConfigurationList(Properties configurationData) throws IllegalArgumentException {
        this();
        if (configurationData == null) {
            throw new IllegalArgumentException("ConfigurationData is null.");
        }
        Iterator iter = ((Hashtable)configurationData).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            this.setConfigurationParameter((String)element.getKey(), (String)element.getValue());
        }
    }

    public Object setConfigurationParameter(String name, String value) throws IllegalArgumentException {
        this.checkName(name);
        return this.properties.put(name, value);
    }

    public String getConfigurationParameter(String name) {
        return (String)this.properties.get(name);
    }

    public Iterator getKeys() {
        return this.properties.keySet().iterator();
    }

    public Iterator getValues() {
        return this.properties.values().iterator();
    }

    public String[][] getParameters() {
        String[][] parameters = new String[2][this.properties.size()];
        Iterator iter = this.properties.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            parameters[0][i] = (String)entry.getKey();
            parameters[1][i] = (String)entry.getValue();
            ++i;
        }
        return parameters;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    private void checkName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name is null.");
        }
        if (name.length() < 1) {
            throw new IllegalArgumentException("Name is empty.");
        }
    }
}

