/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.monitoring.api;

import com.sap.jmx.monitoring.api.ActiveDatasupplier;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class ActiveDatasupplierSupport
implements ActiveDatasupplier {
    private Hashtable listeners = new Hashtable();

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (!(handback instanceof String)) {
            throw new IllegalArgumentException("Handback is not a String.");
        }
        this.addNotificationListener(listener, (String)handback);
    }

    public void addNotificationListener(NotificationListener listener, String mbeanType) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        if (mbeanType == null) {
            throw new IllegalArgumentException("MBeanType is null.");
        }
        Vector<NotificationListener> typedListeners = (Vector<NotificationListener>)this.listeners.get(mbeanType);
        if (typedListeners == null) {
            typedListeners = new Vector<NotificationListener>();
            typedListeners.add(listener);
            this.listeners.put(mbeanType, typedListeners);
        } else {
            typedListeners.add(listener);
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (!(handback instanceof String)) {
            throw new ListenerNotFoundException("Handback is not a String.");
        }
        this.removeNotificationListener(listener, (String)handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.removeNotificationListener(listener, null, null);
    }

    public void removeNotificationListener(NotificationListener listener, String mbeanType) throws ListenerNotFoundException {
        Vector typedListeners = (Vector)this.listeners.get(mbeanType);
        if (typedListeners == null) {
            throw new ListenerNotFoundException("Listener not registered under " + mbeanType + ".");
        }
        if (!typedListeners.remove(listener)) {
            throw new ListenerNotFoundException("Listener not registered under " + mbeanType + ".");
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public void sendNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        String mbeanType = notification.getClass().getName();
        Vector typedListeners = (Vector)this.listeners.get(mbeanType);
        if (typedListeners == null) {
            return;
        }
        Iterator iter = ((AbstractList)typedListeners).iterator();
        while (iter.hasNext()) {
            NotificationListener listener = (NotificationListener)iter.next();
            listener.handleNotification(notification, null);
        }
    }
}

