/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.modelhelper;

import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class OpenTypeFactory {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jmx$modelhelper$OpenTypeFactory == null ? (class$com$sap$jmx$modelhelper$OpenTypeFactory = OpenTypeFactory.class$("com.sap.jmx.modelhelper.OpenTypeFactory")) : class$com$sap$jmx$modelhelper$OpenTypeFactory));
    private static OpenTypeFactory factory;
    private static final int MAX_DEPTH = 10;
    static /* synthetic */ Class class$com$sap$jmx$modelhelper$OpenTypeFactory;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    private OpenTypeFactory() {
    }

    public static OpenTypeFactory getFactory() {
        OpenTypeFactory theFactory = factory;
        if (theFactory == null) {
            factory = theFactory = new OpenTypeFactory();
        }
        return theFactory;
    }

    public static CompositeType getCompositeType(Class typeInterface) throws OpenDataException {
        return OpenTypeFactory.getCompositeTypeInt(0, typeInterface);
    }

    private static CompositeType getCompositeTypeInt(int depth, Class typeInterface) throws OpenDataException {
        CompositeType type = null;
        if (typeInterface == null) {
            throw new IllegalArgumentException("interface class must not be null");
        }
        if (!typeInterface.isInterface()) {
            throw new IllegalArgumentException("interface class must be an interface");
        }
        Method[] methods = typeInterface.getMethods();
        HashMap attributes = new HashMap();
        int i = 0;
        while (i < methods.length) {
            String attrName = methods[i].getName();
            if (methods[i].getDeclaringClass().getName().equals("javax.management.openmbean.CompositeData")) {
                LOCATION.debugT("ignoring method from CompositeData " + typeInterface.getName() + '.' + attrName);
            } else {
                Class<?> returnType = methods[i].getReturnType();
                Class<?>[] paramTypes = methods[i].getParameterTypes();
                if (attrName.startsWith("get")) {
                    if (attrName.length() < 4) {
                        LOCATION.debugT("ignoring method from CompositeData " + typeInterface.getName() + '.' + attrName + " - no getter method");
                    } else if (Void.TYPE.getName().equals(returnType.getName()) || Void.TYPE.getName().equals(returnType.getName())) {
                        LOCATION.debugT("ignoring method from CompositeData " + typeInterface.getName() + '.' + attrName + " - return type of getter is void");
                    } else if (paramTypes.length > 0) {
                        LOCATION.debugT("ignoring method from CompositeData " + typeInterface.getName() + '.' + attrName + " - getter method has parameters");
                    } else {
                        attributes.put(attrName.substring(3), returnType);
                    }
                } else {
                    LOCATION.debugT("ignoring method from CompositeData " + typeInterface.getName() + '.' + attrName + " - no getter method");
                }
            }
            ++i;
        }
        String[] names = new String[attributes.size()];
        String[] descriptions = new String[attributes.size()];
        OpenType[] openTypes = new OpenType[attributes.size()];
        int i2 = 0;
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            String name;
            Map.Entry attribute = iter.next();
            names[i2] = name = (String)attribute.getKey();
            descriptions[i2] = "attribute " + name;
            openTypes[i2] = OpenTypeFactory.getOpenTypeForIntern(depth + 1, (Class)attribute.getValue());
            ++i2;
        }
        type = new CompositeType(typeInterface.getName(), "description", names, descriptions, openTypes);
        return type;
    }

    public static OpenType getOpenTypeFor(Class clazz) throws OpenDataException {
        return OpenTypeFactory.getOpenTypeForIntern(0, clazz);
    }

    private static OpenType getOpenTypeForIntern(int depth, Class clazz) throws OpenDataException {
        if (depth > 10) {
            throw new OpenDataException("maximum depth of nested structure exceeded or circle in structure definition");
        }
        int arrayDimension = 0;
        while (clazz.isArray()) {
            ++arrayDimension;
            clazz = clazz.getComponentType();
        }
        String name = clazz.getName();
        OpenType result = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OpenTypeFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName().equals(name) ? SimpleType.BIGDECIMAL : ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = OpenTypeFactory.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName().equals(name) ? SimpleType.BIGINTEGER : ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = OpenTypeFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName().equals(name) ? SimpleType.BOOLEAN : (Boolean.TYPE.getName().equals(name) ? SimpleType.BOOLEAN : ((class$java$lang$Byte == null ? (class$java$lang$Byte = OpenTypeFactory.class$("java.lang.Byte")) : class$java$lang$Byte).getName().equals(name) ? SimpleType.BYTE : (Byte.TYPE.getName().equals(name) ? SimpleType.BYTE : ((class$java$lang$Character == null ? (class$java$lang$Character = OpenTypeFactory.class$("java.lang.Character")) : class$java$lang$Character).getName().equals(name) ? SimpleType.CHARACTER : (Character.TYPE.getName().equals(name) ? SimpleType.CHARACTER : ((class$java$util$Date == null ? (class$java$util$Date = OpenTypeFactory.class$("java.util.Date")) : class$java$util$Date).getName().equals(name) ? SimpleType.DATE : ((class$java$lang$Double == null ? (class$java$lang$Double = OpenTypeFactory.class$("java.lang.Double")) : class$java$lang$Double).getName().equals(name) ? SimpleType.DOUBLE : (Double.TYPE.getName().equals(name) ? SimpleType.DOUBLE : ((class$java$lang$Float == null ? (class$java$lang$Float = OpenTypeFactory.class$("java.lang.Float")) : class$java$lang$Float).getName().equals(name) ? SimpleType.FLOAT : (Float.TYPE.getName().equals(name) ? SimpleType.FLOAT : ((class$java$lang$Integer == null ? (class$java$lang$Integer = OpenTypeFactory.class$("java.lang.Integer")) : class$java$lang$Integer).getName().equals(name) ? SimpleType.INTEGER : (Integer.TYPE.getName().equals(name) ? SimpleType.INTEGER : ((class$java$lang$Long == null ? (class$java$lang$Long = OpenTypeFactory.class$("java.lang.Long")) : class$java$lang$Long).getName().equals(name) ? SimpleType.LONG : (Long.TYPE.getName().equals(name) ? SimpleType.LONG : ((class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = OpenTypeFactory.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName().equals(name) ? SimpleType.OBJECTNAME : ((class$java$lang$Short == null ? (class$java$lang$Short = OpenTypeFactory.class$("java.lang.Short")) : class$java$lang$Short).getName().equals(name) ? SimpleType.SHORT : (Short.TYPE.getName().equals(name) ? SimpleType.SHORT : ((class$java$lang$String == null ? (class$java$lang$String = OpenTypeFactory.class$("java.lang.String")) : class$java$lang$String).getName().equals(name) ? SimpleType.STRING : OpenTypeFactory.getCompositeTypeInt(depth + 1, clazz)))))))))))))))))))));
        if (arrayDimension == 0) {
            return result;
        }
        return new ArrayType(arrayDimension, result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

