/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx;

import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameFactory {
    public static final String J2EEDomain = "J2EEDomain";
    public static final String J2EEServer = "J2EEServer";
    public static final String J2EEApplication = "J2EEApplication";
    public static final String AppClientModule = "AppClientModule";
    public static final String EJBModule = "EJBModule";
    public static final String WebModule = "WebModule";
    public static final String ResourceAdapterModule = "ResourceAdapterModule";
    public static final String EntityBean = "EntityBean";
    public static final String StatefulSessionBean = "StatefulSessionBean";
    public static final String StatelessSessionBean = "StatelessSessionBean";
    public static final String MessageDrivenBean = "MessageDrivenBean";
    public static final String Servlet = "Servlet";
    public static final String ResourceAdapter = "ResourceAdapter";
    public static final String JavaMailResource = "JavaMailResource";
    public static final String JCAResource = "JCAResource";
    public static final String JCAConnectionFactory = "JCAConnectionFactory";
    public static final String JCAManagedConnectionFactory = "JCAManagedConnectionFactory";
    public static final String JDBCResource = "JDBCResource";
    public static final String JDBCDataSource = "JDBCDataSource";
    public static final String JDBCDriver = "JDBCDriver";
    public static final String JMSResource = "JMSResource";
    public static final String JNDIResource = "JNDIResource";
    public static final String JTAResource = "JTAResource";
    public static final String RMI_IIOPResource = "RMI_IIOPResource";
    public static final String URLResource = "URLResource";
    public static final String JVM = "JVM";
    public static final String JavaMailResource_NAME = "javamail";
    public static final String JCAResource_NAME = "connector";
    public static final String JDBCResource_NAME = "dbpool";
    public static final String JMSResource_NAME = "jms";
    public static final String JNDIResource_NAME = "naming";
    public static final String JTAResource_NAME = "jta";
    public static final String RMI_IIOPResource_NAME = "iiop";
    public static final String URLResource_NAME = "http";
    public static final String SAP_J2EECluster = "SAP_J2EECluster";
    public static final String SAP_J2EEInstance = "SAP_J2EEInstance";
    public static final String SAP_J2EEClusterNode = "SAP_J2EEClusterNode";
    public static final String SAP_J2EEServicePerNode = "SAP_J2EEServicePerNode";
    public static final String SAP_J2EEApplication = "SAP_J2EEApplication";
    public static final String SAP_J2EEApplicationPerNode = "SAP_J2EEApplicationPerNode";
    public static final String SAP_AppClientModulePerNode = "SAP_AppClientModulePerNode";
    public static final String SAP_EJBModulePerNode = "SAP_EJBModulePerNode";
    public static final String SAP_WebModulePerNode = "SAP_WebModulePerNode";
    public static final String SAP_ResourceAdapterModulePerNode = "SAP_ResourceAdapterModulePerNode";
    public static final String SAP_EntityBeanPerNode = "SAP_EntityBeanPerNode";
    public static final String SAP_StatefulSessionBeanPerNode = "SAP_StatefulSessionBeanPerNode";
    public static final String SAP_StatelessSessionBeanPerNode = "SAP_StatelessSessionBeanPerNode";
    public static final String SAP_MessageDrivenBeanPerNode = "SAP_MessageDrivenBeanPerNode";
    public static final String SAP_ServletPerNode = "SAP_ServletPerNode";
    public static final String SAP_ResourceAdapterPerNode = "SAP_ResourceAdapterPerNode";
    public static final String SAP_J2EEClassLoader = "SAP_J2EEClassLoader";
    public static final String SAP_J2EEKernelPerNode = "SAP_J2EEKernelPerNode";
    public static final String SAP_J2EELibraryPerNode = "SAP_J2EELibraryPerNode";
    public static final String SAP_J2EEInterfacePerNode = "SAP_J2EEInterfacePerNode";
    public static final String SAP_J2EEServiceRuntimePerNode = "SAP_J2EEServiceRuntimePerNode";
    public static final String SAP_J2EEKernelRuntimePerNode = "SAP_J2EEKernelRuntimePerNode";
    public static final String SAP_MonitorPerNode = "SAP_MonitorPerNode";
    public static final String SAP_ApplicationResourcePerNode = "SAP_ApplicationResourcePerNode";
    public static final String SAP_J2EETimerFactory = "SAP_J2EETimerFactory";
    public static final String MLET_SERVICE_DEFAULT_NAME = ":type=MLet";
    public static final String MBEAN_SERVER_DELEGATE_NAME = "JMImplementation:type=MBeanServerDelegate";
    public static final String EMPTY_VALUE = "\"\"";
    public static final String J2EETYPE_KEY = "j2eeType";
    public static final String NAME_KEY = "name";
    public static final String PATTERN_KEY = "";
    public static final String STANDALONE_MODULE_APPLICATION_NAME = "null";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jmx$ObjectNameFactory == null ? (class$com$sap$jmx$ObjectNameFactory = ObjectNameFactory.class$("com.sap.jmx.ObjectNameFactory")) : class$com$sap$jmx$ObjectNameFactory));
    private static final String DEFAULT_DOMAIN = "";
    private static final char PATTERN_VALUE = '*';
    private static final String RUNTIME_PROPERTIES_CLASS_NAME = "com.sap.engine.frame.RuntimeProperties";
    private static final String RUNTIME_PROPERTIES_GET_METHOD_NAME = "get";
    private static final String RUNTIME_PROPERTIES_PROPERTY_APPLICATION = "PROPERTY_APPLICATION";
    private static final ObjectName MBEAN_SERVER_DELEGATE_ON;
    private static Method runtimePropertyMethod;
    private static Object[] APPLICATION_PROP;
    static /* synthetic */ Class class$com$sap$jmx$ObjectNameFactory;

    private static String getApplicationName() {
        Object appName = null;
        if (runtimePropertyMethod != null) {
            if (System.getSecurityManager() != null) {
                appName = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return runtimePropertyMethod.invoke(null, APPLICATION_PROP);
                        }
                        catch (Exception e) {
                            LOCATION.traceThrowableT(200, "unable to get application name from rumtime properties", (Throwable)e);
                            return null;
                        }
                    }
                });
            } else {
                try {
                    appName = runtimePropertyMethod.invoke(null, APPLICATION_PROP);
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(200, "unable to get application name from rumtime properties", (Throwable)e);
                    return null;
                }
            }
        }
        if (appName == null || appName instanceof String) {
            return (String)appName;
        }
        LOCATION.logT(200, "unable to get application name from rumtime properties, the name returned was " + (appName == null ? "" : appName.getClass().getName()) + appName);
        return null;
    }

    public static final ObjectName getMBeanServerDelegateName() {
        return MBEAN_SERVER_DELEGATE_ON;
    }

    public static final ObjectName getObjectName(String type, String name) throws MalformedObjectNameException {
        return ObjectNameFactory.getObjectName(type, name, null, null);
    }

    public static final ObjectName getObjectName(String type, String name, String parentType, String parentName) throws MalformedObjectNameException {
        if (type == null || name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type and name must not be null.");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(J2EETYPE_KEY, type);
        table.put(NAME_KEY, name);
        if (parentType != null && parentName != null) {
            table.put(parentType, parentName);
        }
        return new ObjectName("", table);
    }

    public static ObjectName getObjectName(String type, String name, Hashtable parentKeys) throws MalformedObjectNameException {
        if (type == null || name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type and name must not be null.");
        }
        Hashtable table = parentKeys == null ? new Hashtable() : (Hashtable)parentKeys.clone();
        table.put(J2EETYPE_KEY, type);
        table.put(NAME_KEY, name);
        return new ObjectName("", table);
    }

    public static ObjectName getObjectName(String type, String name, ObjectName parentObject) throws MalformedObjectNameException {
        Hashtable<String, String> table;
        if (type == null || name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type and name must not be null.");
        }
        if (parentObject == null) {
            table = new Hashtable<String, String>();
        } else {
            table = parentObject.getKeyPropertyList();
            String parentName = (String)table.remove(NAME_KEY);
            String parentType = (String)table.remove(J2EETYPE_KEY);
            if (parentType == null || parentName == null) {
                throw new MalformedObjectNameException("ObjectName can not be created. Either j2eeType or name key is missing.");
            }
            table.put(parentType, parentName);
        }
        table.put(J2EETYPE_KEY, type);
        table.put(NAME_KEY, name);
        return new ObjectName("", table);
    }

    public static ObjectName getNameForApplicationChild(String type, String name, String applicationName, String serverName) throws MalformedObjectNameException {
        if (type == null || name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type and name parameter must not be null.");
        }
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        if (applicationName == null) {
            applicationName = ObjectNameFactory.getApplicationName();
        }
        if (applicationName == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. ApplicationName parameter is null an cannot be set by the factory when running outside the J2EE Engine.");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(J2EETYPE_KEY, type);
        table.put(NAME_KEY, name);
        table.put(SAP_J2EEApplication, applicationName);
        table.put(SAP_J2EECluster, serverName);
        return new ObjectName("", table);
    }

    public static ObjectName getNameForApplicationChildPerNode(String type, String name, String applicationName, String clusterID, String serverName) throws MalformedObjectNameException {
        if (type == null || name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type, and name parameter must not be null.");
        }
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        if (clusterID == null) {
            clusterID = EMPTY_VALUE;
        }
        if (applicationName == null) {
            applicationName = ObjectNameFactory.getApplicationName();
        }
        if (applicationName == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. ApplicationName parameter is null an cannot be set by the factory when running outside the J2EE Engine.");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(J2EETYPE_KEY, type);
        table.put(NAME_KEY, name);
        table.put(SAP_J2EEApplicationPerNode, applicationName);
        table.put(SAP_J2EEClusterNode, clusterID);
        table.put(SAP_J2EECluster, serverName);
        return new ObjectName("", table);
    }

    public static ObjectName getNameForServerChild(String type, String name, String serverName) throws MalformedObjectNameException {
        if (type == null || name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type and name parameter must not be null.");
        }
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(J2EETYPE_KEY, type);
        table.put(NAME_KEY, name);
        table.put(SAP_J2EECluster, serverName);
        return new ObjectName("", table);
    }

    public static ObjectName getNameForServerChildPerNode(String type, String name, String clusterID, String serverName) throws MalformedObjectNameException {
        if (type == null || name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type and name parameter must not be null.");
        }
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        if (clusterID == null) {
            clusterID = EMPTY_VALUE;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(J2EETYPE_KEY, type);
        table.put(NAME_KEY, name);
        table.put(SAP_J2EEClusterNode, clusterID);
        table.put(SAP_J2EECluster, serverName);
        return new ObjectName("", table);
    }

    public static ObjectName getPatternForServerChildPerNode(String type, String clusterID, String serverName) throws MalformedObjectNameException {
        if (type == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type parameter must not be null.");
        }
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        if (clusterID == null) {
            clusterID = EMPTY_VALUE;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("*:");
        sb.append('*');
        sb.append(',');
        sb.append(J2EETYPE_KEY);
        sb.append('=');
        sb.append(type);
        sb.append(',');
        sb.append(SAP_J2EEClusterNode);
        sb.append('=');
        sb.append(clusterID);
        sb.append(',');
        sb.append(SAP_J2EECluster);
        sb.append('=');
        sb.append(serverName);
        return new ObjectName(sb.toString());
    }

    public static ObjectName getPatternForServerChildPerNode(String clusterID, String serverName) throws MalformedObjectNameException {
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        if (clusterID == null) {
            clusterID = EMPTY_VALUE;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("*:");
        sb.append('*');
        sb.append(',');
        sb.append(SAP_J2EEClusterNode);
        sb.append('=');
        sb.append(clusterID);
        sb.append(',');
        sb.append(SAP_J2EECluster);
        sb.append('=');
        sb.append(serverName);
        return new ObjectName(sb.toString());
    }

    public static ObjectName getPatternForServerChild(String type, String serverName) throws MalformedObjectNameException {
        if (type == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Type parameter must not be null.");
        }
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("*:");
        sb.append('*');
        sb.append(',');
        sb.append(J2EETYPE_KEY);
        sb.append('=');
        sb.append(type);
        sb.append(',');
        sb.append(SAP_J2EECluster);
        sb.append('=');
        sb.append(serverName);
        return new ObjectName(sb.toString());
    }

    public static ObjectName getPatternForServerChild(String serverName) throws MalformedObjectNameException {
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("*:");
        sb.append('*');
        sb.append(',');
        sb.append(SAP_J2EECluster);
        sb.append('=');
        sb.append(serverName);
        return new ObjectName(sb.toString());
    }

    public static boolean isJ2eeLocalName(ObjectName name, String nodeID) {
        if (name == null) {
            return true;
        }
        String j2eeType = ObjectNameFactory.getJ2eeType(name);
        if (SAP_J2EEClusterNode.equals(j2eeType)) {
            String nameValue = ObjectNameFactory.getName(name);
            return nameValue != null && (nameValue.equals(EMPTY_VALUE) || nameValue.equals(nodeID));
        }
        String elementID = ObjectNameFactory.getClusterNode(name);
        return elementID != null && (elementID.equals(EMPTY_VALUE) || elementID.equals(nodeID));
    }

    public static boolean isJ2eeRemoteName(ObjectName name, String nodeID) {
        if (name == null) {
            return false;
        }
        String j2eeType = ObjectNameFactory.getJ2eeType(name);
        if (SAP_J2EEClusterNode.equals(j2eeType)) {
            String nameValue = ObjectNameFactory.getName(name);
            return nameValue != null && !nameValue.equals(EMPTY_VALUE) && !nameValue.equals(nodeID);
        }
        String elementID = ObjectNameFactory.getClusterNode(name);
        return elementID != null && !elementID.equals(EMPTY_VALUE) && !elementID.equals(nodeID);
    }

    public static boolean isJ2eeClusteredName(ObjectName name) {
        if (name == null) {
            return true;
        }
        String j2eeType = ObjectNameFactory.getJ2eeType(name);
        return !SAP_J2EEClusterNode.equals(j2eeType) && ObjectNameFactory.getClusterNode(name) == null;
    }

    public static String getClusterNode(ObjectName name) {
        if (name == null) {
            return null;
        }
        if (SAP_J2EEClusterNode.equals(ObjectNameFactory.getJ2eeType(name))) {
            return name.getKeyProperty(NAME_KEY);
        }
        return name.getKeyProperty(SAP_J2EEClusterNode);
    }

    public static String getJ2eeType(ObjectName name) {
        if (name == null) {
            return null;
        }
        return name.getKeyProperty(J2EETYPE_KEY);
    }

    public static String getName(ObjectName name) {
        if (name == null) {
            return null;
        }
        return name.getKeyProperty(NAME_KEY);
    }

    public static String getClusterName(ObjectName name) {
        if (name == null) {
            return null;
        }
        return name.getKeyProperty(SAP_J2EECluster);
    }

    public static ObjectName getNameForClassLoader(String name, String clusterID, String serverName) throws MalformedObjectNameException {
        return ObjectNameFactory.getNameForServerChildPerNode(SAP_J2EEClassLoader, '\"' + name + '\"', clusterID, serverName);
    }

    public static ObjectName getNameForMonitorPerNode(String name, String clusterID, String serverName) throws MalformedObjectNameException {
        if (name == null) {
            throw new MalformedObjectNameException("ObjectName can not be created. Name parameter must not be null.");
        }
        if (serverName == null) {
            serverName = EMPTY_VALUE;
        }
        if (clusterID == null) {
            clusterID = EMPTY_VALUE;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(J2EETYPE_KEY, SAP_MonitorPerNode);
        table.put(NAME_KEY, name);
        table.put(SAP_J2EEClusterNode, clusterID);
        table.put(SAP_J2EECluster, serverName);
        return new ObjectName("", table);
    }

    public static ObjectName getNameForApplicationResourcePerNode(String resourceName, String applicationName, String clusterID, String serverName) throws MalformedObjectNameException {
        return ObjectNameFactory.getNameForApplicationChildPerNode(SAP_ApplicationResourcePerNode, resourceName, applicationName, clusterID, serverName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        runtimePropertyMethod = null;
        APPLICATION_PROP = null;
        try {
            Class<?> runtimeProperties = Class.forName(RUNTIME_PROPERTIES_CLASS_NAME);
            runtimePropertyMethod = runtimeProperties.getMethod(RUNTIME_PROPERTIES_GET_METHOD_NAME, Integer.TYPE);
            APPLICATION_PROP = new Object[]{runtimeProperties.getField(RUNTIME_PROPERTIES_PROPERTY_APPLICATION).get(null)};
        }
        catch (ClassNotFoundException e) {
            LOCATION.traceThrowableT(200, "unable to access rumtime properties, JMX is probably used outside the J2EE Engine", (Throwable)e);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(200, "unable to access rumtime properties, JMX is probably used outside the J2EE Engine", (Throwable)e);
        }
        try {
            MBEAN_SERVER_DELEGATE_ON = new ObjectName(MBEAN_SERVER_DELEGATE_NAME);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

