/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.util;

import com.tssap.util.xml.schema.model.SchemaReference;
import com.tssap.util.xml.schema.model.TargetNamespaceMismatchException;
import com.tssap.util.xml.schema.model.elements.ResultTag;
import com.tssap.util.xml.schema.model.elements.ScannedAttribute;
import com.tssap.util.xml.schema.model.elements.ScannedTag;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Helper {
    private static String STRING_XMLNS_PLUS_PREFIX = "xmlns:";
    private static String STRING_XMLNS_ONLY = "xmlns";
    private static String STRING_SCHEMA_LOCATION = "schemaLocation";
    private static String STRING_NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";

    public static String deleteTagBrace(String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return "";
        }
        String lTag = tagName;
        if (lTag.startsWith("</")) {
            lTag = lTag.substring(2);
        } else if (lTag.startsWith("<")) {
            lTag = lTag.substring(1);
        }
        if (lTag.endsWith("/>")) {
            lTag = lTag.substring(0, lTag.length() - 2);
        } else if (lTag.endsWith(">")) {
            lTag = lTag.substring(0, lTag.length() - 1);
        }
        return lTag;
    }

    public static Vector getSchemaReferencesFromNode(Node n) {
        Vector refs = new Vector();
        NamedNodeMap nnm = n.getAttributes();
        refs = Helper.getSchemaReferencesInNodeMap(nnm);
        return refs;
    }

    private static Vector getSchemaReferencesInNodeMap(NamedNodeMap atts) {
        Vector refs = new Vector();
        Vector<ScannedAttribute> temp = new Vector<ScannedAttribute>();
        int i = 0;
        while (i < atts.getLength()) {
            Node n = atts.item(i);
            temp.add(new ScannedAttribute(n.getNodeName(), n.getNodeValue()));
            ++i;
        }
        refs = Helper.getSchemaReferencesInAttributeTable(temp);
        return refs;
    }

    private static Vector getSchemaReferencesInAttributeTable(Vector attributes) {
        Vector<SchemaReference> references = new Vector<SchemaReference>();
        String namespace = null;
        String prefix = null;
        String location = null;
        int i = 0;
        while (i < attributes.size()) {
            ScannedAttribute attrib = (ScannedAttribute)attributes.elementAt(i);
            if (attrib.getUnQualifiedName().equals(STRING_XMLNS_ONLY)) {
                prefix = attrib.getNameSpacePrefix() != null ? attrib.getNameSpacePrefix() : "";
                namespace = attrib.getValue();
                SchemaReference srLookedUp = Helper.lookupNamespace(namespace, references);
                if (srLookedUp == null) {
                    references.add(new SchemaReference(namespace, prefix));
                } else {
                    srLookedUp.addPrefix(prefix);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < attributes.size()) {
            ScannedAttribute attrib = (ScannedAttribute)attributes.elementAt(i2);
            if (attrib.getUnQualifiedName().equals(STRING_SCHEMA_LOCATION)) {
                String completeLoc = attrib.getValue();
                StringTokenizer compLoc = new StringTokenizer(completeLoc, "\n\f ", false);
                if (!compLoc.hasMoreElements()) {
                    System.out.println("Error in xsi:schemaLocationAttribute: Invalid format");
                    return null;
                }
                namespace = (String)compLoc.nextElement();
                if (!compLoc.hasMoreElements()) {
                    System.out.println("Error in xsi:schemaLocationAttribute: Invalid format");
                    return null;
                }
                location = (String)compLoc.nextElement();
                try {
                    Helper.setLocationByNamespaceName(references, namespace, location);
                }
                catch (TargetNamespaceMismatchException tme) {
                    System.out.println(tme.getMessage());
                }
            } else if (attrib.getUnQualifiedName().equals(STRING_NO_NAMESPACE_SCHEMA_LOCATION)) {
                namespace = null;
                location = attrib.getValue();
                try {
                    Helper.setLocationByNamespaceName(references, namespace, location);
                }
                catch (TargetNamespaceMismatchException tme) {
                    System.out.println(tme.getMessage());
                }
            }
            ++i2;
        }
        return references;
    }

    private static SchemaReference lookupNamespace(String namespace, Vector references) {
        int i = 0;
        while (i < references.size()) {
            if (((SchemaReference)references.elementAt(i)).getNamespaceName().equals(namespace)) {
                return (SchemaReference)references.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    private static void setLocationByNamespaceName(Vector references, String namespaceName, String loc) throws TargetNamespaceMismatchException {
        boolean flag = false;
        int j = 0;
        while (j < references.size()) {
            if (((SchemaReference)references.get(j)).getNamespaceName().equals(namespaceName)) {
                ((SchemaReference)references.get(j)).setLocation(loc);
                flag = true;
            }
            ++j;
        }
        if (!flag) {
            throw new TargetNamespaceMismatchException();
        }
    }

    public static Vector intersection(Vector forwards, Vector reverses) {
        if (forwards == null || forwards.size() == 0) {
            return reverses;
        }
        if (reverses == null || reverses.size() == 0) {
            return forwards;
        }
        Vector resultVector = new Vector();
        if (reverses != null) {
            int i = 0;
            while (i < reverses.size()) {
                ResultTag currentTag = (ResultTag)reverses.elementAt(i);
                if (currentTag.isEmptyTag()) {
                    if (Helper.lookForTag(true, true, forwards, currentTag)) {
                        Helper.addTagToResultVector(resultVector, currentTag, 3);
                    }
                    if (Helper.lookForTag(false, false, forwards, currentTag)) {
                        Helper.addTagToResultVector(resultVector, currentTag, 0);
                    }
                } else if (currentTag.isOpenedTag()) {
                    if (Helper.lookForTag(false, false, forwards, currentTag)) {
                        Helper.addTagToResultVector(resultVector, currentTag, 0);
                    }
                    if (Helper.lookForTag(true, false, forwards, currentTag)) {
                        Helper.addTagToResultVector(resultVector, currentTag, 1);
                    }
                } else if (currentTag.isClosedTag()) {
                    if (Helper.lookForTag(true, false, forwards, currentTag)) {
                        Helper.addTagToResultVector(resultVector, currentTag, 2);
                    }
                    if (Helper.lookForTag(true, true, forwards, currentTag)) {
                        Helper.addTagToResultVector(resultVector, currentTag, 2);
                    }
                }
                ++i;
            }
        }
        return resultVector;
    }

    private static void addTagToResultVector(Vector resultVector, ResultTag currentTag, int conversionType) {
        ResultTag resTag = (ResultTag)currentTag.clone();
        resTag.setConversionType(conversionType);
        resultVector.add(resTag);
    }

    private static boolean lookForTag(boolean closed, boolean emptyTag, Vector tags, ScannedTag singleTag) {
        int i = 0;
        while (i < tags.size()) {
            ScannedTag currentTag = (ScannedTag)tags.elementAt(i);
            if (singleTag.equalsQualified(currentTag) && emptyTag == currentTag.isEmptyTag() && closed == currentTag.isClosedTag()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

