/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.nodes;

import com.tssap.util.xml.schema.model.GlobalSchemaModel;
import com.tssap.util.xml.schema.model.nodes.NodeLocationData;
import com.tssap.util.xml.schema.model.nodes.NodeWithAttributes;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PlainNode {
    private NodeLocationData locationData;
    private String name = null;
    private String ref = null;
    private String usage = null;
    private String nodeType = "";
    private String type = null;
    protected NamedNodeMap allAttributes;

    public PlainNode() {
    }

    public PlainNode(String type, Node node, NodeLocationData locationData) {
        this.nodeType = type;
        this.locationData = locationData;
        this.allAttributes = node.getAttributes();
        this.setName(node);
        this.setType(this.getType(node));
        this.setRef(node);
    }

    public PlainNode(String type, String name) {
        this.nodeType = type;
        this.name = name;
    }

    private void setRef(Node node) {
        Node nodeItem = this.allAttributes.getNamedItem("ref");
        if (nodeItem != null) {
            this.ref = nodeItem.getNodeValue();
        }
    }

    public void setType(String ptype) {
        this.type = ptype;
    }

    public String getType() {
        return this.type;
    }

    public String getNameAsItIs() {
        return this.name;
    }

    private String getType(Node node) {
        Node nodeItem = this.allAttributes.getNamedItem("type");
        if (nodeItem != null) {
            return nodeItem.getNodeValue();
        }
        return null;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String pref) {
        this.ref = pref;
    }

    public String getUnqualifiedPartName() {
        return this.getUnqualifiedPartName(0);
    }

    public String getUnqualifiedPartName(int component) {
        switch (component) {
            case 0: {
                return this.getUnqualifiedName(this.name);
            }
            case 1: {
                return this.getUnqualifiedName(this.type);
            }
            case 2: {
                return this.getUnqualifiedName(this.ref);
            }
        }
        return null;
    }

    public String getPrefix() {
        return this.getPrefix(0);
    }

    public String getPrefix(int component) {
        switch (component) {
            case 0: {
                return this.getPrefix(this.name);
            }
            case 1: {
                return this.getPrefix(this.type);
            }
            case 2: {
                return this.getPrefix(this.ref);
            }
        }
        return null;
    }

    private String getPrefix(String name) {
        int colPos = name.indexOf(58);
        if (colPos > -1) {
            return name.substring(0, colPos);
        }
        return null;
    }

    public String getNameSpaceName() {
        return this.getNameSpaceName(0);
    }

    private String getNameSpaceName(int component) {
        String prefix = this.getPrefix(component);
        return this.locationData.getNamespaceByPrefix(prefix, this.getNodeType(component));
    }

    public String getNameSpaceName(String prefix) {
        return this.locationData.getNamespaceByPrefix(prefix, this.getNodeType(0));
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getNodeType(int component) {
        switch (component) {
            case 0: {
                return this.getNodeType();
            }
            case 1: {
                return "complexType";
            }
            case 2: {
                return this.getNodeType();
            }
        }
        return null;
    }

    public void setLocationData(NodeLocationData locationData) {
        this.locationData = locationData;
    }

    protected NodeLocationData getLocationData() {
        return this.locationData;
    }

    public void setName(String pname) {
        this.name = pname;
    }

    public void setName(Node node) {
        Node nodeItem = this.allAttributes.getNamedItem("name");
        if (nodeItem != null) {
            this.name = nodeItem.getNodeValue();
        }
    }

    public NodeWithAttributes locateReferencedTagNode(GlobalSchemaModel globalModel, int component, boolean necessarilyExisting) {
        String localNodeType = null;
        switch (component) {
            case 0: {
                localNodeType = this.nodeType;
                break;
            }
            case 1: {
                localNodeType = "complexType";
                break;
            }
            case 2: {
                localNodeType = this.nodeType;
            }
        }
        return globalModel.locateReferencedTagNode(localNodeType, this.getNameSpaceName(component), this.getUnqualifiedPartName(component), necessarilyExisting);
    }

    public void setUsage(String usage) {
        if (usage.equals("reference") && this.usage != null && this.usage.equals("definition")) {
            return;
        }
        this.usage = usage;
        if (usage.equals("reference")) {
            if (this.nodeType == "complexType" && this.getType() != null) {
                this.name = this.getType();
                this.setType(null);
            } else if ((this.nodeType == "element" || this.nodeType == "group" || this.nodeType.startsWith("attribute")) && this.getRef() != null) {
                this.name = this.getRef();
                this.setRef((String)null);
            }
        }
    }

    public String getSchemaAttributeValueByName(String name) {
        if (this.allAttributes == null) {
            return null;
        }
        Node node = this.allAttributes.getNamedItem(name);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    private String getUnqualifiedName(String pName) {
        if (pName == null) {
            return null;
        }
        int colPos = pName.indexOf(58);
        if (colPos > -1) {
            return pName.substring(colPos + 1);
        }
        return pName;
    }
}

