/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.finiteAutomata;

import com.tssap.util.xml.schema.model.elements.InputWord;
import com.tssap.util.xml.schema.model.elements.ResultTag;
import com.tssap.util.xml.schema.model.elements.ScannedTag;
import com.tssap.util.xml.schema.model.elements.ScannedType;
import com.tssap.util.xml.schema.model.finiteAutomata.AbstractMachine;
import com.tssap.util.xml.schema.model.finiteAutomata.DerivedTypeFA;
import com.tssap.util.xml.schema.model.finiteAutomata.InputWordSet;
import com.tssap.util.xml.schema.model.finiteAutomata.PlainFA;
import com.tssap.util.xml.schema.model.finiteAutomata.SimulationControl;
import com.tssap.util.xml.schema.model.nodes.AttributeNode;
import java.util.Vector;

public class ElementFA
extends AbstractMachine {
    private String nameSpaceName;
    private String documentation;
    private int representingEmptyTag = 0;
    private Vector attributeVector = new Vector();
    private boolean isToBeQualified;
    private boolean typeIsNotPrimitiveOrEmpty;
    private ScannedTag firstTag;
    public static final int TAG_IS_EMPTY_OR_NOT_EMPTY = 0;
    public static final int TAG_IS_EMPTY = 1;
    public static final int TAG_IS_NOT_EMPTY = 2;

    public ElementFA(String name, Vector tags, int minOccurs, int maxOccurs, String nameSpace, boolean tinpoe) {
        super(name, tags, minOccurs, maxOccurs);
        this.nameSpaceName = nameSpace;
        this.typeIsNotPrimitiveOrEmpty = tinpoe;
    }

    public Object clone() {
        return new ElementFA(this.name, this.childTags, this.minOccurs, this.maxOccurs, this.nameSpaceName, this.typeIsNotPrimitiveOrEmpty);
    }

    public void addAttribute(Vector attributes) {
        this.attributeVector.addAll(attributes);
    }

    public void addDocu(String docu) {
        this.documentation = docu;
    }

    public String getNameSpaceName() {
        return this.nameSpaceName;
    }

    public boolean isToBeQualified() {
        return this.isToBeQualified;
    }

    public void setToBeQualified(boolean itbq) {
        this.isToBeQualified = itbq;
    }

    public boolean representsEmptyTag() {
        if (this.representingEmptyTag == 0) {
            this.representingEmptyTag = (this.childTags == null || this.childTags.elementAt(0) instanceof DerivedTypeFA && ((DerivedTypeFA)this.childTags.elementAt(0)).representsEmptyType()) && this.typeIsNotPrimitiveOrEmpty ? 1 : 2;
        }
        return this.representingEmptyTag == 1;
    }

    private ResultTag getOpenTag() {
        boolean closed = this.simCon.getDirection() != AbstractMachine.SIMULATION_DIRETION_FORWARD;
        return new ResultTag(this.name, closed, false, this.nameSpaceName, this.isToBeQualified, super.isAbstract(), this.documentation);
    }

    private ResultTag getClosedTag() {
        boolean closed = this.simCon.getDirection() == AbstractMachine.SIMULATION_DIRETION_FORWARD;
        return new ResultTag(this.name, closed, false, this.nameSpaceName, this.isToBeQualified, super.isAbstract(), this.documentation);
    }

    private ResultTag getEmptyTag() {
        boolean closed = this.simCon.getDirection() == AbstractMachine.SIMULATION_DIRETION_FORWARD;
        return new ResultTag(this.name, closed, true, this.nameSpaceName, this.isToBeQualified, super.isAbstract(), this.documentation);
    }

    public ElementFA() {
    }

    public ElementFA(String name, Vector tags) {
        this(name, tags, 1, 1);
    }

    public ElementFA(String name, Vector tags, int minOccurs, int maxOccurs) {
        super(name, tags, minOccurs, maxOccurs);
        this.name = name;
    }

    public void setOnlyChild(AbstractMachine child) {
        this.childTags = new Vector();
        this.childTags.add(child);
    }

    protected Vector getPossibleTagsAtStart(SimulationControl simCon, Vector checkMachines) {
        this.simCon = simCon;
        Vector<ResultTag> v = new Vector<ResultTag>();
        if (this.representsEmptyTag()) {
            v.add(this.getEmptyTag());
        } else {
            v.add(this.getOpenTag());
        }
        if (simCon.getDirection() == AbstractMachine.SIMULATION_DIRETION_BACKWARD && !this.noChildren() && !checkMachines.contains(this)) {
            checkMachines.add(this);
            AbstractMachine child = this.getChild(0, null);
            if (child == null) {
                v = new Vector();
            } else {
                v.addAll(child.getPossibleTagsAtStart(simCon, checkMachines));
            }
        }
        return v;
    }

    protected AbstractMachine getChild(int i, ScannedType derivedType) {
        PlainFA child = (PlainFA)this.childTags.elementAt(0);
        if (child instanceof DerivedTypeFA) {
            child = ((DerivedTypeFA)child).getDerivedMachine(derivedType, this.simCon);
        }
        if (child == null) {
            return null;
        }
        return child.getYourself();
    }

    public void propagateInputsSingleCycle(InputWordSet inputs) {
        if (inputs.isEmpty()) {
            return;
        }
        ResultTag checkTag = this.getOpenTag();
        this.checkTagOccurence(inputs, checkTag);
        if (this.simCon.isSimulationForAttributes() && this.currentCycleWords.containsEmptyWord()) {
            this.currentCycleWords.deleteEmptyWord();
            this.getPossibleAttributesForSimulation();
            return;
        }
        if (this.currentCycleWords.isEmpty()) {
            return;
        }
        if (!this.noChildren() && !this.firstTag.isSisterTag()) {
            this.currentCycleWords = this.propagateInputsSingleCycleForChild(this.currentCycleWords, 0, this.firstTag.getDerivedType());
        }
        if (this.currentCycleWords == null) {
            return;
        }
        this.checkTagOccurence((InputWordSet)this.currentCycleWords.clone(), this.getClosedTag());
        if (this.simCon.isSimulationForAttributes() && this.currentCycleWords.containsEmptyWord()) {
            this.currentCycleWords.deleteEmptyWord();
            this.getPossibleAttributesForSimulation();
            return;
        }
    }

    public Vector getAttributes() {
        return this.attributeVector;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    private void getPossibleAttributesForSimulation() {
        if (this.childTags != null && this.childTags.size() > 0 && this.childTags.elementAt(0) instanceof DerivedTypeFA) {
            DerivedTypeFA derivedMachine = (DerivedTypeFA)this.childTags.elementAt(0);
            if (derivedMachine.derivedTypesExistent()) {
                AttributeNode attNode = AttributeNode.getTypeNodeForDerivableTypes(derivedMachine.isAbstract());
                attNode.setValues(derivedMachine.getDerivedNames(true));
                this.possibleTags.add(attNode);
            }
            if (this.firstTag.getDerivedType() != null && !this.firstTag.getDerivedType().getUnQualifiedName().equals("")) {
                derivedMachine = (DerivedTypeFA)((DerivedTypeFA)this.childTags.elementAt(0)).getDerivedMachine(this.firstTag.getDerivedType(), this.simCon, true);
            }
            if (derivedMachine != null) {
                this.possibleTags.addAll(derivedMachine.getAttributes());
            }
        } else {
            this.possibleTags.addAll(this.getAttributes());
        }
    }

    protected void setSimCon(SimulationControl simCon) {
        this.simCon = simCon;
    }

    public boolean noChildren() {
        if (super.noChildren()) {
            return true;
        }
        PlainFA son = (PlainFA)this.childTags.elementAt(0);
        if (son instanceof DerivedTypeFA) {
            return ((DerivedTypeFA)son).noChildren();
        }
        return false;
    }

    private void checkTagOccurence(InputWordSet inputs, ResultTag tag) {
        this.currentCycleWords.clear();
        this.checkEmptyWordInInputs(inputs, tag);
        int i = 0;
        while (i < inputs.size()) {
            InputWord word = (InputWord)inputs.get(i);
            if (word != null && word.getFirstTag().equalsUnqualified(tag) && word.getFirstTag().isClosedTag() == tag.isClosedTag()) {
                this.firstTag = word.getFirstTag();
                this.currentCycleWords.add(word.getRemainingTags());
            }
            ++i;
        }
    }
}

