/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.finiteAutomata;

import com.tssap.util.xml.schema.model.elements.InputWord;
import com.tssap.util.xml.schema.model.elements.ResultTag;
import com.tssap.util.xml.schema.model.elements.ScannedType;
import com.tssap.util.xml.schema.model.finiteAutomata.InputWordSet;
import com.tssap.util.xml.schema.model.finiteAutomata.PlainFA;
import com.tssap.util.xml.schema.model.finiteAutomata.SimulationControl;
import java.util.Vector;

public abstract class AbstractMachine
extends PlainFA {
    public static int SIMULATION_DIRETION_FORWARD = 0;
    public static int SIMULATION_DIRETION_BACKWARD = 1;
    public static int TAG_SEARCH_MODE_NORMAL = 0;
    public static int TAG_SEARCH_MODE_ALL_INNER_TAGS = 1;
    protected InputWordSet outputWords;
    protected InputWordSet currentCycleWords;
    protected Vector possibleTags;
    protected int minOccurs = 0;
    protected int maxOccurs = 0;
    protected int Occurs = 0;
    protected Vector childTags = null;
    protected SimulationControl simCon;
    protected String name;

    public AbstractMachine() {
    }

    public AbstractMachine(String name, Vector tags, int minOccurs, int maxOccurs) {
        this.name = name;
        this.childTags = tags;
        if (maxOccurs == 0) {
            minOccurs = 0;
        }
        if (maxOccurs < minOccurs) {
            maxOccurs = minOccurs;
        }
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.possibleTags = new Vector();
    }

    public boolean isOptional(SimulationControl simCon) {
        return this.minOccurs == 0;
    }

    public void setOptional() {
        this.minOccurs = 0;
    }

    public abstract Object clone();

    public AbstractMachine(String name, Vector tags) {
        this(name, tags, 1, 1);
    }

    public void setChildTags(Vector children) {
        this.childTags = children;
    }

    public void setName(String pName) {
        this.name = pName;
    }

    protected abstract Vector getPossibleTagsAtStart(SimulationControl var1, Vector var2);

    protected void checkEmptyWordInInputs(InputWordSet inputs, ResultTag tag) {
        if (inputs.containsEmptyWord()) {
            inputs.deleteEmptyWord();
            if (!this.simCon.isSimulationForAttributes()) {
                this.possibleTags.add(tag);
            }
        }
    }

    protected boolean checkEmptyWordInInputs(InputWordSet inputs, AbstractMachine am) {
        if (inputs.containsEmptyWord()) {
            inputs.deleteEmptyWord();
            if (!this.simCon.isSimulationForAttributes()) {
                this.possibleTags.addAll(am.getPossibleTagsAtStart(this.simCon, new Vector()));
            }
            return true;
        }
        return false;
    }

    public void propagateInputsCompletely(InputWordSet inputs, SimulationControl simCon) {
        this.simCon = simCon;
        this.currentCycleWords = new InputWordSet();
        this.outputWords = new InputWordSet();
        this.possibleTags.clear();
        this.Occurs = 0;
        this.propagateInputs(inputs);
    }

    public Vector propagateInputCompletely(InputWord input, SimulationControl simCon) {
        this.propagateInputsCompletely(new InputWordSet(input), simCon);
        return this.getPossibleTags();
    }

    public AbstractMachine getYourself() {
        return this;
    }

    protected AbstractMachine getChild(int i) {
        return this.getChild(i, null);
    }

    protected AbstractMachine getChild(int i, ScannedType derivedType) {
        if (this.childTags.size() > i) {
            return ((PlainFA)this.childTags.get(i)).getYourself();
        }
        return null;
    }

    protected void addChild(AbstractMachine machine, int index) {
        this.childTags.add(index, machine);
    }

    protected void addChild(AbstractMachine machine) {
        this.childTags.add(machine);
    }

    public boolean noChildren() {
        return this.childTags == null || this.childTags.size() == 0;
    }

    private void propagateInputs(InputWordSet inputs) {
        boolean outputsAugmented = false;
        if (this.maxOccurs == 0) {
            return;
        }
        if (this.isOptional(this.simCon) && this.Occurs == 0) {
            this.outputWords.addAll(inputs);
        }
        this.currentCycleWords.clear();
        this.propagateInputsSingleCycle(inputs);
        if (this.currentCycleWords != null && !this.currentCycleWords.isEmpty()) {
            ++this.Occurs;
            if (this.Occurs <= this.maxOccurs) {
                if (this.Occurs >= this.minOccurs) {
                    int i = 0;
                    while (i < this.currentCycleWords.size()) {
                        if (!this.outputWords.contains(this.currentCycleWords.elementAt(i))) {
                            this.outputWords.add(this.currentCycleWords.elementAt(i));
                            outputsAugmented = true;
                        }
                        ++i;
                    }
                }
                if (this.Occurs < this.maxOccurs && (this.simCon.getDirection() != SIMULATION_DIRETION_BACKWARD || outputsAugmented)) {
                    InputWordSet newRunInputs = (InputWordSet)this.currentCycleWords.clone();
                    this.propagateInputs(newRunInputs);
                }
            }
        }
    }

    public abstract void propagateInputsSingleCycle(InputWordSet var1);

    protected InputWordSet propagateInputsSingleCycleForChild(InputWordSet inputs, int childNumber, ScannedType derivedType) {
        AbstractMachine am = this.getChild(childNumber, derivedType);
        if (am != null) {
            am.propagateInputsCompletely(inputs, this.simCon);
            this.possibleTags.addAll(am.getPossibleTags());
            am.getPossibleTags().clear();
            return am.getTailWords();
        }
        return null;
    }

    public InputWordSet getTailWords() {
        if (this.simCon.isSimulationForAttributes() && this.possibleTags != null && this.possibleTags.size() > 0) {
            return new InputWordSet();
        }
        InputWordSet outWords = (InputWordSet)this.outputWords.clone();
        this.outputWords = new InputWordSet();
        return outWords;
    }

    public Vector getPossibleTags() {
        return this.possibleTags;
    }
}

