/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.elements;

public class XmlStringHelper {
    private static final String WHITE_SPACES = " \n\t\f\r";

    public static String removeForwardslashWhenClosed(String inStr) {
        if (inStr.length() == 0) {
            return inStr;
        }
        if (inStr.indexOf(47) == 0) {
            return inStr.substring(1, inStr.length());
        }
        if (inStr.indexOf(47) == inStr.length() - 1) {
            inStr = inStr.substring(0, inStr.length() - 1);
            return inStr;
        }
        return inStr;
    }

    public static boolean isWhiteSpace(char c) {
        return WHITE_SPACES.indexOf(c) > -1;
    }

    public static boolean hasWhiteSpaces(String inString, int startPos, int endPos) {
        int i = startPos;
        while (i < endPos) {
            if (XmlStringHelper.isWhiteSpace(inString.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int firstIndexOfWhiteSpace(String inString) {
        int i = 0;
        while (i < inString.length()) {
            if (XmlStringHelper.isWhiteSpace(inString.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOfWhiteSpace(String inString) {
        int i = inString.length() - 1;
        while (i >= 0) {
            if (XmlStringHelper.isWhiteSpace(inString.charAt(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static boolean lookForStringInString(String inString, char c, int startPos, int endPos) {
        int i = startPos;
        while (i < endPos) {
            if (inString.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int previousIndexOf(char c, String inStr, int fromPos) {
        int i = fromPos - 1;
        while (i >= 0) {
            if (inStr.charAt(i) == c) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int previousIndexOfUpto(char c, char stoppChar, String inStr, int fromPos) {
        int i = fromPos - 1;
        while (i >= 0) {
            if (inStr.charAt(i) == c) {
                return i;
            }
            if (inStr.charAt(i) == stoppChar) {
                return -1;
            }
            --i;
        }
        return -1;
    }

    public static int previousIndexOfNonWhitespace(String inStr, int caretPosition) {
        int i = caretPosition - 1;
        while (i >= 0) {
            if (XmlStringHelper.isWhiteSpace(inStr.charAt(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static String findPreviousAttributeNameFromCaretPos(String inStr, int caretPosition) {
        String attributeName = null;
        int index = caretPosition;
        if (inStr.indexOf(61) > -1 && inStr.indexOf(61) < caretPosition) {
            char temp = inStr.charAt(caretPosition - 1);
            while (temp != '=' || temp == '<') {
                temp = inStr.charAt(--index);
            }
            int attNameEndIndex = XmlStringHelper.isWhiteSpace(inStr.charAt(index - 1)) ? XmlStringHelper.previousIndexOfNonWhitespace(inStr, index) : index;
            int attNameStartIndex = XmlStringHelper.previousIndexOfNonWhitespace(inStr, attNameEndIndex);
            attributeName = inStr.substring(attNameStartIndex, attNameEndIndex).trim();
        }
        return attributeName;
    }

    public static int getSmallerPositiveIndex(int index1, int index2) {
        int finalIndex = -1;
        finalIndex = index1 > -1 && index2 > -1 ? (index1 > index2 ? index2 : index1) : (index1 > -1 ? index1 : index2);
        return finalIndex;
    }
}

