/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.elements;

import com.tssap.util.xml.schema.model.elements.ScannedAttribute;
import com.tssap.util.xml.schema.model.elements.ScannedElement;
import com.tssap.util.xml.schema.model.elements.ScannedType;
import com.tssap.util.xml.schema.model.elements.XmlStringHelper;
import java.util.Vector;

public class ScannedTag
extends ScannedElement {
    private boolean isClosed;
    private boolean isEmpty;
    private boolean isSisterTag;
    private boolean isParent = false;
    private ScannedType derivedType = null;
    private Vector attributes = new Vector();

    public ScannedTag() {
        this("", false);
    }

    public ScannedTag(String name, boolean closed) {
        this(name, closed, false, false);
    }

    public ScannedTag(String name, boolean closed, boolean isEmpty) {
        this(name, closed, isEmpty, false);
    }

    public ScannedTag(String name, boolean closed, boolean isEmpty, boolean scanAttributes) {
        name = XmlStringHelper.removeForwardslashWhenClosed(name);
        int spacePosition = XmlStringHelper.firstIndexOfWhiteSpace(name);
        if (spacePosition > -1) {
            if (scanAttributes) {
                this.scanAttributesString(name.substring(spacePosition, name.length()).trim());
            }
            name = name.substring(0, spacePosition).trim();
        }
        this.setName(name);
        this.isClosed = closed;
        this.isEmpty = isEmpty;
    }

    public Object clone() {
        ScannedTag st = new ScannedTag(this.getQualifiedName(), this.isClosed, this.isEmpty, false);
        st.setNameSpaceName(super.getNameSpaceName());
        return st;
    }

    public ScannedTag getCorrespondingTag() {
        ScannedTag tag = new ScannedTag(this.getQualifiedName(), !this.isClosed, this.isEmpty);
        if (this.isParent) {
            tag.setParent();
        }
        return tag;
    }

    private String attributeValueTrim(String value) {
        if (value.charAt(value.length() - 1) == '\"') {
            value = value.substring(0, value.length() - 1);
        }
        if (value.charAt(0) == '\"') {
            value = value.substring(1);
        }
        return value;
    }

    private void scanAttributesString(String attributesString) {
        if (attributesString != null && attributesString.length() > 0) {
            int position = attributesString.indexOf(61);
            while (position != -1) {
                String attValue = "";
                String attName = attributesString.substring(0, position).trim();
                if ((attributesString = attributesString.substring(position + 1, attributesString.length()).trim()).length() != 0 && (attributesString.charAt(0) == '\"' || attributesString.charAt(0) == '\'')) {
                    int doubleQuoteIndex;
                    String charToDelete = null;
                    int searchFrom = 1;
                    int finalIndex = 0;
                    int singleQuoteIndex = attributesString.indexOf(39, searchFrom);
                    finalIndex = XmlStringHelper.getSmallerPositiveIndex(singleQuoteIndex, doubleQuoteIndex = attributesString.indexOf(34, searchFrom));
                    if (finalIndex == -1) {
                        this.attributes.add(new ScannedAttribute(attName, attValue));
                        attributesString = "";
                        break;
                    }
                    attValue = attributesString.substring(1, finalIndex);
                    attributesString = charToDelete != null ? attributesString.substring(attributesString.indexOf(charToDelete, attValue.length()) + 1, attributesString.length()).trim() : attributesString.substring(finalIndex + 1, attributesString.length()).trim();
                }
                this.attributes.add(new ScannedAttribute(attName, attValue));
                position = attributesString.indexOf(61);
            }
        }
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public boolean tagCorresponds(ScannedTag st) {
        boolean temp = true;
        if (st.getNameSpaceName() != null && this.getNameSpaceName() != null) {
            temp = st.getNameSpaceName().equals(this.getNameSpaceName());
        }
        return st.getUnQualifiedName().equals(this.getUnQualifiedName()) && st.isEmpty == this.isEmpty && this.isClosed != st.isClosedTag() && temp;
    }

    public void setParent() {
        this.isParent = true;
    }

    public void setSisterTag() {
        this.isSisterTag = true;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean isSisterTag() {
        return this.isSisterTag;
    }

    public boolean isOpenedTag() {
        return !this.isClosed || this.isEmpty;
    }

    public boolean isClosedTag() {
        return this.isClosed || this.isEmpty;
    }

    public boolean isEmptyTag() {
        return this.isEmpty;
    }

    public void setDerivedType(ScannedType type) {
        this.derivedType = type;
    }

    public ScannedType getDerivedType() {
        return this.derivedType;
    }

    public void print() {
        if (this.getNameSpacePrefix() != null) {
            System.out.print(" Scanned Tag: " + this.getQualifiedName());
        } else {
            System.out.print(" Scanned Tag: " + this.getUnQualifiedName());
        }
        if (this.isParent) {
            System.out.print(" parent");
            System.out.print(" attributes: " + this.getAttributes());
            System.out.print(" namespacePrefix: " + this.getNameSpacePrefix());
        }
        if (this.isClosedTag()) {
            System.out.print(" closed");
        } else {
            System.out.print(" opened");
        }
        if (this.isSisterTag()) {
            System.out.print(" sister");
        }
        if (this.isEmptyTag()) {
            System.out.print(" empty");
        }
        System.out.print("   derived Type: " + this.getDerivedType());
        System.out.println();
    }
}

