/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.dispatchers;

import com.tssap.util.xml.schema.model.SchemaReference;
import com.tssap.util.xml.schema.model.TargetNamespaceMismatchException;
import com.tssap.util.xml.schema.model.dispatchers.DomModifierI;
import com.tssap.util.xml.schema.model.dispatchers.ReferenceGetterI;
import com.tssap.util.xml.schema.model.dispatchers.XsdDispatcher;
import com.tssap.util.xml.schema.model.elements.ScannedAttribute;
import com.tssap.util.xml.schema.model.elements.ScannedTag;
import com.tssap.util.xml.schema.model.util.PathManager;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlDispatcher
implements DomModifierI,
ReferenceGetterI {
    private final String TYPE = "anonymousType";
    private static int nameCounter = 0;
    private static String STRING_XMLNS_PLUS_PREFIX = "xmlns:";
    private static String STRING_XMLNS_ONLY = "xmlns";
    private static String STRING_SCHEMA_LOCATION = "schemaLocation";
    private static String STRING_NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";

    public Node modifyDom(Document xmlDoc, String prefix) {
        if (xmlDoc != null) {
            Element rootNode = xmlDoc.getDocumentElement();
            if (!(this instanceof XsdDispatcher)) {
                this.insertDatatypesImport(xmlDoc);
            }
            this.dfsForAnonymousTypes(rootNode, rootNode, xmlDoc, prefix, null);
        }
        return xmlDoc.getDocumentElement();
    }

    public Vector getMetaDataReferences(String editorText) {
        Vector refs = this.createAttributeTableFromString(editorText);
        return this.getSchemaReferencesInAttributeTable(refs);
    }

    private void incrementCounter() {
        ++nameCounter;
    }

    private void insertDatatypesImport(Document schemaDoc) {
        NamedNodeMap attributeList = schemaDoc.getDocumentElement().getAttributes();
        int i = 0;
        while (i < attributeList.getLength()) {
            if (attributeList.item(i).getNodeName().equals("targetNamespace") && attributeList.item(i).getNodeValue().equals("http://www.w3.org/2001/XMLSchema")) {
                return;
            }
            ++i;
        }
        String path = PathManager.getAbsolutePluginPath();
        this.appendImportNodeAsChild(schemaDoc, "http://www.w3.org/2001/XMLSchema", path + "insight\\xml\\metaSchemas\\schema.xsd");
    }

    private void appendImportNodeAsChild(Document schemaDoc, String namespaceName, String path) {
        Element root = schemaDoc.getDocumentElement();
        Element importNode = null;
        importNode = root.getPrefix() != null ? schemaDoc.createElement(root.getPrefix() + ":" + "import") : schemaDoc.createElement("import");
        Attr namespaceAttribute = schemaDoc.createAttribute("namespace");
        namespaceAttribute.setNodeValue(namespaceName);
        Attr schemaLocationAttribute = schemaDoc.createAttribute(STRING_SCHEMA_LOCATION);
        schemaLocationAttribute.setNodeValue(path);
        NamedNodeMap attList = importNode.getAttributes();
        attList.setNamedItem(namespaceAttribute);
        attList.setNamedItem(schemaLocationAttribute);
        root.appendChild(importNode);
    }

    private String dfsForAnonymousTypes(Node rootNode, Node node, Document schemaDoc, String prefix, String inNodeName) {
        String nodeName = inNodeName;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1) {
                nodeName = this.dfsForAnonymousTypes(rootNode, childNodes.item(i), schemaDoc, prefix, nodeName);
            }
            ++i;
        }
        if (node.getNodeName().endsWith("extension") || node.getNodeName().endsWith("restriction")) {
            return node.getNodeName();
        }
        if (nodeName != null) {
            if (node.getNodeName().endsWith("union") || node.getNodeName().endsWith("list")) {
                return null;
            }
            if ((nodeName.endsWith("extension") || nodeName.endsWith("restriction")) && (node.getNodeName().endsWith("complexType") || node.getNodeName().endsWith("simpleType"))) {
                boolean validFlag = true;
                NamedNodeMap atts = node.getAttributes();
                int i2 = 0;
                while (i2 < atts.getLength()) {
                    Node n = atts.item(i2);
                    if (n.getNodeName() != null && n.getNodeName().equals("name")) {
                        validFlag = false;
                    }
                    ++i2;
                }
                if (validFlag) {
                    String name = "anonymousType" + nameCounter;
                    ++nameCounter;
                    Attr nameAtt = schemaDoc.createAttribute("name");
                    nameAtt.setNodeValue(name);
                    atts.setNamedItem(nameAtt);
                    Node copy = node.cloneNode(true);
                    Node parent = node.getParentNode();
                    parent.removeChild(node);
                    rootNode.appendChild(copy);
                    return name;
                }
                return null;
            }
            if (node.getNodeName().endsWith("element") || node.getNodeName().endsWith("attribute")) {
                NamedNodeMap atts = node.getAttributes();
                Attr typeAtt = schemaDoc.createAttribute("type");
                if (prefix != null) {
                    typeAtt.setNodeValue(prefix + ":" + nodeName);
                } else {
                    typeAtt.setNodeValue(nodeName);
                }
                atts.setNamedItem(typeAtt);
                nodeName = null;
            }
        }
        return nodeName;
    }

    private static void setLocationByNamespaceName(Vector references, String namespaceName, String loc) throws TargetNamespaceMismatchException {
        boolean flag = false;
        int j = 0;
        while (j < references.size()) {
            if (((SchemaReference)references.get(j)).getNamespaceName().equals(namespaceName)) {
                ((SchemaReference)references.get(j)).setLocation(loc);
                flag = true;
            }
            ++j;
        }
        if (!flag) {
            throw new TargetNamespaceMismatchException();
        }
    }

    private Vector createAttributeTableFromString(String lXmlText) {
        if (lXmlText == null || lXmlText.length() == 0) {
            return null;
        }
        StringTokenizer lTokenizer = new StringTokenizer(lXmlText, "<", false);
        String lToken = null;
        while (lTokenizer.hasMoreTokens()) {
            lToken = lTokenizer.nextToken().trim();
            if (lToken.length() <= 0 || lToken.charAt(0) == '?' || lToken.charAt(0) == '!') continue;
            lToken = lToken.substring(0, lToken.indexOf(62));
            ScannedTag st = new ScannedTag(lToken, false, false, true);
            return st.getAttributes();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Vector getSchemaReferencesInAttributeTable(Vector attributes) {
        if (attributes == null) {
            return null;
        }
        references = new Vector<SchemaReference>();
        namespace = null;
        prefix = null;
        location = null;
        i = 0;
        while (i < attributes.size()) {
            attrib = (ScannedAttribute)attributes.elementAt(i);
            if (attrib.getUnQualifiedName().equals(XmlDispatcher.STRING_XMLNS_ONLY)) {
                prefix = attrib.getNameSpacePrefix() != null ? attrib.getNameSpacePrefix() : "";
                namespace = attrib.getValue();
                srLookedUp = this.lookupNamespace(namespace, references);
                if (srLookedUp == null) {
                    references.add(new SchemaReference(namespace, prefix));
                } else {
                    srLookedUp.addPrefix(prefix);
                }
            }
            ++i;
        }
        i = 0;
        while (i < attributes.size()) {
            block14: {
                block13: {
                    attrib = (ScannedAttribute)attributes.elementAt(i);
                    if (!attrib.getUnQualifiedName().equals(XmlDispatcher.STRING_SCHEMA_LOCATION)) break block13;
                    completeLoc = attrib.getValue();
                    compLoc = new StringTokenizer(completeLoc, "\t\n\f ", false);
                    if (!compLoc.hasMoreElements()) {
                        System.out.println("Error in xsi:schemaLocationAttribute: Invalid format");
                        return null;
                    }
                    namespace = ((String)compLoc.nextElement()).trim();
                    if (compLoc.hasMoreElements()) ** GOTO lbl35
                    System.out.println("Error in xsi:schemaLocationAttribute: Invalid format");
                    return null;
lbl-1000:
                    // 1 sources

                    {
                        location = location != null ? location + " " + (String)compLoc.nextElement() : (String)compLoc.nextElement();
lbl35:
                        // 2 sources

                        ** while (compLoc.hasMoreElements())
                    }
lbl36:
                    // 1 sources

                    location = location.trim();
                    try {
                        XmlDispatcher.setLocationByNamespaceName(references, namespace, location);
                    }
                    catch (TargetNamespaceMismatchException tme) {
                        System.out.println(tme.getMessage());
                    }
                    break block14;
                }
                if (attrib.getUnQualifiedName().equals(XmlDispatcher.STRING_NO_NAMESPACE_SCHEMA_LOCATION)) {
                    namespace = null;
                    location = attrib.getValue();
                    try {
                        XmlDispatcher.setLocationByNamespaceName(references, namespace, location);
                    }
                    catch (TargetNamespaceMismatchException tme) {
                        System.out.println(tme.getMessage());
                    }
                }
            }
            ++i;
        }
        return references;
    }

    private SchemaReference lookupNamespace(String namespace, Vector references) {
        int i = 0;
        while (i < references.size()) {
            if (((SchemaReference)references.elementAt(i)).getNamespaceName().equals(namespace)) {
                return (SchemaReference)references.elementAt(i);
            }
            ++i;
        }
        return null;
    }
}

