/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model.dispatchers;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.tssap.util.xml.DOMAccess;
import com.tssap.util.xml.DOMParserI;
import com.tssap.util.xml.schema.model.SchemaReference;
import com.tssap.util.xml.schema.model.dispatchers.DomModifierI;
import com.tssap.util.xml.schema.model.dispatchers.ReferenceGetterI;
import com.tssap.util.xml.schema.model.util.PathManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JspDispatcher
implements DomModifierI,
ReferenceGetterI {
    private Hashtable aliasTable = new Hashtable();
    private static final String PATH_TO_ALIASFILE = "insight/jsp/TagLibAlias.xml";
    private static final String PATH_TO_JSPTLD = "insight/jsp/taglib11/jsp.tld";

    public JspDispatcher() {
        this.initialiseAliasTable();
    }

    private void initialiseAliasTable() {
        Element rootNode = null;
        DOMParserI lParser = DOMAccess.getDOMParser();
        try {
            Document lDocument = lParser.parse(PathManager.getAbsolutePluginPath() + PATH_TO_ALIASFILE, true);
            rootNode = lDocument.getDocumentElement();
        }
        catch (Throwable t) {
            System.out.println("TagLibAlias file not available, no support for taglib aliases for Jsp Insight.");
            return;
        }
        NodeList nl = rootNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 1 && "taglib".equals(nl.item(i).getNodeName().toLowerCase())) {
                NamedNodeMap attribs = nl.item(i).getAttributes();
                int j = 0;
                while (j < attribs.getLength()) {
                    if (attribs.item(j).getNodeValue() != null && "alias".equals(attribs.item(j).getNodeName().toLowerCase())) {
                        this.aliasTable.put(attribs.item(j).getNodeValue(), nl.item(i).getFirstChild().getNodeValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public Node modifyDom(Document xmlDoc, String locationUri) {
        Document metaSchema = null;
        String prefix = null;
        Element rootNode = xmlDoc.getDocumentElement();
        NodeList childNodes = rootNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1 && "shortname".equals(childNodes.item(i).getNodeName().toLowerCase())) {
                prefix = childNodes.item(i).getFirstChild().getNodeValue().toLowerCase();
                System.out.println("Prefix: " + prefix);
                break;
            }
            ++i;
        }
        if (prefix == null && prefix.length() < 1) {
            System.out.println("No shortname specified in tld, so a prefix cannot be determinted, Abort");
            return null;
        }
        metaSchema = this.newEmptyDocument();
        this.writeDocumentRootNode(metaSchema, prefix, locationUri);
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            if (childNodes.item(i2).getNodeType() == 1) {
                this.analyseChildNode(childNodes.item(i2), metaSchema);
            }
            ++i2;
        }
        return metaSchema.getDocumentElement();
    }

    public Vector getMetaDataReferences(String editorText) {
        Vector<SchemaReference> tagLibReferences = new Vector<SchemaReference>();
        boolean foundJspDirective = false;
        String text = editorText;
        while (text.lastIndexOf("<%@") > -1) {
            String temp = text.substring(text.lastIndexOf("<%@"), text.indexOf(">", text.lastIndexOf("<%@")) + 1);
            if (temp.indexOf("taglib") > -1 && temp.indexOf("uri=\"") > -1 && temp.indexOf("prefix=\"") > -1) {
                String loc = temp.substring(temp.indexOf("uri=\"") + "uri=\"".length(), temp.indexOf("\"", temp.indexOf("uri=\"") + "uri=\"".length()));
                loc = loc.trim();
                String pre = temp.substring(temp.indexOf("prefix=\"") + "prefix=\"".length(), temp.indexOf("\"", temp.indexOf("prefix=\"") + "prefix=\"".length()));
                if ((pre = pre.trim()).equals("jsp")) {
                    foundJspDirective = true;
                }
                tagLibReferences.add(new SchemaReference(loc, pre, loc));
            }
            text = text.substring(0, text.lastIndexOf("<%@"));
        }
        if (!foundJspDirective) {
            tagLibReferences.add(new SchemaReference(PathManager.getAbsolutePluginPath() + PATH_TO_JSPTLD, "jsp", PathManager.getAbsolutePluginPath() + PATH_TO_JSPTLD));
        }
        int i = 0;
        while (i < tagLibReferences.size()) {
            if (this.aliasTable.containsKey(((SchemaReference)tagLibReferences.elementAt(i)).getLocation())) {
                String alias = (String)this.aliasTable.get(((SchemaReference)tagLibReferences.elementAt(i)).getLocation());
                ((SchemaReference)tagLibReferences.elementAt(i)).setLocation(alias);
                ((SchemaReference)tagLibReferences.elementAt(i)).setNamespaceName(alias);
            }
            ++i;
        }
        return tagLibReferences;
    }

    private Document newEmptyDocument() {
        try {
            DocumentBuilderFactoryImpl docBuilderFac = new DocumentBuilderFactoryImpl();
            DocumentBuilder doc = docBuilderFac.newDocumentBuilder();
            return doc.newDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writeDocumentRootNode(Document metaSchema, String prefix, String locationUri) {
        Element docRoot = metaSchema.createElement("xsd:schema");
        docRoot.setAttribute("targetNamespace", locationUri);
        docRoot.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        docRoot.setAttribute("xmlns:" + prefix, locationUri);
        docRoot.setAttribute("xmlns", locationUri);
        metaSchema.appendChild(docRoot);
    }

    private Element getNewNode(String nodeName, Document doc) {
        return doc.createElement(nodeName);
    }

    private void addAttributeToElement(Element elem, String attributeName, String value) {
        elem.setAttribute(attributeName, value);
    }

    private void addAttributesToElement(Hashtable table, Element elem) {
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            String attribtueValue = (String)table.get(attributeName);
            this.addAttributeToElement(elem, attributeName, attribtueValue);
        }
    }

    private Node inertNewTagLibElement(Document doc, String attributeName, String attributeValue) {
        Element elem = doc.createElement("xsd:element");
        this.addAttributeToElement(elem, "form", "qualified");
        this.addAttributeToElement(elem, attributeName, attributeValue);
        elem.appendChild(this.getNewNode("xsd:complexType", doc));
        doc.getDocumentElement().appendChild(elem);
        return elem;
    }

    public void analyseChildNode(Node child, Document doc) {
        if (child.getNodeName().equals("tag")) {
            String value = null;
            Node generatedChild = null;
            NodeList nl = child.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node childOfTag = nl.item(i);
                if (child.getNodeType() == 1) {
                    int j;
                    NodeList list;
                    if (childOfTag.getNodeName().equals("name")) {
                        value = childOfTag.getFirstChild().getNodeValue();
                        generatedChild = this.inertNewTagLibElement(doc, "name", value);
                    } else if (childOfTag.getNodeName().equals("bodycontent")) {
                        if (childOfTag.getFirstChild() != null && childOfTag.getFirstChild().getNodeValue().toLowerCase().equals("jsp")) {
                            list = generatedChild.getChildNodes();
                            j = 0;
                            while (j < list.getLength()) {
                                if (list.item(j).getNodeType() == 1 && list.item(j).getNodeName().equals("xsd:complexType")) {
                                    list.item(j).appendChild(this.getNewNode("xsd:sequence", doc));
                                }
                                ++j;
                            }
                        }
                    } else if (childOfTag.getNodeName().equals("attribute")) {
                        list = generatedChild.getChildNodes();
                        j = 0;
                        while (j < list.getLength()) {
                            Node childN = list.item(j);
                            if (childN.getNodeType() == 1 && childN.getNodeName().equals("xsd:complexType")) {
                                Element newAtt = this.getNewNode("xsd:attribute", doc);
                                Hashtable table = this.getValuesForAttributeChild(childOfTag);
                                this.addAttributesToElement(table, newAtt);
                                childN.appendChild(newAtt);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private Hashtable getValuesForAttributeChild(Node attributeChild) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        NodeList nl = attributeChild.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 1) {
                if (nl.item(i).getNodeName().equals("name")) {
                    table.put("name", nl.item(i).getFirstChild().getNodeValue());
                }
                if (nl.item(i).getNodeName().equals("required")) {
                    if (nl.item(i).getFirstChild() != null) {
                        if (nl.item(i).getFirstChild().getNodeValue().equals("true")) {
                            table.put("use", "required");
                        } else {
                            table.put("use", "optional");
                        }
                    } else {
                        table.put("use", "optional");
                    }
                }
            }
            ++i;
        }
        table.put("type", "xsd:string");
        return table;
    }
}

