/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model;

import com.tssap.util.xml.DOMAccess;
import com.tssap.util.xml.DOMParserI;
import com.tssap.util.xml.schema.model.util.PathManager;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UrlSchemaMapper {
    private static final String CONFIG_FILE_SCHEMA = "insight/xml/metaSchemas/NamespaceSchemaMap.xsd";
    private static final String CONFIG_FILE_NAME = "insight/xml/NamespaceSchemaMapperConfig.xml";
    private final String TAG_ENTRY = "entry";
    private final String TAG_FILENAME = "fileName";
    private final String TAG_NAMESPACE = "namespace";
    private final String TAG_JAR = "jar";
    private Hashtable urlSchemaMap = new Hashtable();

    public UrlSchemaMapper() {
        this.initialiseMapperFromConfigFile();
    }

    public String convertLocation(String location) {
        String pathToJar = PathManager.getAbsolutePluginPath();
        if (pathToJar != null && pathToJar.startsWith("file:/")) {
            pathToJar = pathToJar.substring("file:/".length());
        } else if (pathToJar != null && pathToJar.startsWith("file:")) {
            pathToJar = pathToJar.substring("file:".length());
        }
        if (location.startsWith("jar:file:///")) {
            String subLocation = location.substring(0, location.indexOf("!"));
            int indexOfLastSlashBeforeJarName = subLocation.lastIndexOf("/");
            location = "jar:file:///" + pathToJar + location.substring(indexOfLastSlashBeforeJarName + 1);
        }
        return location;
    }

    private void initialiseMapperFromConfigFile() {
        Document lDocument = UrlSchemaMapper.parseXmlFile(PathManager.getAbsolutePluginPath() + CONFIG_FILE_NAME);
        if (lDocument != null) {
            this.analyseConfigFile(lDocument.getDocumentElement());
        } else {
            System.out.println("UrlSchemaMapperConfig.xml not available! No Namespace/Schema mapping support for SchemaInsight.");
        }
    }

    private String getAbsoluteLocation(String fileAndJarName) {
        String jarName = null;
        String fileName = null;
        String location = null;
        StringTokenizer tz = new StringTokenizer(fileAndJarName, "**");
        if (tz.hasMoreElements()) {
            fileName = (String)tz.nextElement();
        }
        if (tz.hasMoreElements()) {
            jarName = (String)tz.nextElement();
        }
        if (fileName != null && jarName != null && !jarName.equals("null")) {
            String path = PathManager.getAbsolutePluginPath();
            if (path.startsWith("file:/")) {
                path = path.substring("file:/".length());
            } else if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            location = "jar:file:///" + path + jarName + "!" + "/" + fileName;
        } else if (fileName != null) {
            location = PathManager.getAbsolutePluginPath() + fileName;
        }
        return location;
    }

    private static Document parseXmlFile(String location) {
        Document lDocument = null;
        try {
            DOMParserI lParser = DOMAccess.getDOMParser();
            lDocument = lParser.parse(location, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return lDocument;
    }

    private void analyseConfigFile(Node rootNode) {
        NodeList children = rootNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1 && children.item(i).getNodeName().equals("entry")) {
                String url = null;
                String fileName = null;
                String jarName = null;
                NodeList childNodes = children.item(i).getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    if (childNodes.item(j).getNodeType() == 1) {
                        if (childNodes.item(j).getNodeName().equals("namespace")) {
                            url = childNodes.item(j).getFirstChild().getNodeValue();
                        } else if (childNodes.item(j).getNodeName().equals("fileName")) {
                            fileName = childNodes.item(j).getFirstChild().getNodeValue();
                        } else if (childNodes.item(j).getNodeName().equals("jar") && childNodes.item(j).getFirstChild() != null) {
                            jarName = childNodes.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    ++j;
                }
                if (url != null && fileName != null) {
                    this.urlSchemaMap.put(url, fileName + "**" + jarName);
                }
            }
            ++i;
        }
    }

    public boolean isUrlKnown(String url) {
        if (this.urlSchemaMap == null) {
            return false;
        }
        return this.urlSchemaMap.containsKey(url);
    }

    public String findSchemaLocationFromUrl(String url) {
        String fileAndJarName = (String)this.urlSchemaMap.get(url);
        if (fileAndJarName != null) {
            return this.getAbsoluteLocation(fileAndJarName);
        }
        return null;
    }
}

