/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model;

import com.tssap.util.insight.interfaces.DisplayableObjectI;
import com.tssap.util.insight.interfaces.SearchTargetI;
import com.tssap.util.insight.interfaces.VectorConverterI;
import com.tssap.util.xml.schema.model.elements.ResultTag;
import com.tssap.util.xml.schema.model.elements.ScannedElement;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlTarget;
import java.util.Arrays;
import java.util.Vector;

public class StringConverter
implements VectorConverterI {
    public static final int BRACKET_TYPE_NONE = 0;
    public static final int BRACKET_TYPE_SIMPLE = 1;
    public static final int BRACKET_TYPE_CLOSING = 2;

    public Vector convertElementListToDocuList(Vector scannedElements) {
        if (scannedElements == null || scannedElements.size() == 0) {
            return null;
        }
        Vector<String> resultVector = new Vector<String>();
        int i = 0;
        while (i < scannedElements.size()) {
            if (scannedElements.elementAt(i) instanceof ResultTag) {
                resultVector.add(((ResultTag)scannedElements.elementAt(i)).getDocu());
            }
            ++i;
        }
        return resultVector;
    }

    public Vector convertElementListToStringList(Vector scannedElements, SearchTargetI target) {
        if (scannedElements == null || scannedElements.size() == 0) {
            return null;
        }
        Vector elementNames = new Vector();
        String elementToAdd = null;
        String nodeType = ((XmlTarget)target).getTarget();
        int i = 0;
        while (i < scannedElements.size()) {
            if (scannedElements.elementAt(i) instanceof DisplayableObjectI) {
                elementNames.add(scannedElements.elementAt(i));
            } else {
                if (nodeType.equals("tag") || nodeType.equals("root")) {
                    ResultTag tag = (ResultTag)scannedElements.elementAt(i);
                    if (tag.getConversionType() == 1) {
                        String part1 = this.addTagBrace(tag.getQualifiedName(), 1, 1);
                        String part2 = this.addTagBrace(tag.getQualifiedName(), 2, 1);
                        elementToAdd = part1 + part2;
                    }
                    if (tag.getConversionType() == 2) {
                        elementToAdd = this.addTagBrace(tag.getQualifiedName(), 2, 1);
                    }
                    if (tag.getConversionType() == 0) {
                        elementToAdd = this.addTagBrace(tag.getQualifiedName(), 1, 1);
                    }
                    if (tag.getConversionType() == 3) {
                        elementToAdd = this.addTagBrace(tag.getQualifiedName(), 1, 2);
                    }
                } else {
                    Object element = scannedElements.elementAt(i);
                    elementToAdd = element instanceof ScannedElement ? ((ScannedElement)scannedElements.elementAt(i)).getQualifiedName() : (String)element;
                }
                boolean needsAdding = true;
                int j = 0;
                while (j < elementNames.size()) {
                    if (elementToAdd.equals(elementNames.elementAt(j).toString())) {
                        needsAdding = false;
                    }
                    ++j;
                }
                if (needsAdding) {
                    elementNames.add(elementToAdd);
                }
            }
            ++i;
        }
        if (elementNames.size() > 1) {
            this.sortStringList(elementNames);
        }
        return elementNames;
    }

    private String addTagBrace(String tagName, int leftBracketType, int rightBracketType) {
        if (tagName == null) {
            return "";
        }
        String lTag = tagName;
        lTag = StringConverter.deleteTagBrace(lTag);
        switch (leftBracketType) {
            case 1: {
                lTag = "<" + lTag;
                break;
            }
            case 2: {
                lTag = "</" + lTag;
                break;
            }
            case 0: {
                break;
            }
            default: {
                System.out.println("Unknown left bracket type!");
            }
        }
        switch (rightBracketType) {
            case 1: {
                lTag = lTag + ">";
                break;
            }
            case 2: {
                lTag = lTag + "/>";
                break;
            }
            case 0: {
                break;
            }
            default: {
                System.out.println("Unknown right bracket type!");
            }
        }
        return lTag;
    }

    private static String deleteTagBrace(String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return "";
        }
        String lTag = tagName;
        if (lTag.startsWith("</")) {
            lTag = lTag.substring(2);
        } else if (lTag.startsWith("<")) {
            lTag = lTag.substring(1);
        }
        if (lTag.endsWith("/>")) {
            lTag = lTag.substring(0, lTag.length() - 2);
        } else if (lTag.endsWith(">")) {
            lTag = lTag.substring(0, lTag.length() - 1);
        }
        return lTag;
    }

    public void sortStringList(Vector stringList) {
        if (stringList.size() <= 0) {
            return;
        }
        Vector<String> pureStrings = new Vector<String>();
        Vector noneStrings = new Vector();
        int i = 0;
        while (i < stringList.size()) {
            if (!(stringList.elementAt(i) instanceof String)) {
                pureStrings.add(stringList.elementAt(i).toString());
                noneStrings.add(stringList.elementAt(i));
            } else {
                pureStrings.add((String)stringList.elementAt(i));
            }
            ++i;
        }
        Object[] lStrings = new String[]{};
        lStrings = pureStrings.toArray(lStrings);
        stringList.clear();
        Arrays.sort(lStrings);
        int i2 = 0;
        while (i2 < lStrings.length) {
            stringList.add(lStrings[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < noneStrings.size()) {
            Object o = noneStrings.elementAt(i3);
            int j = 0;
            while (j < stringList.size()) {
                if (stringList.elementAt(j) instanceof String && ((String)stringList.elementAt(j)).equals(o.toString())) {
                    stringList.setElementAt(o, j);
                    break;
                }
                ++j;
            }
            ++i3;
        }
    }
}

