/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model;

import com.tssap.util.xml.schema.model.GlobalSchemaModel;
import com.tssap.util.xml.schema.model.InfoTableKey;
import com.tssap.util.xml.schema.model.NewModelEvent;
import com.tssap.util.xml.schema.model.NewModelListener;
import com.tssap.util.xml.schema.model.SchemaAttributeTable;
import com.tssap.util.xml.schema.model.SchemaConstantsI;
import com.tssap.util.xml.schema.model.SchemaInfoTable;
import com.tssap.util.xml.schema.model.SchemaReference;
import com.tssap.util.xml.schema.model.appinfo.AppInfoData;
import com.tssap.util.xml.schema.model.elements.ScannedType;
import com.tssap.util.xml.schema.model.finiteAutomata.AbstractMachine;
import com.tssap.util.xml.schema.model.finiteAutomata.AllFA;
import com.tssap.util.xml.schema.model.finiteAutomata.ChoiceFA;
import com.tssap.util.xml.schema.model.finiteAutomata.DerivedTypeFA;
import com.tssap.util.xml.schema.model.finiteAutomata.ElementFA;
import com.tssap.util.xml.schema.model.finiteAutomata.PlainFA;
import com.tssap.util.xml.schema.model.finiteAutomata.SequenceFA;
import com.tssap.util.xml.schema.model.finiteAutomata.SubstitutionChoiceFA;
import com.tssap.util.xml.schema.model.nodes.AttributeGroupNode;
import com.tssap.util.xml.schema.model.nodes.AttributeNode;
import com.tssap.util.xml.schema.model.nodes.AttributeNodeWrapper;
import com.tssap.util.xml.schema.model.nodes.AutomatonNode;
import com.tssap.util.xml.schema.model.nodes.ComplexTypeNode;
import com.tssap.util.xml.schema.model.nodes.NodeLocationData;
import com.tssap.util.xml.schema.model.nodes.NodeWithAttributes;
import com.tssap.util.xml.schema.model.nodes.TagNode;
import com.tssap.util.xml.schema.model.util.Helper;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaModel {
    private SchemaAttributeTable allAttributeNames = new SchemaAttributeTable("attribute");
    private SchemaAttributeTable allAttributeGroups = new SchemaAttributeTable("attributeGroup");
    private SchemaInfoTable allTypeNames = new SchemaInfoTable("complexType");
    private SchemaInfoTable allTagNames = new SchemaInfoTable("element");
    private SchemaInfoTable allGroupNames = new SchemaInfoTable("group");
    private Vector importedSchemaReferences = new Vector();
    private GlobalSchemaModel globalManager = null;
    private String targetNamespace = "";
    private TagNode TagNodeSchema = null;
    private String baseType;
    private String derivingType;
    private NewModelAnnouncer newModelAnnounce = new NewModelAnnouncer();

    public SchemaModel(GlobalSchemaModel globalModel, Node rootNode) {
        this.globalManager = globalModel;
        if (rootNode == null) {
            return;
        }
        if (rootNode.getNodeName() != null && rootNode.getNodeName().endsWith("schema")) {
            this.targetNamespace = SchemaModel.getDOMAttributeValue(rootNode, "targetNamespace");
            if (this.targetNamespace == null) {
                this.targetNamespace = "";
            }
        } else {
            System.out.println("wrong root name: " + rootNode.getNodeName());
        }
    }

    public Vector getImportedSchemaReferences() {
        return this.importedSchemaReferences;
    }

    public NodeWithAttributes locateReferencedTagNode(String nodeType, String nodeName) {
        return (NodeWithAttributes)this.getSchemaInfoTableByNodeType(nodeType).declareReferentialUse(nodeName);
    }

    private NodeWithAttributes locateReferencedTagNode(NodeWithAttributes node) {
        node.setUsage("reference");
        return node.locateReferencedTagNode(this.globalManager, 0, false);
    }

    public NodeWithAttributes locateTagNode(String nodeType, String nodeName) {
        if (nodeName == null || nodeName.length() == 0) {
            return this.TagNodeSchema;
        }
        InfoTableKey localKey = new InfoTableKey(nodeName, false);
        InfoTableKey globalKey = new InfoTableKey(nodeName, true);
        SchemaInfoTable table = this.getSchemaInfoTableByNodeType(nodeType);
        if (table.isKeyExisting(localKey) && table.isKeyExisting(globalKey)) {
            AutomatonNode nwa = table.getTagNodeByKey(localKey);
            nwa.setAmbiguous();
            return nwa;
        }
        if (table.isKeyExisting(localKey)) {
            return table.getTagNodeByKey(localKey);
        }
        if (table.isKeyExisting(globalKey)) {
            return table.getTagNodeByKey(globalKey);
        }
        return null;
    }

    public TagNode getRootNode() {
        return this.TagNodeSchema;
    }

    private SchemaInfoTable getSchemaInfoTableByNodeType(String nodeType) {
        if (nodeType.endsWith("element")) {
            return this.allTagNames;
        }
        if (nodeType.endsWith("attribute")) {
            return this.allAttributeNames;
        }
        if (nodeType.endsWith("attributeGroup")) {
            return this.allAttributeGroups;
        }
        if (nodeType.endsWith("complexType")) {
            return this.allTypeNames;
        }
        if (nodeType.endsWith("group")) {
            return this.allGroupNames;
        }
        return null;
    }

    public void analyseRootNode(Node rootNode, boolean includeCall, String filePath) throws Throwable {
        if (includeCall && !this.targetNamespace.equals(SchemaModel.getDOMAttributeValue(rootNode, "targetNamespace"))) {
            System.out.println("TargetNamespace of included schema is incorrect - Aborting Include");
            return;
        }
        NodeLocationData locationData = SchemaModel.createLocationData(rootNode);
        this.dfsForTags(rootNode, rootNode, locationData, filePath);
        this.dfsForAttributes(rootNode, rootNode, locationData);
        this.dfsForValues(rootNode, rootNode, locationData);
        this.dfsForDocumentation(rootNode, rootNode, locationData);
    }

    public static NodeLocationData createLocationData(Node rootNode) {
        if (rootNode == null) {
            return null;
        }
        String defaultNamespace = null;
        String form = null;
        defaultNamespace = SchemaModel.getDOMAttributeValue(rootNode, "xmlns");
        form = SchemaModel.getDOMAttributeValue(rootNode, "elementFormDefault");
        boolean elementFormDefault = form != null && form.equals("qualified");
        form = SchemaModel.getDOMAttributeValue(rootNode, "attributeFormDefault");
        boolean attributeFormDefault = form != null && form.equals("qualified");
        return new NodeLocationData(defaultNamespace, elementFormDefault, attributeFormDefault, Helper.getSchemaReferencesFromNode(rootNode));
    }

    private boolean isTagToIgnore(Node node, String filePath) throws Throwable {
        String name = node.getNodeName();
        if (name.endsWith("import") || name.endsWith("include") || name.endsWith("redefine")) {
            if (filePath != null) {
                this.newModelAnnounce.notifyNewModel(this, filePath, name, node);
            }
            return true;
        }
        return false;
    }

    private boolean isAnnotationNode(Node node) {
        String name = node.getNodeName();
        return name.endsWith("annotation");
    }

    private String removeSchemaPrefixFromNodeName(String nodeName) {
        if (nodeName.indexOf(58) > 0) {
            return nodeName.substring(nodeName.indexOf(58) + 1);
        }
        return nodeName;
    }

    private AppInfoData searchAppInfoNodeAndCreateAppInfoObject(Node n) {
        if (n.getNodeType() != 1) {
            return null;
        }
        AppInfoData data = null;
        if (n.getNodeName().endsWith("appinfo")) {
            if (n.getChildNodes().item(1) != null) {
                return this.dfsForAppInfo(n.getChildNodes().item(1));
            }
            return null;
        }
        NodeList childNodes = n.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            AppInfoData temp = this.searchAppInfoNodeAndCreateAppInfoObject(childNodes.item(i));
            if (temp != null) {
                data = temp;
                break;
            }
            ++i;
        }
        return data;
    }

    private AppInfoData dfsForAppInfo(Node n) {
        AppInfoData appInfoData = new AppInfoData();
        NodeList childNodes = n.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            AppInfoData temp;
            if (childNodes.item(i).getNodeType() == 1 && (temp = this.dfsForAppInfo(childNodes.item(i))) != null) {
                appInfoData.addChild(temp);
            }
            ++i;
        }
        if (n.getNodeType() == 1) {
            if (n.getChildNodes().getLength() == 1) {
                appInfoData.setAppInfoElementContent(n.getFirstChild().getNodeValue().trim());
            }
            appInfoData.setAppInfoElementName(n.getNodeName());
            NamedNodeMap attributes = n.getAttributes();
            int j = 0;
            while (j < attributes.getLength()) {
                appInfoData.addAttributeValuePair(attributes.item(j).getNodeName(), attributes.item(j).getNodeValue());
                ++j;
            }
            return appInfoData;
        }
        return appInfoData;
    }

    private Object dfsForTags(Node node, Node rootNode, NodeLocationData locationData, String filePath) throws Throwable {
        boolean global = node.getParentNode() == rootNode;
        String nodeName = node.getNodeName();
        nodeName = this.removeSchemaPrefixFromNodeName(nodeName);
        Vector<Object> childMachines = new Vector<Object>();
        AutomatonNode elementNode = null;
        AutomatonNode typeNode = null;
        if (this.isTagToIgnore(node, filePath)) {
            return null;
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Object childMachine;
            if (childNodes.item(i).getNodeType() == 1 && (childMachine = this.dfsForTags(childNodes.item(i), rootNode, locationData, filePath)) != null) {
                childMachines.add(childMachine);
            }
            ++i;
        }
        if (nodeName != null) {
            boolean abs;
            boolean bl = abs = SchemaModel.getDOMAttributeValue(node, "abstract") != null && SchemaModel.getDOMAttributeValue(node, "abstract").equals("true");
            if (nodeName.endsWith("schema")) {
                this.TagNodeSchema = new TagNode("schema", node, "definition", false, locationData);
                this.TagNodeSchema.setAutomaton(new ChoiceFA(childMachines));
                return null;
            }
            if (nodeName.endsWith("element") || nodeName.endsWith("group")) {
                elementNode = (AutomatonNode)this.getSchemaInfoTableByNodeType(nodeName).createLocalTagNode(node, global, locationData);
                if (elementNode.getRef() != null) {
                    if (this.getNumberAttribute(node, "minOccurs") == 1 && this.getNumberAttribute(node, "maxOccurs") == 1) {
                        return ((AutomatonNode)this.locateReferencedTagNode(elementNode)).getAutomaton();
                    }
                    childMachines.clear();
                    childMachines.add(((AutomatonNode)this.locateReferencedTagNode(elementNode)).getAutomaton());
                    return new SequenceFA(childMachines, this.getNumberAttribute(node, "minOccurs"), this.getNumberAttribute(node, "maxOccurs"));
                }
                elementNode.setUsage("definition");
                typeNode = (ComplexTypeNode)this.allTypeNames.createLocalTagNode(node, global, locationData);
                if (elementNode.getType() != null) {
                    childMachines.clear();
                    AutomatonNode tagTypeNode = (AutomatonNode)this.locateReferencedTagNode(typeNode);
                    childMachines.add(tagTypeNode.getAutomaton());
                }
                if (childMachines.isEmpty()) {
                    childMachines = null;
                }
                boolean typeIsNotPrimitiveOrEmpty = elementNode.getType() == null || elementNode.getType().equals("") || !SchemaModel.isPrimitiveType(elementNode.getType());
                AbstractMachine machine = nodeName.endsWith("element") ? new ElementFA(elementNode.getUnqualifiedPartName(), childMachines, this.getNumberAttribute(node, "minOccurs"), this.getNumberAttribute(node, "maxOccurs"), this.targetNamespace, typeIsNotPrimitiveOrEmpty) : new SequenceFA(childMachines);
                this.getSchemaInfoTableByNodeType(nodeName).declareDefiningUse(elementNode, machine, abs);
                if (nodeName.endsWith("element")) {
                    ((TagNode)elementNode).setAppInfo(this.searchAppInfoNodeAndCreateAppInfoObject(node));
                    if (((TagNode)elementNode).getSubstitutionGroup() != null) {
                        AutomatonNode baseNode = this.locateBaseTypeNode("element", ((TagNode)elementNode).getSubstitutionGroup(), node, global, locationData);
                        ((SubstitutionChoiceFA)baseNode.getAutomaton()).addChild((AbstractMachine)elementNode.getAutomaton());
                    }
                }
                return elementNode.getAutomaton();
            }
            if (nodeName.endsWith("extension") || nodeName.endsWith("restriction")) {
                this.baseType = SchemaModel.getDOMAttributeValue(node, "base");
                if (this.baseType != null && !SchemaModel.isPrimitiveType(this.baseType)) {
                    typeNode = this.locateBaseTypeNode("complexType", this.baseType, node, global, locationData);
                    if (nodeName.endsWith("extension")) {
                        this.derivingType = "extension";
                        Vector<AbstractMachine> childTags = new Vector<AbstractMachine>();
                        if (((DerivedTypeFA)typeNode.getAutomaton()).getStandardChild() != null) {
                            childTags.add(((DerivedTypeFA)typeNode.getAutomaton()).getStandardChild());
                        }
                        if (!childMachines.isEmpty()) {
                            childTags.add((AbstractMachine)childMachines.get(0));
                        }
                        if (!childTags.isEmpty()) {
                            return new SequenceFA(childTags);
                        }
                    } else {
                        this.derivingType = "restriction";
                        if (!childMachines.isEmpty()) {
                            return childMachines.get(0);
                        }
                    }
                }
                return null;
            }
            if (nodeName.endsWith("complexContent") || nodeName.endsWith("simpleContent") || nodeName.endsWith("complexType") || nodeName.endsWith("simpleType")) {
                typeNode = (ComplexTypeNode)this.allTypeNames.createLocalTagNode(node, "definition", global, locationData);
                if (typeNode.getUnqualifiedPartName() != null) {
                    AbstractMachine machine = null;
                    if (!childMachines.isEmpty() && nodeName.endsWith("complexType")) {
                        machine = ((PlainFA)childMachines.get(0)).getYourself();
                    }
                    this.allTypeNames.declareDefiningUse(typeNode, machine, abs);
                    if (this.baseType != null) {
                        ((ComplexTypeNode)typeNode).setBaseType(this.baseType);
                        ((ComplexTypeNode)typeNode).setDerivingType(this.derivingType);
                        this.baseType = null;
                        this.derivingType = null;
                    }
                    return null;
                }
                if (!childMachines.isEmpty()) {
                    return childMachines.get(0);
                }
            }
            if (nodeName.endsWith("all")) {
                return new AllFA(childMachines, this.getNumberAttribute(node, "minOccurs"), this.getNumberAttribute(node, "maxOccurs"));
            }
            if (nodeName.endsWith("sequence")) {
                return new SequenceFA(childMachines, this.getNumberAttribute(node, "minOccurs"), this.getNumberAttribute(node, "maxOccurs"));
            }
            if (nodeName.endsWith("choice")) {
                return new ChoiceFA(childMachines, this.getNumberAttribute(node, "minOccurs"), this.getNumberAttribute(node, "maxOccurs"));
            }
        }
        return null;
    }

    private Vector dfsForAttributes(Node node, Node rootNode, NodeLocationData locationData) throws Throwable {
        boolean global = node.getParentNode() == rootNode;
        String nodeName = node.getNodeName();
        nodeName = this.removeSchemaPrefixFromNodeName(nodeName);
        AutomatonNode elementNode = null;
        AutomatonNode typeNode = null;
        if (this.isTagToIgnore(node, null)) {
            return null;
        }
        TagNode childNode = new TagNode();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Vector currentChildNode;
            if (childNodes.item(i).getNodeType() == 1 && (currentChildNode = this.dfsForAttributes(childNodes.item(i), rootNode, locationData)) != null && !nodeName.endsWith("schema")) {
                childNode.addAttribute(currentChildNode);
            }
            ++i;
        }
        if (nodeName != null) {
            if (nodeName.startsWith("attribute")) {
                NodeWithAttributes attributeNode = this.getSchemaInfoTableByNodeType(nodeName).createLocalTagNode(node, global, locationData);
                if (attributeNode.getRef() != null) {
                    childNode.getAttributeVector().clear();
                    childNode.getAttributeVector().add(this.locateReferencedTagNode(attributeNode));
                } else if (attributeNode.getUnqualifiedPartName() != null) {
                    this.getSchemaInfoTableByNodeType(nodeName).declareDefiningUse(attributeNode, childNode, false);
                    if (attributeNode instanceof AttributeGroupNode) {
                        attributeNode.addAttribute(childNode.getAttributeVector());
                    } else if (attributeNode instanceof AttributeNode) {
                        ((AttributeNode)attributeNode).setNameSpaceName(this.targetNamespace);
                    }
                    childNode.getAttributeVector().clear();
                    childNode.getAttributeVector().add(attributeNode);
                }
                return childNode.getAttributeVector();
            }
            if (nodeName.endsWith("element")) {
                elementNode = (AutomatonNode)this.allTagNames.createLocalTagNode(node, global, locationData);
                if (elementNode.getRef() == null && elementNode.getType() == null && elementNode.getUnqualifiedPartName() != null) {
                    elementNode = (AutomatonNode)this.locateTagNode("element", elementNode.getUnqualifiedPartName());
                    ((SubstitutionChoiceFA)elementNode.getAutomaton()).addAttribute(childNode.getAttributeVector());
                }
                return null;
            }
            if (nodeName.endsWith("complexType")) {
                typeNode = (AutomatonNode)this.allTypeNames.createLocalTagNode(node, global, locationData);
                if (typeNode.getUnqualifiedPartName() != null) {
                    typeNode = (AutomatonNode)this.locateTagNode("complexType", typeNode.getUnqualifiedPartName());
                    ((DerivedTypeFA)typeNode.getAutomaton()).addAttribute(childNode.getAttributeVector());
                    return null;
                }
                return childNode.getAttributeVector();
            }
            if (nodeName.endsWith("complexContent") || nodeName.endsWith("simpleContent") || nodeName.endsWith("extension") || nodeName.endsWith("restriction")) {
                return childNode.getAttributeVector();
            }
        }
        return null;
    }

    private String dfsForDocumentation(Node node, Node rootNode, NodeLocationData locationData) throws Throwable {
        boolean global = node.getParentNode() == rootNode;
        String nodeName = node.getNodeName();
        nodeName = this.removeSchemaPrefixFromNodeName(nodeName);
        AutomatonNode elementNode = null;
        NodeWithAttributes attributeNode = null;
        if (this.isTagToIgnore(node, null)) {
            return null;
        }
        if (nodeName.startsWith("documentation")) {
            if (node.getFirstChild() == null) {
                return null;
            }
            return node.getFirstChild().getNodeValue();
        }
        NodeList childNodes = node.getChildNodes();
        String currentDocumentation = null;
        int i = 0;
        while (i < childNodes.getLength() && currentDocumentation == null) {
            if (childNodes.item(i).getNodeType() == 1) {
                currentDocumentation = this.dfsForDocumentation(childNodes.item(i), rootNode, locationData);
            }
            ++i;
        }
        if (nodeName == null || currentDocumentation == null) {
            return null;
        }
        if (nodeName.endsWith("annotation")) {
            return currentDocumentation;
        }
        if (nodeName.endsWith("element")) {
            elementNode = (AutomatonNode)this.allTagNames.createLocalTagNode(node, global, locationData);
            if (elementNode.getRef() == null && elementNode.getUnqualifiedPartName() != null) {
                elementNode = (AutomatonNode)this.locateTagNode("element", elementNode.getUnqualifiedPartName());
                ((SubstitutionChoiceFA)elementNode.getAutomaton()).addDocu(currentDocumentation);
            }
            return null;
        }
        if (nodeName.equals("attribute")) {
            attributeNode = this.allAttributeNames.createLocalTagNode(node, global, locationData);
            if (attributeNode.getRef() == null && attributeNode.getUnqualifiedPartName() != null) {
                attributeNode = (AttributeNode)this.locateTagNode("attribute", attributeNode.getUnqualifiedPartName());
                attributeNode.addDocu(currentDocumentation);
            }
            return null;
        }
        return null;
    }

    private Vector dfsForValues(Node node, Node rootNode, NodeLocationData locationData) {
        String value;
        boolean global = node.getParentNode() == rootNode;
        String nodeName = node.getNodeName();
        ComplexTypeNode typeNode = null;
        TagNode elementNode = null;
        nodeName = this.removeSchemaPrefixFromNodeName(nodeName);
        Vector allValues = new Vector();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Vector currentChildValues;
            if (childNodes.item(i).getNodeType() == 1 && (currentChildValues = this.dfsForValues(childNodes.item(i), rootNode, locationData)) != null) {
                allValues.addAll(currentChildValues);
            }
            ++i;
        }
        if (nodeName.endsWith("element")) {
            if (allValues.size() == 0) {
                return null;
            }
            elementNode = (TagNode)this.allTagNames.createLocalTagNode(node, global, locationData);
            if (elementNode.getRef() == null && elementNode.getType() == null && elementNode.getUnqualifiedPartName() != null) {
                elementNode = (TagNode)this.locateTagNode("element", elementNode.getUnqualifiedPartName());
                elementNode.setPossibleValues(allValues);
            }
            return null;
        }
        if (nodeName.endsWith("complexType") || nodeName.endsWith("simpleType")) {
            if (allValues.size() == 0) {
                return null;
            }
            typeNode = (ComplexTypeNode)this.allTypeNames.createLocalTagNode(node, global, locationData);
            if (typeNode.getUnqualifiedPartName() != null) {
                typeNode = (ComplexTypeNode)this.locateTagNode("complexType", typeNode.getUnqualifiedPartName());
                typeNode.setPossibleValues(allValues);
                return null;
            }
            return allValues;
        }
        if (nodeName.endsWith("restriction") || nodeName.endsWith("simpleContent")) {
            return allValues;
        }
        if (nodeName.endsWith("enumeration") && (value = SchemaModel.getDOMAttributeValue(node, "value")) != null) {
            Vector<String> v = new Vector<String>();
            v.add(value);
            return v;
        }
        return null;
    }

    private int getNumberAttribute(Node node, String attrName) {
        int number = 0;
        String numberString = SchemaModel.getDOMAttributeValue(node, attrName);
        if (numberString == null) {
            number = 1;
        } else if (numberString.equals("unbounded")) {
            number = 10000;
        } else {
            char[] chars = numberString.toCharArray();
            int i = 0;
            while (i < chars.length) {
                number = number * 10 + chars[i] - 48;
                ++i;
            }
        }
        return number;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public static String getDOMAttributeValue(Node node, String attributeName) {
        Node temp = node.getAttributes().getNamedItem(attributeName);
        if (temp == null) {
            return null;
        }
        return temp.getNodeValue();
    }

    private AutomatonNode locateBaseTypeNode(String nodeType, String baseType, Node node, boolean global, NodeLocationData locationData) {
        AutomatonNode baseNode = null;
        if (baseType != null && !SchemaModel.isPrimitiveType(baseType)) {
            baseNode = (ComplexTypeNode)this.getSchemaInfoTableByNodeType(nodeType).createLocalTagNode(node, global, locationData);
            baseNode.setName(baseType);
            baseNode = (AutomatonNode)this.locateReferencedTagNode(baseNode);
        }
        return baseNode;
    }

    private AutomatonNode locateBaseTypeNode(String nodeType, String baseType, NodeLocationData locationData) {
        AutomatonNode baseNode = null;
        if (baseType != null && !SchemaModel.isPrimitiveType(baseType)) {
            baseNode = new ComplexTypeNode(nodeType, baseType);
            baseNode.setLocationData(locationData);
            baseNode = (AutomatonNode)this.locateReferencedTagNode(baseNode);
        }
        return baseNode;
    }

    private Vector resolveAllAttributeGroupNodes(AttributeGroupNode attNode) {
        Vector<NodeWithAttributes> tempVector = new Vector<NodeWithAttributes>();
        Vector groupAtts = attNode.getAttributeVector();
        int j = 0;
        while (j < groupAtts.size()) {
            NodeWithAttributes childNode = (NodeWithAttributes)groupAtts.elementAt(j);
            if (childNode instanceof AttributeNodeWrapper) {
                childNode = ((AttributeNodeWrapper)childNode).getYourselfAsAttributeNode();
            }
            if (childNode instanceof AttributeGroupNode) {
                tempVector.addAll(this.resolveAllAttributeGroupNodes((AttributeGroupNode)childNode));
            } else {
                tempVector.add(childNode);
            }
            ++j;
        }
        return tempVector;
    }

    private void convertAttributeGroupNodes(Vector baseAtts) {
        Vector<NodeWithAttributes> tempVector = new Vector<NodeWithAttributes>();
        int i = 0;
        while (i < baseAtts.size()) {
            NodeWithAttributes tempNode = baseAtts.elementAt(i) instanceof AttributeNodeWrapper ? ((AttributeNodeWrapper)baseAtts.elementAt(i)).getYourselfAsAttributeNode() : (NodeWithAttributes)baseAtts.elementAt(i);
            if (tempNode instanceof AttributeGroupNode) {
                tempVector.addAll(this.resolveAllAttributeGroupNodes((AttributeGroupNode)tempNode));
            } else {
                tempVector.add(tempNode);
            }
            ++i;
        }
        baseAtts.clear();
        baseAtts.addAll(tempVector);
    }

    public void resolveAttributeGroups() {
        Enumeration enumeration = this.allTypeNames.getAllData();
        while (enumeration.hasMoreElements()) {
            ComplexTypeNode node = (ComplexTypeNode)((AutomatonNode)enumeration.nextElement()).getYourself();
            if (node == null) continue;
            DerivedTypeFA am = (DerivedTypeFA)node.getAutomaton();
            this.convertAttributeGroupNodes(am.getAttributes());
        }
        enumeration = this.allTagNames.getAllData();
        while (enumeration.hasMoreElements()) {
            ElementFA am = null;
            TagNode node = (TagNode)((AutomatonNode)enumeration.nextElement()).getYourself();
            if (node != null) {
                am = ((SubstitutionChoiceFA)node.getAutomaton()).getStandardChild();
            }
            if (am == null) continue;
            this.convertAttributeGroupNodes(am.getAttributes());
        }
    }

    public void buildTypeHierarchy(Node rootNode) {
        NodeLocationData locationData = SchemaModel.createLocationData(rootNode);
        Vector elementsConsideredSoFarForHierarchy = new Vector();
        Vector elementsConsideredSoFarForAttributes = new Vector();
        Enumeration enumeration = this.allTypeNames.getAllData();
        while (enumeration.hasMoreElements()) {
            ComplexTypeNode node = (ComplexTypeNode)((AutomatonNode)enumeration.nextElement()).getYourself();
            if (node == null) continue;
            this.buildHierarchyForSingleNode(locationData, node, elementsConsideredSoFarForHierarchy, elementsConsideredSoFarForAttributes);
        }
    }

    private void buildHierarchyForSingleNode(NodeLocationData locationData, ComplexTypeNode node, Vector ecsfForHierarchy, Vector ecsfForAttributes) {
        AutomatonNode tempNode;
        if (ecsfForHierarchy.contains(node)) {
            return;
        }
        ComplexTypeNode baseNode = null;
        ecsfForHierarchy.add(node);
        if (node.getBaseType() != null && (tempNode = this.locateBaseTypeNode("complexType", node.getBaseType(), locationData)) != null && (baseNode = (ComplexTypeNode)tempNode.getYourself()) != null) {
            this.buildHierarchyForSingleNode(locationData, baseNode, ecsfForHierarchy, ecsfForAttributes);
            this.buildHierarchyForAutomata(baseNode, node, locationData);
        }
        if (node.getDerivingType() != null && baseNode != null && !ecsfForAttributes.contains(node)) {
            if (node.getDerivingType().equals("extension")) {
                ((DerivedTypeFA)node.getAutomaton()).addAttribute(((DerivedTypeFA)baseNode.getAutomaton()).getAttributes());
            }
            if (node.getDerivingType().equals("restriction")) {
                Vector restAtts = ((DerivedTypeFA)node.getAutomaton()).getAttributes();
                Vector baseAtts = ((DerivedTypeFA)baseNode.getAutomaton()).getAttributes();
                Vector<NodeWithAttributes> resultAtts = new Vector<NodeWithAttributes>();
                if (restAtts == null || restAtts.size() < 1) {
                    ((DerivedTypeFA)node.getAutomaton()).addAttribute(baseAtts);
                    return;
                }
                int i = 0;
                while (i < restAtts.size()) {
                    NodeWithAttributes restNode = (NodeWithAttributes)restAtts.elementAt(i);
                    if (restNode instanceof AttributeNode) {
                        if (!"prohibited".equals(((AttributeNode)restNode).getUse())) {
                            resultAtts.add(restNode);
                        }
                    } else {
                        resultAtts.add(restNode);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < baseAtts.size()) {
                    boolean allreadyConsidered = false;
                    NodeWithAttributes temp = (NodeWithAttributes)baseAtts.elementAt(i2);
                    int j = 0;
                    while (j < restAtts.size()) {
                        if (((NodeWithAttributes)restAtts.elementAt(j)).getNameAsItIs().equals(temp.getNameAsItIs())) {
                            allreadyConsidered = true;
                        }
                        ++j;
                    }
                    if (!allreadyConsidered) {
                        resultAtts.add(temp);
                    }
                    ++i2;
                }
                ((DerivedTypeFA)node.getAutomaton()).getAttributes().clear();
                ((DerivedTypeFA)node.getAutomaton()).addAttribute(resultAtts);
            }
            ecsfForAttributes.add(node);
        }
    }

    private void buildHierarchyForAutomata(ComplexTypeNode baseNode, ComplexTypeNode derivedNode, NodeLocationData locationData) {
        ScannedType type = new ScannedType(derivedNode.getUnqualifiedPartName());
        type.setNameSpaceName(this.targetNamespace);
        if (baseNode != null && !((DerivedTypeFA)baseNode.getAutomaton()).getDerivedNames(false).contains(type)) {
            ComplexTypeNode baseNode2;
            AutomatonNode temp2;
            ((DerivedTypeFA)baseNode.getAutomaton()).addChild((DerivedTypeFA)derivedNode.getAutomaton(), type);
            if (baseNode.getBaseType() != null && (temp2 = this.locateBaseTypeNode("complexType", baseNode.getBaseType(), locationData)) != null && (baseNode2 = (ComplexTypeNode)temp2.getYourself()) != null) {
                this.buildHierarchyForAutomata(baseNode2, derivedNode, locationData);
            }
        }
    }

    public void addNewModelListener(NewModelListener cL) {
        this.newModelAnnounce.addNewModelListener(cL);
    }

    public void removeNewModelListener(NewModelListener cL) {
        this.newModelAnnounce.removeNewModelListener(cL);
    }

    public static boolean isPrimitiveType(String type) {
        int i = 0;
        while (i < SchemaConstantsI.ARRAY_PRIMITIVE_TYPES.length) {
            if (type.endsWith(SchemaConstantsI.ARRAY_PRIMITIVE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class NewModelAnnouncer {
        private Vector listeners = new Vector();

        public synchronized void addNewModelListener(NewModelListener cL) {
            this.listeners.addElement(cL);
        }

        public synchronized void removeNewModelListener(NewModelListener cL) {
            this.listeners.removeElement(cL);
        }

        protected void notifyNewModel(Object source, String filePath, String foundTag, Node node) throws Throwable {
            Vector l;
            NewModelEvent e = new NewModelEvent(source, SchemaModel.getDOMAttributeValue(node, "namespace"), SchemaModel.getDOMAttributeValue(node, "schemaLocation"), filePath);
            NewModelAnnouncer newModelAnnouncer = this;
            synchronized (newModelAnnouncer) {
                l = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < l.size()) {
                try {
                    if (foundTag.endsWith("include")) {
                        ((NewModelListener)l.elementAt(i)).includeTagOccured(e);
                    }
                    if (foundTag.endsWith("import")) {
                        ((NewModelListener)l.elementAt(i)).importTagOccured(e);
                        SchemaModel.this.importedSchemaReferences.add(new SchemaReference(e.getNamespace(), "", e.getSchemaLocation()));
                    }
                    if (foundTag.endsWith("redefine")) {
                        ((NewModelListener)l.elementAt(i)).redefineTagOccured(e);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
        }
    }
}

