/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model;

import com.tssap.util.xml.schema.model.AutomataInfoTable;
import com.tssap.util.xml.schema.model.InfoTable;
import com.tssap.util.xml.schema.model.InfoTableKey;
import com.tssap.util.xml.schema.model.finiteAutomata.AbstractMachine;
import com.tssap.util.xml.schema.model.nodes.AttributeGroupNode;
import com.tssap.util.xml.schema.model.nodes.AttributeNode;
import com.tssap.util.xml.schema.model.nodes.AutomatonNode;
import com.tssap.util.xml.schema.model.nodes.ComplexTypeNode;
import com.tssap.util.xml.schema.model.nodes.GroupNode;
import com.tssap.util.xml.schema.model.nodes.NodeLocationData;
import com.tssap.util.xml.schema.model.nodes.NodeWithAttributes;
import com.tssap.util.xml.schema.model.nodes.NodeWrapper;
import com.tssap.util.xml.schema.model.nodes.TagNode;
import java.util.Enumeration;
import org.w3c.dom.Node;

public class SchemaInfoTable
extends InfoTable {
    private AutomataInfoTable automata = null;

    public SchemaInfoTable(String type) {
        super(type);
        this.automata = new AutomataInfoTable(type);
    }

    public NodeWithAttributes createLocalTagNode(Node node, String usage, boolean global, NodeLocationData locationData) {
        NodeWithAttributes sn = this.createLocalTagNode(node, global, locationData);
        sn.setUsage(usage);
        return sn;
    }

    public NodeWithAttributes createLocalTagNode(Node node, boolean global, NodeLocationData locationData) {
        NodeWithAttributes nwa = null;
        if (this.nodeType.equals("attribute")) {
            nwa = new AttributeNode(this.nodeType, node, global, locationData);
        } else if (this.nodeType.equals("attributeGroup")) {
            nwa = new AttributeGroupNode(this.nodeType, node, global, locationData);
        } else if (this.nodeType.equals("complexType")) {
            nwa = new ComplexTypeNode(this.nodeType, node, global, locationData);
        } else if (this.nodeType.equals("group")) {
            nwa = new GroupNode(this.nodeType, node, global, locationData);
        } else if (this.nodeType.equals("element")) {
            nwa = new TagNode(this.nodeType, node, global, locationData);
        }
        return nwa;
    }

    public Object declareReferentialUse(String name) {
        InfoTableKey key = new InfoTableKey(name, true);
        AutomatonNode node = (AutomatonNode)this.getAccess(key);
        node.setUsage("reference");
        if (node.getAutomaton() == null) {
            Object machine = this.automata.getAccess(key);
            node.setAutomaton(machine);
        }
        return node;
    }

    public void declareDefiningUse(NodeWithAttributes node, Object machine, boolean pAbstract) {
        super.declareDefiningUse(node, machine);
        InfoTableKey key = new InfoTableKey(node.getUnqualifiedPartName(), node.isGlobal());
        this.putAccess(key, node);
        if (!node.getNodeType().startsWith("attribute")) {
            ((AutomatonNode)node).setAutomaton(this.automata.putAccess(key, (AbstractMachine)machine, node.isAmbiguous()));
            if (machine != null && pAbstract) {
                ((AbstractMachine)machine).setAbstract(pAbstract);
            }
        }
    }

    protected void putAccess(InfoTableKey key, Object node) {
        AutomatonNode nodeToInsert = (AutomatonNode)node;
        AutomatonNode result = (AutomatonNode)this.data.get(key);
        if (result == null) {
            this.data.put(key, nodeToInsert);
        } else if (result instanceof NodeWrapper) {
            ((NodeWrapper)result).node = nodeToInsert;
        } else {
            result.setAmbiguous();
            nodeToInsert.setAmbiguous();
        }
    }

    protected Object getAccess(InfoTableKey key) {
        Object result = this.data.get(key);
        if (result == null) {
            result = new NodeWrapper(this.nodeType, key.name);
            this.data.put(key, result);
        }
        if (((AutomatonNode)result).isAmbiguous()) {
            return null;
        }
        return result;
    }

    public boolean isKeyExisting(InfoTableKey key) {
        return this.data.containsKey(key);
    }

    public AutomatonNode getTagNodeByKey(InfoTableKey key) {
        AutomatonNode result = ((AutomatonNode)this.data.get(key)).getYourself();
        return result;
    }

    public Enumeration getAllData() {
        return this.data.elements();
    }
}

