/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model;

import com.tssap.util.xml.schema.model.SchemaReference;
import java.util.Hashtable;
import java.util.Vector;

public class NamespacePrefixMapper {
    private Hashtable namespaceForPrefix = new Hashtable();
    private Hashtable prefixesForNamespaces = new Hashtable();
    private String defaultNameSpace = null;

    public NamespacePrefixMapper() {
    }

    public NamespacePrefixMapper(String DefaultNS) {
        this.defaultNameSpace = DefaultNS;
    }

    public NamespacePrefixMapper(Vector schemaReferences) {
        this.addAllSchemaReferences(schemaReferences);
    }

    public NamespacePrefixMapper(Vector schemaReferences, String DefaultNS) {
        this(schemaReferences);
        this.defaultNameSpace = DefaultNS;
    }

    public String getDefaultNamespace() {
        return this.defaultNameSpace;
    }

    public void addSchemaReference(SchemaReference sr) {
        if (sr.getPrefixes().contains("")) {
            this.defaultNameSpace = sr.getNamespaceName();
            sr.getPrefixes().remove("");
        }
        this.prefixesForNamespaces.put(sr.getNamespaceName(), sr.getPrefixes());
        int i = 0;
        while (i < sr.getPrefixes().size()) {
            this.namespaceForPrefix.put(sr.getPrefix(i), sr.getNamespaceName());
            ++i;
        }
    }

    private void addAllSchemaReferences(Vector srs) {
        int i = 0;
        while (i < srs.size()) {
            this.addSchemaReference((SchemaReference)srs.get(i));
            ++i;
        }
    }

    public String getNamespaceByPrefix(String prefix, String nodeType) {
        if (!(nodeType.startsWith("attribute") || prefix != null && prefix.length() != 0)) {
            return this.defaultNameSpace;
        }
        return (String)this.namespaceForPrefix.get(prefix);
    }

    public Vector getPrefixByNamespace(String ns, String nodeType) {
        if (!nodeType.startsWith("attribute") && ns.equals(this.defaultNameSpace)) {
            Vector<String> v = new Vector<String>();
            v.add("");
            return v;
        }
        return (Vector)this.prefixesForNamespaces.get(ns);
    }
}

