/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema.model;

import com.tssap.util.insight.exceptions.ContextInsufficientException;
import com.tssap.util.insight.exceptions.NoElementsPossibleException;
import com.tssap.util.insight.interfaces.DisplayableObjectI;
import com.tssap.util.insight.interfaces.PossibleElementsCalculatorI;
import com.tssap.util.insight.interfaces.PossibleElementsRequestI;
import com.tssap.util.insight.interfaces.SearchTargetI;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.xml.DOMAccess;
import com.tssap.util.xml.DOMParserI;
import com.tssap.util.xml.schema.model.NamespacePrefixMapper;
import com.tssap.util.xml.schema.model.NewModelEvent;
import com.tssap.util.xml.schema.model.NewModelListener;
import com.tssap.util.xml.schema.model.SchemaModel;
import com.tssap.util.xml.schema.model.SchemaReference;
import com.tssap.util.xml.schema.model.TargetNamespaceMismatchException;
import com.tssap.util.xml.schema.model.UrlSchemaMapper;
import com.tssap.util.xml.schema.model.appinfo.AppInfoData;
import com.tssap.util.xml.schema.model.dispatchers.DomModifierI;
import com.tssap.util.xml.schema.model.dispatchers.JspDispatcher;
import com.tssap.util.xml.schema.model.dispatchers.XmlDispatcher;
import com.tssap.util.xml.schema.model.elements.InputWord;
import com.tssap.util.xml.schema.model.elements.ResultTag;
import com.tssap.util.xml.schema.model.elements.ScannedAttribute;
import com.tssap.util.xml.schema.model.elements.ScannedElement;
import com.tssap.util.xml.schema.model.elements.ScannedTag;
import com.tssap.util.xml.schema.model.elements.ScannedType;
import com.tssap.util.xml.schema.model.finiteAutomata.AbstractMachine;
import com.tssap.util.xml.schema.model.finiteAutomata.SimulationControl;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleAttributesRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleElementRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleTagsRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleValuesRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlTarget;
import com.tssap.util.xml.schema.model.nodes.AttributeNode;
import com.tssap.util.xml.schema.model.nodes.AutomatonNode;
import com.tssap.util.xml.schema.model.nodes.ComplexTypeNode;
import com.tssap.util.xml.schema.model.nodes.NodeLocationData;
import com.tssap.util.xml.schema.model.nodes.NodeNotExistingException;
import com.tssap.util.xml.schema.model.nodes.NodeNotUniqueException;
import com.tssap.util.xml.schema.model.nodes.NodeWithAttributes;
import com.tssap.util.xml.schema.model.nodes.PlainNode;
import com.tssap.util.xml.schema.model.nodes.TagNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GlobalSchemaModel
implements NewModelListener,
PossibleElementsCalculatorI {
    public static final int BRACKET_TYPE_NONE = 0;
    public static final int BRACKET_TYPE_SIMPLE = 1;
    public static final int BRACKET_TYPE_CLOSING = 2;
    private Vector schemaReferenceList = new Vector();
    private UrlSchemaMapper urlSchemaMapper = new UrlSchemaMapper();
    private DomModifierI modifier;
    private Hashtable schemaModelsByNamespaceName = new Hashtable();
    private Hashtable schemaModelsByLocation = new Hashtable();
    private NamespacePrefixMapper nsPrefixMapper = new NamespacePrefixMapper();
    private EntityResolver resolver;
    private static TracerI tracer = TracingManager.getTracer(class$com$tssap$util$xml$schema$model$GlobalSchemaModel == null ? (class$com$tssap$util$xml$schema$model$GlobalSchemaModel = GlobalSchemaModel.class$("com.tssap.util.xml.schema.model.GlobalSchemaModel")) : class$com$tssap$util$xml$schema$model$GlobalSchemaModel);
    static /* synthetic */ Class class$com$tssap$util$xml$schema$model$GlobalSchemaModel;

    public GlobalSchemaModel(EntityResolver eResolver) {
        this.resolver = eResolver;
    }

    public void adjustSchemaReferences(String fileName, Vector newSchemaReferences) throws Throwable {
        String filePath = this.getFilePathByFileName(fileName);
        if (filePath == null) {
            throw new Throwable("Wrong file location specified");
        }
        if (newSchemaReferences == null || newSchemaReferences.size() == 0) {
            this.schemaModelsByNamespaceName.clear();
            this.nsPrefixMapper = new NamespacePrefixMapper();
            tracer.warning("No schema references specified in the source");
            return;
        }
        boolean found = false;
        String namespace = null;
        String location = null;
        int i = 0;
        while (i < newSchemaReferences.size()) {
            namespace = ((SchemaReference)newSchemaReferences.elementAt(i)).getNamespaceName();
            location = ((SchemaReference)newSchemaReferences.elementAt(i)).getLocation();
            int j = 0;
            while (j < this.schemaReferenceList.size()) {
                if (namespace.equals(((SchemaReference)this.schemaReferenceList.elementAt(j)).getNamespaceName())) {
                    found = true;
                }
                ++j;
            }
            if (location != null) {
                location = this.getAbsoluteLocation(filePath, location);
                if (this.modifier instanceof JspDispatcher) {
                    namespace = location;
                    ((SchemaReference)newSchemaReferences.elementAt(i)).setNamespaceName(location);
                }
                if (!found && this.schemaModelsByLocation.containsKey(location)) {
                    this.schemaModelsByNamespaceName.put(namespace, this.schemaModelsByLocation.get(location));
                } else {
                    try {
                        this.generateModel(location, namespace);
                    }
                    catch (TargetNamespaceMismatchException tme) {
                        tracer.warning("", tme);
                    }
                }
                SchemaModel model = (SchemaModel)this.schemaModelsByLocation.get(location);
                if (model != null) {
                    this.addSchemaReferenceIfNotExists(newSchemaReferences, model.getImportedSchemaReferences());
                }
            }
            ++i;
        }
        this.nsPrefixMapper = new NamespacePrefixMapper(newSchemaReferences);
        found = false;
        int i2 = 0;
        while (i2 < this.schemaReferenceList.size()) {
            namespace = ((SchemaReference)this.schemaReferenceList.elementAt(i2)).getNamespaceName();
            int j = 0;
            while (j < newSchemaReferences.size()) {
                if (namespace.equals(((SchemaReference)newSchemaReferences.elementAt(j)).getNamespaceName())) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                this.schemaModelsByNamespaceName.remove(namespace);
            }
            ++i2;
        }
        this.schemaReferenceList = newSchemaReferences;
    }

    private String getFilePathByFileName(String fileName) {
        String filePath = null;
        if (fileName.indexOf("\\") > -1) {
            filePath = fileName.substring(0, fileName.lastIndexOf("\\") + 1);
        } else if (fileName.indexOf("/") > -1) {
            filePath = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        }
        return filePath;
    }

    private String getAbsoluteLocation(String originalFilePath, String location) {
        String absolutePath;
        if (location.indexOf(":") > -1) {
            absolutePath = location;
        } else {
            absolutePath = originalFilePath + location;
            while (absolutePath.indexOf("..") > -1) {
                int index1 = absolutePath.indexOf("..");
                String firstPart = absolutePath.substring(0, index1 - 1);
                int index2 = firstPart.lastIndexOf("\\");
                if (index2 == -1 && (index2 = firstPart.lastIndexOf("/")) == -1) {
                    return absolutePath;
                }
                absolutePath = absolutePath.substring(0, index2) + absolutePath.substring(index1 + 2, absolutePath.length());
            }
        }
        return absolutePath;
    }

    private void addSchemaReferenceIfNotExists(Vector currentRefs, Vector importedRefs) {
        int i = 0;
        while (i < importedRefs.size()) {
            boolean add = true;
            SchemaReference ref = (SchemaReference)importedRefs.elementAt(i);
            int j = 0;
            while (j < currentRefs.size()) {
                if (ref.getLocation().equals(((SchemaReference)currentRefs.elementAt(j)).getLocation()) && ref.getNamespaceName().equals(((SchemaReference)currentRefs.elementAt(j)).getNamespaceName())) {
                    add = false;
                }
                ++j;
            }
            if (add) {
                currentRefs.add(ref);
            }
            ++i;
        }
    }

    private Node parseSchemaFile(Document lDocument, String location) throws Throwable {
        Node rootNode = null;
        rootNode = lDocument.getDocumentElement();
        if (this.modifier instanceof XmlDispatcher) {
            String prefix = null;
            NodeLocationData locationData = SchemaModel.createLocationData(rootNode);
            Vector prefixes = locationData.getPrefixByNamespace(SchemaModel.getDOMAttributeValue(rootNode, "targetNamespace"), "element");
            if (prefixes != null && prefixes.size() > 0) {
                prefix = (String)prefixes.elementAt(0);
            }
            rootNode = this.modifier.modifyDom(lDocument, prefix);
        }
        if (this.modifier instanceof JspDispatcher) {
            rootNode = this.modifier.modifyDom(lDocument, location);
        }
        return rootNode;
    }

    private Node parseSchemaFile(InputSource is) throws Throwable {
        DOMParserI lParser = DOMAccess.getDOMParser();
        Document lDocument = lParser.parse(is, true);
        return this.parseSchemaFile(lDocument, is.toString());
    }

    private Node parseSchemaFile(String location) throws Throwable {
        DOMParserI lParser = DOMAccess.getDOMParser();
        Document lDocument = lParser.parse(location, true);
        return this.parseSchemaFile(lDocument, location);
    }

    public NodeWithAttributes locateReferencedTagNode(String nodeType, String namespaceName, String name, boolean necessarilyExisting) {
        SchemaModel model = (SchemaModel)this.schemaModelsByNamespaceName.get(namespaceName);
        if (model == null) {
            model = new SchemaModel(this, null);
            this.schemaModelsByNamespaceName.put(namespaceName, model);
        }
        if (necessarilyExisting) {
            return model.locateTagNode(nodeType, name);
        }
        return model.locateReferencedTagNode(nodeType, name);
    }

    public void reScanKnownModels(String fileName) {
        Vector schemaRefs = (Vector)this.schemaReferenceList.clone();
        this.schemaModelsByLocation = new Hashtable();
        this.schemaReferenceList = new Vector();
        try {
            this.adjustSchemaReferences(fileName, schemaRefs);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private PlainNode getNodeByScannedTag(ScannedTag sTag, String nodeType) throws NodeNotUniqueException, NodeNotExistingException {
        String resultNamespace = null;
        AutomatonNode resultNode = null;
        if (sTag.isQualified()) {
            resultNamespace = this.nsPrefixMapper.getNamespaceByPrefix(sTag.getNameSpacePrefix(), "element");
        } else if (this.nsPrefixMapper.getDefaultNamespace() != null) {
            resultNamespace = this.nsPrefixMapper.getDefaultNamespace();
        }
        if (sTag.getNameSpacePrefix() != null && sTag.getNameSpacePrefix().length() > 0 && resultNamespace == null) {
            return null;
        }
        if (resultNamespace != null) {
            SchemaModel model = (SchemaModel)this.schemaModelsByNamespaceName.get(resultNamespace);
            resultNode = (TagNode)model.locateTagNode(nodeType, sTag.getUnQualifiedName());
            if (resultNode == null) {
                throw new NodeNotExistingException();
            }
            if (resultNode.isAmbiguous()) {
                throw new NodeNotUniqueException();
            }
        } else {
            int counter = 0;
            String tempNamespace = null;
            AutomatonNode tempNode = null;
            SchemaModel tempModel = null;
            int i = 0;
            while (i < this.schemaReferenceList.size()) {
                tempNamespace = ((SchemaReference)this.schemaReferenceList.elementAt(i)).getNamespaceName();
                tempModel = (SchemaModel)this.schemaModelsByNamespaceName.get(tempNamespace);
                if (tempModel != null && (tempNode = (AutomatonNode)tempModel.locateTagNode(nodeType, sTag.getUnQualifiedName())) != null) {
                    resultNamespace = tempNamespace;
                    resultNode = tempNode;
                    ++counter;
                }
                ++i;
            }
            if (counter > 1 || resultNode != null && resultNode.isAmbiguous()) {
                throw new NodeNotUniqueException();
            }
            if (counter == 0) {
                throw new NodeNotExistingException();
            }
        }
        sTag.setNameSpaceName(resultNamespace);
        return resultNode;
    }

    public boolean checkNameInNameSpace(String qualifiedName, String nameSpace) {
        ScannedTag element = new ScannedTag(qualifiedName, false);
        return this.nsPrefixMapper.getNamespaceByPrefix(element.getNameSpacePrefix(), "element").equals(nameSpace);
    }

    public Vector getTypeHierarchyForAttribute(String qualifiedTagName, String qualifiedAttributeName) throws NodeNotUniqueException, NodeNotExistingException {
        ScannedTag sTag = new ScannedTag(qualifiedTagName, false);
        sTag.setParent();
        InputWord iw = new InputWord();
        iw.add(sTag);
        Vector attributeNodes = this.getPossibleAttributesByInputWord(iw, false, true);
        int i = 0;
        while (i < attributeNodes.size()) {
            if (qualifiedAttributeName.endsWith(((AttributeNode)attributeNodes.elementAt(i)).getNameAsItIs())) {
                Vector tempVector = this.getTypeHierarchyForAttribute((AttributeNode)attributeNodes.elementAt(i));
                Vector<String> resultVector = new Vector<String>(tempVector.size());
                int j = 0;
                while (j < tempVector.size()) {
                    ScannedType st = (ScannedType)tempVector.elementAt(j);
                    Vector prefixes = this.nsPrefixMapper.getPrefixByNamespace(st.getNameSpaceName(), "complexType");
                    if (prefixes != null && prefixes.size() > 0) {
                        st.setNamespacePrefix((String)prefixes.elementAt(0));
                        resultVector.add(st.getQualifiedName());
                    }
                    ++j;
                }
                return resultVector;
            }
            ++i;
        }
        return null;
    }

    private Vector getTypeHierarchyForAttribute(AttributeNode attNode) {
        String type = attNode.getType();
        ScannedType st = new ScannedType(type);
        st.setNameSpaceName(attNode.getNameSpaceName(st.getNameSpacePrefix()));
        Vector<ScannedType> resultVector = new Vector<ScannedType>();
        resultVector.add(st);
        ComplexTypeNode typeNode = null;
        while (type != null && type.length() > 0) {
            typeNode = (ComplexTypeNode)this.locateReferencedTagNode("complexType", st.getNameSpaceName(), st.getUnQualifiedName(), true);
            if (typeNode != null) {
                type = typeNode.getBaseType();
                if (type == null) continue;
                st = new ScannedType(type);
                st.setNameSpaceName(typeNode.getNameSpaceName(st.getNameSpacePrefix()));
                resultVector.add(st);
                continue;
            }
            type = null;
        }
        return resultVector;
    }

    public AppInfoData getAppInfoData(ScannedTag sTag) {
        TagNode tagNode = null;
        try {
            tagNode = (TagNode)this.getNodeByScannedTag(sTag, "element");
        }
        catch (Exception ex) {
            tracer.warning("", ex);
        }
        return tagNode.getAppInfo();
    }

    private void analyseScannedTagForDerivedTypes(ScannedTag st) {
        Vector atts = st.getAttributes();
        int j = 0;
        while (j < atts.size()) {
            if (this.isTypeAttributeInSchemaInstanceNS((ScannedAttribute)atts.elementAt(j))) {
                ScannedType type = new ScannedType(((ScannedAttribute)atts.elementAt(j)).getValue());
                type.setNameSpaceName(this.nsPrefixMapper.getNamespaceByPrefix(type.getNameSpacePrefix(), "complexType"));
                st.setDerivedType(type);
                return;
            }
            ++j;
        }
    }

    public void setDispatcher(Object modifier) {
        this.modifier = (DomModifierI)modifier;
    }

    private Vector getPossibleValuesByInputWordAndAttributeName(InputWord iw, String attributeName) throws NodeNotUniqueException, NodeNotExistingException {
        Vector attributeNodes = this.getPossibleAttributesByInputWord(iw, false, true);
        if (attributeNodes == null || attributeNodes.size() < 1) {
            return null;
        }
        if (attributeName.indexOf(58) > -1) {
            boolean typeFlag = false;
            String prefix = attributeName.substring(0, attributeName.indexOf(58));
            String name = attributeName.substring(attributeName.indexOf(58) + 1, attributeName.length());
            if (this.nsPrefixMapper.getNamespaceByPrefix(prefix, "attribute").equals("http://www.w3.org/2001/XMLSchema-instance") && name.equals("type")) {
                typeFlag = true;
            }
            int i = 0;
            while (i < attributeNodes.size()) {
                Vector prefixes;
                if (((AttributeNode)attributeNodes.elementAt(i)).IsToBequalified() && (prefixes = this.nsPrefixMapper.getPrefixByNamespace(((AttributeNode)attributeNodes.elementAt(i)).getNameSpaceName(), "attribute")) != null) {
                    int j = 0;
                    while (j < prefixes.size()) {
                        if (attributeName.equals((String)prefixes.elementAt(j) + ':' + ((AttributeNode)attributeNodes.elementAt(i)).getNameAsItIs())) {
                            if (typeFlag) {
                                return ((AttributeNode)attributeNodes.elementAt(i)).getValues();
                            }
                            return this.resolveUserDefinedValuesForAttributes((AttributeNode)attributeNodes.elementAt(i));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < attributeNodes.size()) {
                if (attributeName.equals(((AttributeNode)attributeNodes.elementAt(i)).getNameAsItIs())) {
                    if (((AttributeNode)attributeNodes.elementAt(i)).getFixedValue() != null) {
                        Vector<String> fixedValues = new Vector<String>(1);
                        fixedValues.add(((AttributeNode)attributeNodes.elementAt(i)).getFixedValue());
                        return fixedValues;
                    }
                    return this.resolveUserDefinedValuesForAttributes((AttributeNode)attributeNodes.elementAt(i));
                }
                ++i;
            }
        }
        return null;
    }

    private Vector resolveUserDefinedValuesForAttributes(AttributeNode node) {
        ComplexTypeNode typeNode;
        String type = node.getType();
        if (type == null || type.length() < 1) {
            return null;
        }
        Vector valueVector = new Vector();
        if (node.getType() != null && (typeNode = (ComplexTypeNode)node.locateReferencedTagNode(this, 1, true)) != null) {
            valueVector = typeNode.getPossibleValues();
        }
        if (valueVector != null && valueVector.size() == 0) {
            valueVector = null;
        }
        return valueVector;
    }

    public String getDefaultValueForAttributeByInputWordAndAttributeName(InputWord iw, String attributeName) throws NodeNotUniqueException, NodeNotExistingException {
        Vector attributeNodes = this.getPossibleAttributesByInputWord(iw, false, true);
        int i = 0;
        while (i < attributeNodes.size()) {
            if (attributeName.equals(((AttributeNode)attributeNodes.elementAt(i)).getNameAsItIs())) {
                return ((AttributeNode)attributeNodes.elementAt(i)).getDefaultValue();
            }
            ++i;
        }
        return null;
    }

    private Vector getPossibleAttributesByInputWord(InputWord iw, boolean onlyMandatory, boolean resultVectorOfAttributeNodes) throws NodeNotUniqueException, NodeNotExistingException {
        return this.getPossibleAttributesByInputWord(iw, onlyMandatory, resultVectorOfAttributeNodes, null);
    }

    private Vector getPossibleAttributesByInputWord(InputWord iw, boolean onlyMandatory, boolean resultVectorOfAttributeNodes, Vector attributesAlreadyExisting) throws NodeNotUniqueException, NodeNotExistingException {
        TagNode ancestorNode = null;
        Vector attributeVector = new Vector();
        ScannedTag sTag = new ScannedTag();
        SimulationControl simCon = new SimulationControl(AbstractMachine.SIMULATION_DIRETION_FORWARD, new XmlTarget("attribute"));
        if (iw != null && iw.size() > 0) {
            sTag = iw.getFirstTag();
            this.analyseScannedTagForDerivedTypes(sTag);
            this.analyseScannedTagForDerivedTypes((ScannedTag)iw.elementAt(iw.size() - 1));
            ancestorNode = (TagNode)this.getNodeByScannedTag(sTag, "element");
            attributeVector = ancestorNode.getProperAutomaton().propagateInputCompletely(iw, simCon);
        }
        Vector<ScannedAttribute> scannedAttributesVector = new Vector<ScannedAttribute>();
        int i = 0;
        while (i < attributeVector.size()) {
            AttributeNode aNode = (AttributeNode)attributeVector.elementAt(i);
            if (this.isTypeAttributeInSchemaInstanceNS(aNode)) {
                Vector resultVector = new Vector();
                String nodeType = "attribute";
                if (aNode.getNameSpaceName().equals("http://www.w3.org/2001/XMLSchema-instance") && aNode.getNameAsItIs().equals("type")) {
                    nodeType = "element";
                }
                int j = 0;
                while (j < aNode.getValues().size()) {
                    resultVector.addAll(this.prefixing(aNode.getValues().elementAt(j), nodeType));
                    ++j;
                }
                aNode.setValues(resultVector);
            }
            if (!(aNode.isProhibited() || onlyMandatory && !aNode.isMandatory())) {
                if (!resultVectorOfAttributeNodes) {
                    ScannedAttribute att = new ScannedAttribute(aNode.getUnqualifiedPartName());
                    att.setNameSpaceName(aNode.getNameSpaceName());
                    if (aNode.IsToBequalified()) {
                        scannedAttributesVector.addAll(this.prefixing(att, "attribute"));
                    } else {
                        scannedAttributesVector.add(att);
                    }
                }
            } else if (resultVectorOfAttributeNodes) {
                attributeVector.remove(i);
            }
            ++i;
        }
        if (resultVectorOfAttributeNodes) {
            return attributeVector;
        }
        return this.buildScannedElementsDifference(scannedAttributesVector, attributesAlreadyExisting);
    }

    public Vector getPossibleElements(PossibleElementsRequestI request) throws NoElementsPossibleException, ContextInsufficientException {
        if (this.schemaModelsByLocation.size() == 0) {
            return null;
        }
        XmlTarget target = (XmlTarget)request.getSearchTarget();
        if (target.getTarget().equals("tag")) {
            return this.getPossibleTagNamesByInputWord(((XmlPossibleElementRequest)request).getInputWord(), ((XmlPossibleTagsRequest)request).getSimulationControl());
        }
        if (target.getTarget().equals("attribute")) {
            return this.getPossibleAttributesByInputWord(((XmlPossibleElementRequest)request).getInputWord(), false, false, ((XmlPossibleAttributesRequest)request).getAttributesAlreadyExisting());
        }
        if (target.getTarget().equals("mandatoryAttribute")) {
            return this.getPossibleAttributesByInputWord(((XmlPossibleElementRequest)request).getInputWord(), true, false, ((XmlPossibleAttributesRequest)request).getAttributesAlreadyExisting());
        }
        if (target.getTarget().equals("value")) {
            return this.getPossibleValuesByInputWordAndAttributeName(((XmlPossibleElementRequest)request).getInputWord(), ((XmlPossibleValuesRequest)request).getAttributeName());
        }
        return null;
    }

    private Vector getPossibleTagNamesByInputWord(InputWord iw, SimulationControl simCon) throws NodeNotUniqueException, NodeNotExistingException {
        TagNode ancestorNode = null;
        Vector tagVector = new Vector();
        ScannedTag sTag = new ScannedTag();
        if (iw != null && iw.size() > 0) {
            sTag = iw.getFirstTag();
            this.analyseScannedTagForDerivedTypes(sTag);
            ancestorNode = (TagNode)this.getNodeByScannedTag(sTag, "element");
            tagVector = ancestorNode.getProperAutomaton().propagateInputCompletely(iw, simCon);
        } else {
            iw = new InputWord();
            int i = 0;
            while (i < this.schemaReferenceList.size()) {
                String tempNamespace = ((SchemaReference)this.schemaReferenceList.elementAt(i)).getNamespaceName();
                SchemaModel tempModel = (SchemaModel)this.schemaModelsByNamespaceName.get(tempNamespace);
                if (tempModel != null) {
                    TagNode tempNode = (TagNode)tempModel.locateTagNode("element", null);
                    tagVector.addAll(tempNode.getProperAutomaton().propagateInputCompletely(iw, simCon));
                }
                ++i;
            }
        }
        if (tagVector == null) {
            return null;
        }
        Vector<ResultTag> resultVector = new Vector<ResultTag>();
        int i = 0;
        while (i < tagVector.size()) {
            ResultTag tag = (ResultTag)tagVector.elementAt(i);
            if (!tag.isAbstract()) {
                if (tag.tagCorresponds(sTag)) {
                    tag.setNamespacePrefix(sTag.getNameSpacePrefix());
                    resultVector.add(tag);
                } else if (tag.isToBeQualified()) {
                    resultVector.addAll(this.prefixing(tag, "element"));
                } else {
                    resultVector.add(tag);
                }
            }
            ++i;
        }
        return resultVector;
    }

    private Vector prefixing(Object entry, String nodeType) {
        String namespace = ((ScannedElement)entry).getNameSpaceName();
        Vector<ScannedElement> resultVector = new Vector<ScannedElement>();
        Vector prefixes = this.nsPrefixMapper.getPrefixByNamespace(namespace, nodeType);
        if (prefixes != null) {
            int j = 0;
            while (j < prefixes.size()) {
                ScannedElement clonedEntry = (ScannedElement)((ScannedElement)entry).clone();
                clonedEntry.setNamespacePrefix((String)prefixes.elementAt(j));
                resultVector.add(clonedEntry);
                ++j;
            }
        }
        return resultVector;
    }

    public void importTagOccured(NewModelEvent e) throws Throwable {
        try {
            this.generateModel(this.getAbsoluteLocation(e.getFilePath(), e.getSchemaLocation()), e.getNamespace());
        }
        catch (TargetNamespaceMismatchException tme) {
            tracer.error("Mismatching target namespace", tme);
        }
    }

    public void includeTagOccured(NewModelEvent e) throws Throwable {
        Node rootNode;
        block6: {
            rootNode = null;
            tracer.info("Starting include...");
            tracer.info("Location: " + e.getSchemaLocation());
            try {
                rootNode = this.parseSchemaFile(this.getAbsoluteLocation(e.getFilePath(), e.getSchemaLocation()));
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    try {
                        rootNode = this.parseSchemaFile(this.urlSchemaMapper.convertLocation(e.getSchemaLocation()));
                    }
                    catch (Throwable th) {
                        if (this.resolver != null) {
                            rootNode = this.parseSchemaFile(this.resolver.resolveEntity(e.getSchemaLocation(), null));
                            break block6;
                        }
                        throw th;
                    }
                }
                t.printStackTrace();
                return;
            }
        }
        ((SchemaModel)e.getSource()).analyseRootNode(rootNode, true, e.getFilePath());
        tracer.info("Done!");
    }

    public void redefineTagOccured(NewModelEvent e) {
        tracer.info("redefine tag occured");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateModel(String location, String namespace) throws TargetNamespaceMismatchException, Throwable {
        if (!this.schemaModelsByLocation.containsKey(location)) {
            Node rootNode;
            block12: {
                rootNode = null;
                tracer.info("Parsing the schema...");
                tracer.info("Location: " + location);
                try {
                    rootNode = this.parseSchemaFile(location);
                }
                catch (Throwable t) {
                    if (t instanceof InvocationTargetException) {
                        try {
                            rootNode = this.parseSchemaFile(this.urlSchemaMapper.convertLocation(location));
                        }
                        catch (Throwable th) {
                            if (th instanceof InvocationTargetException) {
                                try {
                                    rootNode = this.modifier instanceof XmlDispatcher ? this.parseSchemaFile(this.urlSchemaMapper.findSchemaLocationFromUrl(namespace)) : this.parseSchemaFile(this.getInputSourceByEntityResolver(location));
                                    break block12;
                                }
                                catch (Throwable thr) {
                                    try {
                                        rootNode = this.parseSchemaFile(this.getInputSourceByEntityResolver(location));
                                        break block12;
                                    }
                                    catch (Throwable thro) {
                                        tracer.error("Error while parsing the schema; conversion, mapping, entity resolving failed, Abort!", thro);
                                        return;
                                    }
                                }
                            }
                            tracer.error("Error while parsing the schema; conversion, mapping, entity resolving failed, Abort!", th);
                            return;
                        }
                    }
                    tracer.error("Error while parsing the schema; conversion, mapping, entity resolving failed, Abort!", t);
                    return;
                }
            }
            tracer.info("Schema file could be read and parsed correctly  :-)");
            SchemaModel model = null;
            if (rootNode == null) {
                tracer.warning("Model could not be generated!");
                return;
            }
            model = new SchemaModel(this, rootNode);
            if (!model.getTargetNamespace().equals(namespace)) throw new TargetNamespaceMismatchException();
            model.addNewModelListener(this);
            this.schemaModelsByNamespaceName.put(namespace, model);
            this.schemaModelsByLocation.put(location, model);
            model.analyseRootNode(rootNode, false, this.getFilePathByFileName(location));
            model.resolveAttributeGroups();
            model.buildTypeHierarchy(rootNode);
            tracer.info("Generation of Model Done!");
            return;
        }
        this.schemaModelsByNamespaceName.put(namespace, this.schemaModelsByLocation.get(location));
    }

    private InputSource getInputSourceByEntityResolver(String location) throws IOException, SAXException {
        if (this.resolver != null) {
            tracer.info("Entity resolver found...");
            tracer.info("Type: " + this.resolver.getClass().toString());
            tracer.info("Input: " + location + " used as System Id");
            return this.resolver.resolveEntity(null, location);
        }
        tracer.info("No entity resolver found");
        return null;
    }

    public Vector convertElementListToStringList(Vector scannedElements, SearchTargetI target) {
        if (scannedElements == null || scannedElements.size() == 0) {
            return null;
        }
        Vector elementNames = new Vector();
        String elementToAdd = null;
        String nodeType = ((XmlTarget)target).getTarget();
        int i = 0;
        while (i < scannedElements.size()) {
            if (scannedElements.elementAt(i) instanceof DisplayableObjectI) {
                elementNames.add(scannedElements.elementAt(i));
            } else {
                if (nodeType.equals("tag")) {
                    ResultTag tag = (ResultTag)scannedElements.elementAt(i);
                    if (tag.getConversionType() == 1) {
                        String part1 = this.addTagBrace(tag.getQualifiedName(), 1, 1);
                        String part2 = this.addTagBrace(tag.getQualifiedName(), 2, 1);
                        elementToAdd = part1 + part2;
                    }
                    if (tag.getConversionType() == 2) {
                        elementToAdd = this.addTagBrace(tag.getQualifiedName(), 2, 1);
                    }
                    if (tag.getConversionType() == 0) {
                        elementToAdd = this.addTagBrace(tag.getQualifiedName(), 1, 1);
                    }
                    if (tag.getConversionType() == 3) {
                        elementToAdd = this.addTagBrace(tag.getQualifiedName(), 1, 2);
                    }
                } else {
                    Object element = scannedElements.elementAt(i);
                    elementToAdd = element instanceof ScannedElement ? ((ScannedElement)scannedElements.elementAt(i)).getQualifiedName() : (String)element;
                }
                boolean needsAdding = true;
                int j = 0;
                while (j < elementNames.size()) {
                    if (elementToAdd.equals(elementNames.elementAt(j).toString())) {
                        needsAdding = false;
                    }
                    ++j;
                }
                if (needsAdding) {
                    elementNames.add(elementToAdd);
                }
            }
            ++i;
        }
        if (elementNames.size() > 1) {
            this.sortStringList(elementNames);
        }
        return elementNames;
    }

    private String addTagBrace(String tagName, int leftBracketType, int rightBracketType) {
        if (tagName == null) {
            return "";
        }
        String lTag = tagName;
        lTag = GlobalSchemaModel.deleteTagBrace(lTag);
        switch (leftBracketType) {
            case 1: {
                lTag = "<" + lTag;
                break;
            }
            case 2: {
                lTag = "</" + lTag;
                break;
            }
            case 0: {
                break;
            }
            default: {
                tracer.info("Unknown left bracket type!");
            }
        }
        switch (rightBracketType) {
            case 1: {
                lTag = lTag + ">";
                break;
            }
            case 2: {
                lTag = lTag + "/>";
                break;
            }
            case 0: {
                break;
            }
            default: {
                tracer.info("Unknown right bracket type!");
            }
        }
        return lTag;
    }

    private static String deleteTagBrace(String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return "";
        }
        String lTag = tagName;
        if (lTag.startsWith("</")) {
            lTag = lTag.substring(2);
        } else if (lTag.startsWith("<")) {
            lTag = lTag.substring(1);
        }
        if (lTag.endsWith("/>")) {
            lTag = lTag.substring(0, lTag.length() - 2);
        } else if (lTag.endsWith(">")) {
            lTag = lTag.substring(0, lTag.length() - 1);
        }
        return lTag;
    }

    public void sortStringList(Vector stringList) {
        if (stringList.size() <= 0) {
            return;
        }
        Vector<String> pureStrings = new Vector<String>();
        Vector noneStrings = new Vector();
        int i = 0;
        while (i < stringList.size()) {
            if (!(stringList.elementAt(i) instanceof String)) {
                pureStrings.add(stringList.elementAt(i).toString());
                noneStrings.add(stringList.elementAt(i));
            } else {
                pureStrings.add((String)stringList.elementAt(i));
            }
            ++i;
        }
        Object[] lStrings = new String[]{};
        lStrings = pureStrings.toArray(lStrings);
        stringList.clear();
        Arrays.sort(lStrings);
        int i2 = 0;
        while (i2 < lStrings.length) {
            stringList.add(lStrings[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < noneStrings.size()) {
            Object o = noneStrings.elementAt(i3);
            int j = 0;
            while (j < stringList.size()) {
                if (stringList.elementAt(j) instanceof String && ((String)stringList.elementAt(j)).equals(o.toString())) {
                    stringList.setElementAt(o, j);
                    break;
                }
                ++j;
            }
            ++i3;
        }
    }

    private Vector buildScannedElementsDifference(Vector allElements, Vector existingElements) {
        if (existingElements == null) {
            return allElements;
        }
        Vector differenceVector = new Vector();
        int x = 0;
        while (x < allElements.size()) {
            ScannedElement possElement = (ScannedElement)allElements.get(x);
            boolean elementExistsAlready = false;
            int y = 0;
            while (y < existingElements.size()) {
                ScannedElement currentElement = (ScannedElement)existingElements.get(y);
                if (possElement.getUnQualifiedName().equals(currentElement.getUnQualifiedName()) && currentElement.getNameSpacePrefix().equals(possElement.getNameSpacePrefix())) {
                    elementExistsAlready = true;
                }
                ++y;
            }
            if (!elementExistsAlready) {
                differenceVector.add(allElements.get(x));
            }
            ++x;
        }
        return differenceVector;
    }

    private boolean isTypeAttributeInSchemaInstanceNS(AttributeNode attribute) {
        return attribute.getNameSpaceName().equals("http://www.w3.org/2001/XMLSchema-instance") && attribute.getUnqualifiedPartName().equals("type");
    }

    private boolean isTypeAttributeInSchemaInstanceNS(ScannedAttribute attribute) {
        return attribute != null && attribute.getNameSpacePrefix() != null && !attribute.getNameSpacePrefix().equals("") && this.nsPrefixMapper.getNamespaceByPrefix(attribute.getNameSpacePrefix(), "attribute") != null && this.nsPrefixMapper.getNamespaceByPrefix(attribute.getNameSpacePrefix(), "attribute").equals("http://www.w3.org/2001/XMLSchema-instance") && attribute.getUnQualifiedName().equals("type");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

