/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml.schema;

import com.tssap.util.insight.exceptions.ContextInsufficientException;
import com.tssap.util.insight.exceptions.NoElementsPossibleException;
import com.tssap.util.insight.interfaces.MultipleContextDirectionsI;
import com.tssap.util.xml.schema.model.GlobalSchemaModel;
import com.tssap.util.xml.schema.model.SchemaReference;
import com.tssap.util.xml.schema.model.appinfo.AppInfoData;
import com.tssap.util.xml.schema.model.dispatchers.XmlDispatcher;
import com.tssap.util.xml.schema.model.elements.InputWord;
import com.tssap.util.xml.schema.model.elements.ScannedElement;
import com.tssap.util.xml.schema.model.elements.ScannedTag;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleAttributesRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleTagsRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleValuesRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlTarget;
import com.tssap.util.xml.schema.model.util.Helper;
import java.util.Vector;
import org.xml.sax.EntityResolver;

public class SchemaInfo {
    private GlobalSchemaModel modelManager;

    public SchemaInfo(String fileName, Vector schemaReferenceVector) throws Throwable {
        this(fileName, schemaReferenceVector, null);
    }

    public SchemaInfo(String fileName, SchemaReference reference) throws Throwable {
        this(fileName, reference, null);
    }

    public SchemaInfo(String fileName, Vector schemaReferenceVector, EntityResolver er) throws Throwable {
        this.modelManager = new GlobalSchemaModel(er);
        this.modelManager.setDispatcher(new XmlDispatcher());
        this.modelManager.adjustSchemaReferences(fileName, schemaReferenceVector);
    }

    public SchemaInfo(String fileName, SchemaReference reference, EntityResolver er) throws Throwable {
        Vector<SchemaReference> references = new Vector<SchemaReference>(1);
        references.add(reference);
        this.modelManager = new GlobalSchemaModel(er);
        this.modelManager.setDispatcher(new XmlDispatcher());
        this.modelManager.adjustSchemaReferences(fileName, references);
    }

    public Vector getInnerTags(String qualifiedTagName) {
        Vector<String> scannedResults = new Vector<String>();
        InputWord iw = new InputWord();
        if (qualifiedTagName.length() != 0) {
            ScannedTag tag = new ScannedTag(qualifiedTagName, false);
            tag.setParent();
            iw.add(tag);
        }
        XmlPossibleTagsRequest req = new XmlPossibleTagsRequest(new XmlTarget("tag"), new MultipleContextDirectionsI(){

            public String getContextDirection() {
                return "diffuse";
            }
        }, iw);
        try {
            scannedResults = this.modelManager.getPossibleElements(req);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        Vector<String> temp = new Vector<String>();
        int i = 0;
        while (i < scannedResults.size()) {
            temp.add(((ScannedElement)scannedResults.elementAt(i)).getQualifiedName());
            ++i;
        }
        scannedResults = temp;
        int i2 = 0;
        while (i2 < scannedResults.size()) {
            if (((String)scannedResults.elementAt(i2)).equals(qualifiedTagName)) {
                scannedResults.remove(i2);
                break;
            }
            ++i2;
        }
        return scannedResults;
    }

    public Vector getTypeHierarchyForAttribute(String qualifiedTagName, String qualifiedAttributeName) {
        try {
            return this.modelManager.getTypeHierarchyForAttribute(qualifiedTagName, qualifiedAttributeName);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public Vector getValuesForAttribute(String qualifiedTagName, String qualifiedAttributeName) {
        ScannedTag sTag = new ScannedTag(qualifiedTagName, false);
        sTag.setParent();
        InputWord iw = new InputWord(sTag);
        Vector values = new Vector();
        try {
            values = this.modelManager.getPossibleElements(new XmlPossibleValuesRequest(new XmlTarget("value"), null, iw, qualifiedAttributeName));
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return values;
    }

    public String getDefaultValueForAttribute(String qualifiedTagName, String qualifiedAttributeName) {
        ScannedTag sTag = new ScannedTag(qualifiedTagName, false);
        sTag.setParent();
        InputWord iw = new InputWord(sTag);
        String defaultValue = null;
        try {
            defaultValue = this.modelManager.getDefaultValueForAttributeByInputWordAndAttributeName(iw, qualifiedAttributeName);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return defaultValue;
    }

    public Vector getAttributeNamesForTag(String qualifiedTagName) throws NoElementsPossibleException, ContextInsufficientException {
        Vector scannedResults = new Vector();
        InputWord iw = new InputWord();
        iw.add(new ScannedTag(qualifiedTagName, false));
        scannedResults = this.modelManager.getPossibleElements(new XmlPossibleAttributesRequest(new XmlTarget("attribute"), null, iw));
        return this.modelManager.convertElementListToStringList(scannedResults, new XmlTarget("attribute"));
    }

    public AppInfoData getAppInfoData(String qualifiedTagName) {
        ScannedTag sTag = new ScannedTag(qualifiedTagName, false);
        return this.modelManager.getAppInfoData(sTag);
    }

    private InputWord makeInputWord(String fatherTagName, Vector siblings, MultipleContextDirectionsI direction) {
        InputWord resultWord = new InputWord();
        boolean closed = direction.getContextDirection().equals("forward");
        ScannedTag fatherTag = new ScannedTag(fatherTagName, closed);
        fatherTag.setParent();
        resultWord.add(fatherTag);
        if (siblings != null) {
            int i = 0;
            while (i < siblings.size()) {
                ScannedTag sisterTag = new ScannedTag((String)siblings.elementAt(i), closed);
                sisterTag.setSisterTag();
                resultWord.add(sisterTag);
                sisterTag = new ScannedTag((String)siblings.elementAt(i), !closed);
                sisterTag.setSisterTag();
                resultWord.add(sisterTag);
                ++i;
            }
        }
        return resultWord;
    }

    public boolean isInsertable(String qualifiedTagName, String fatherTagName, Vector youngerSiblings, Vector olderSiblings) {
        MultipleContextDirectionsI directionBackward = new MultipleContextDirectionsI(){

            public String getContextDirection() {
                return "backward";
            }
        };
        MultipleContextDirectionsI directionForward = new MultipleContextDirectionsI(){

            public String getContextDirection() {
                return "forward";
            }
        };
        Vector scannedTagListForward = null;
        Vector scannedTagListBackward = null;
        try {
            XmlPossibleTagsRequest req = new XmlPossibleTagsRequest(new XmlTarget("tag"), directionBackward, this.makeInputWord(fatherTagName, youngerSiblings, directionBackward));
            scannedTagListForward = this.modelManager.getPossibleElements(req);
            req = new XmlPossibleTagsRequest(new XmlTarget("tag"), directionForward, this.makeInputWord(fatherTagName, olderSiblings, directionForward));
            scannedTagListBackward = this.modelManager.getPossibleElements(req);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Vector scannedTags = Helper.intersection(scannedTagListForward, scannedTagListBackward);
        ScannedTag insertTag = new ScannedTag(qualifiedTagName, false);
        int i = 0;
        while (i < scannedTags.size()) {
            if (((ScannedTag)scannedTags.elementAt(i)).getUnQualifiedName().equals(insertTag.getUnQualifiedName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

