/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.tree;

import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import com.tssap.util.ui.viewer.tree.SapAbstractTreeViewer;
import com.tssap.util.ui.viewer.tree.SapTreeContentProvider;
import com.tssap.util.ui.viewer.tree.SapTreeLabelProvider;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class SapTreeViewer
extends SapAbstractTreeViewer
implements ISapTreeViewer {
    private TreeModel treeModel;

    SapTreeViewer(Composite parent, TreeModel model) {
        this(parent, model, new SapTreeLabelProvider());
    }

    SapTreeViewer(Composite parent, TreeModel model, SapTreeLabelProvider labelProvider) {
        this(parent, model, SapTreeContentProvider.DEFAULT_ROOT_LEVEL, labelProvider);
    }

    SapTreeViewer(Composite parent, TreeModel model, int rootLevel) {
        this(parent, model, rootLevel, new SapTreeLabelProvider());
    }

    SapTreeViewer(Composite parent, TreeModel model, int rootLevel, SapTreeLabelProvider labelProvider) {
        super(parent);
        this.setLabelProvider(labelProvider);
        this.initialize(model, rootLevel);
    }

    SapTreeViewer(TreeViewer treeViewer, TreeModel model) {
        this(treeViewer, model, new SapTreeLabelProvider());
    }

    SapTreeViewer(TreeViewer treeViewer, TreeModel model, SapTreeLabelProvider labelProvider) {
        this(treeViewer, model, SapTreeContentProvider.DEFAULT_ROOT_LEVEL, labelProvider);
    }

    SapTreeViewer(TreeViewer treeViewer, TreeModel model, int rootLevel) {
        this(treeViewer, model, rootLevel, new SapTreeLabelProvider());
    }

    SapTreeViewer(TreeViewer treeViewer, TreeModel model, int rootLevel, SapTreeLabelProvider labelProvider) {
        super(treeViewer);
        this.setLabelProvider(labelProvider);
        this.initialize(model, rootLevel);
    }

    private void initialize(TreeModel model) {
        this.initialize(model, SapTreeContentProvider.DEFAULT_ROOT_LEVEL);
    }

    private void initialize(TreeModel model, int rootLevel) {
        this.getTreeViewer().setContentProvider((IContentProvider)new SapTreeContentProvider(model, rootLevel));
        this.getTreeViewer().setInput((Object)model);
        this.setTreeModel(model);
    }

    public static ISapTreeViewer createTreeViewer(Composite parent, TreeModel model) {
        SapTreeViewer ret = new SapTreeViewer(parent, model);
        return ret;
    }

    public static ISapTreeViewer createTreeViewer(Composite parent, TreeModel model, int rootLevel) {
        SapTreeViewer ret = new SapTreeViewer(parent, model, rootLevel);
        return ret;
    }

    public static ISapTreeViewer createTreeViewer(Composite parent, TreeModel model, SapTreeLabelProvider labelProvider) {
        SapTreeViewer ret = new SapTreeViewer(parent, model, labelProvider);
        return ret;
    }

    public static ISapTreeViewer createTreeViewer(Composite parent, TreeModel model, int rootLevel, SapTreeLabelProvider labelProvider) {
        SapTreeViewer ret = new SapTreeViewer(parent, model, labelProvider);
        return ret;
    }

    public static ISapTreeViewer createTreeViewer(TreeViewer treeViewer, TreeModel model) {
        SapTreeViewer ret = new SapTreeViewer(treeViewer, model);
        return ret;
    }

    public static ISapTreeViewer createTreeViewer(TreeViewer treeViewer, TreeModel model, int rootLevel) {
        SapTreeViewer ret = new SapTreeViewer(treeViewer, model, rootLevel);
        return ret;
    }

    public static ISapTreeViewer createTreeViewer(TreeViewer treeViewer, TreeModel model, SapTreeLabelProvider labelProvider) {
        SapTreeViewer ret = new SapTreeViewer(treeViewer, model, labelProvider);
        return ret;
    }

    public static ISapTreeViewer createTreeViewer(TreeViewer treeViewer, TreeModel model, int rootLevel, SapTreeLabelProvider labelProvider) {
        SapTreeViewer ret = new SapTreeViewer(treeViewer, model, rootLevel, labelProvider);
        return ret;
    }

    public void setLabelProvider(SapTreeLabelProvider newLabelProvider) {
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)newLabelProvider);
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(TreeModel newTreeModel) {
        TreeModel oldTreeModel = this.getTreeModel();
        if (oldTreeModel == null || !oldTreeModel.equals(newTreeModel)) {
            this.treeModel = newTreeModel;
            newTreeModel.addTreeModelListener(new InnerTreeModelListener(this));
            if (this.getTreeViewer().getContentProvider() instanceof SapTreeContentProvider) {
                SapTreeContentProvider contProv = (SapTreeContentProvider)this.getTreeViewer().getContentProvider();
                contProv.setModel(newTreeModel);
            }
            this.getTreeViewer().setInput((Object)newTreeModel);
        }
    }

    public void setRootLevel(int rootLevel) {
        TreeModel model = this.getTreeModel();
        this.initialize(model, rootLevel);
    }

    class InnerTreeModelListener
    implements TreeModelListener {
        private SapTreeViewer viewer;

        public InnerTreeModelListener(SapTreeViewer viewer) {
            this.setViewer(viewer);
        }

        public void treeNodesChanged(TreeModelEvent e) {
            Object[] children = e.getChildren();
            if (children == null || children.length == 0) {
                Object parentObject = e.getTreePath().getLastPathComponent();
                SapTreeViewer.this.getTreeViewer().update(parentObject, null);
            } else {
                SapTreeViewer.this.getTreeViewer().update(children, null);
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.treeStructureChanged(e);
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.treeStructureChanged(e);
        }

        public void treeStructureChanged(TreeModelEvent e) {
            SapTreeViewer.this.getTreeViewer().refresh(e.getTreePath().getLastPathComponent());
        }

        protected SapTreeViewer getViewer() {
            return this.viewer;
        }

        protected void setViewer(SapTreeViewer viewer) {
            this.viewer = viewer;
        }
    }
}

