/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.tree;

import com.tssap.util.ui.viewer.tree.ISapTreeNode;
import com.tssap.util.ui.viewer.tree.SapAbstractTreeLabelProvider;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.eclipse.swt.graphics.Image;

public class SapTreeLabelProvider
extends SapAbstractTreeLabelProvider {
    private static String DEFAULT_NAME = "";
    private static boolean SHOW_OBJECT_TO_STRING_AS_TEXT = true;
    private TreeModel model;

    public SapTreeLabelProvider(TreeModel model) {
        this();
        this.setModel(model);
    }

    public SapTreeLabelProvider() {
    }

    protected TreeModel getModel() {
        return this.model;
    }

    protected void setModel(TreeModel model) {
        this.model = model;
    }

    public Image getImage(Object obj) {
        int childCount = 0;
        if (obj instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)obj;
            childCount = treeNode.getChildCount();
        }
        if (childCount > 0) {
            return SapAbstractTreeLabelProvider.getIcon(1);
        }
        return SapAbstractTreeLabelProvider.getIcon(2);
    }

    public String getText(Object obj) {
        String ret = DEFAULT_NAME;
        if (obj != null) {
            if (obj instanceof ISapTreeNode) {
                ISapTreeNode treeNode = (ISapTreeNode)obj;
                ret = treeNode.getText();
            } else if (obj instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
                Object userObj = treeNode.getUserObject();
                if (userObj != null) {
                    ret = userObj.toString();
                }
            } else if (SHOW_OBJECT_TO_STRING_AS_TEXT) {
                ret = obj.toString();
            }
        }
        return ret;
    }
}

