/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.tree;

import java.util.Arrays;
import java.util.Vector;
import javax.swing.tree.TreeModel;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class SapTreeContentProvider
implements ITreeContentProvider {
    public static int DEFAULT_ROOT_LEVEL = 0;
    private boolean optimisticChildrenHandling = false;
    private TreeModel treeModel;
    private int rootLevel = DEFAULT_ROOT_LEVEL;

    public SapTreeContentProvider(TreeModel model, int rootLevel) {
        this(model);
        this.setRootLevel(rootLevel);
    }

    public SapTreeContentProvider(TreeModel model) {
        this.treeModel = model;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == null) {
            return null;
        }
        int childCount = this.getModel().getChildCount(parentElement);
        Object[] retChildren = new Object[childCount];
        int i = 0;
        while (i < childCount) {
            retChildren[i] = this.getModel().getChild(parentElement, i);
            ++i;
        }
        return retChildren;
    }

    public Object getParent(Object element) {
        Object rootElement = this.getModel().getRoot();
        Object ret = this.findParentOfElementInSubTree(element, rootElement);
        return ret;
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (this.optimisticChildrenHandling) {
            return true;
        }
        int childCount = this.getModel().getChildCount(element);
        return childCount > 0;
    }

    public Object[] getElements(Object inputElement) {
        Object[] ret = new Object[]{};
        if (inputElement.equals(this.getModel())) {
            Object root = this.getModel().getRoot();
            ret = this.getChildElementsOnLevel(root, this.getRootLevel());
        }
        return ret;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof TreeModel) {
            this.treeModel = (TreeModel)newInput;
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setModel(TreeModel model) {
        this.treeModel = model;
    }

    private boolean isParentOf(Object element, Object potentialParent) {
        return this.isChildOf(element, potentialParent);
    }

    private boolean isChildOf(Object potentialChild, Object element) {
        if (element == null || potentialChild == null) {
            return false;
        }
        Object[] children = this.getElements(element);
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(potentialChild)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object findParentOfElementInSubTree(Object element, Object rootElement) {
        Object[] rootChildren = this.getChildren(rootElement);
        int i = 0;
        while (i < rootChildren.length) {
            Object currentElement = rootChildren[i];
            if (this.isParentOf(currentElement, element)) {
                return currentElement;
            }
            Object ret = this.findParentOfElementInSubTree(element, currentElement);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    int getRootLevel() {
        return this.rootLevel;
    }

    private void setRootLevel(int rootLayer) {
        this.rootLevel = rootLayer;
    }

    protected final Object[] getChildElementsOnLevel(Object root, int level) {
        Object[] ret = new Object[]{};
        if (level <= 0) {
            ret = new Object[]{root};
        } else {
            Object[] directChildren = this.getChildren(root);
            int i = level - 1;
            while (i > 0) {
                directChildren = this.getDirectChildren(directChildren);
                --i;
            }
            ret = directChildren;
        }
        return ret;
    }

    protected final Object[] getDirectChildren(Object[] parents) {
        Object[] ret = new Object[]{};
        Vector<Object> retVector = new Vector<Object>();
        int i = 0;
        while (i < parents.length) {
            Object oneParent = parents[i];
            Object[] childs = this.getChildren(oneParent);
            retVector.addAll(Arrays.asList(childs));
            ++i;
        }
        ret = retVector.toArray(ret);
        return ret;
    }
}

