/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.tree;

import com.tssap.util.ui.viewer.IViewerContext;
import com.tssap.util.ui.viewer.SapViewer;
import com.tssap.util.ui.viewer.tree.ISapAbstractTreeViewer;
import com.tssap.util.ui.viewer.tree.TreeViewerContext;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public abstract class SapAbstractTreeViewer
extends SapViewer
implements ISapAbstractTreeViewer {
    private boolean expandSingleChildAutomatically = false;

    protected SapAbstractTreeViewer(Composite parent) {
        this(parent, false);
    }

    protected SapAbstractTreeViewer(Composite parent, boolean singleSelection) {
        FillLayout compoLayout = new FillLayout();
        compoLayout.type = 512;
        parent.setLayout((Layout)compoLayout);
        int selectionStyle = singleSelection ? 4 : 2;
        Tree tree = new Tree(parent, selectionStyle | 0x200 | 0x100);
        GridData treeGridData = new GridData(1808);
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)treeGridData);
        this.setViewer((StructuredViewer)new TreeViewer(tree));
    }

    protected SapAbstractTreeViewer(TreeViewer treeViewer) {
        this.setViewer((StructuredViewer)treeViewer);
    }

    public TreeViewer getTreeViewer() {
        TreeViewer ret = null;
        if (this.getViewer() instanceof TreeViewer) {
            ret = (TreeViewer)this.getViewer();
        }
        return ret;
    }

    public Tree getTree() {
        return this.getTreeViewer().getTree();
    }

    public void refresh() {
        this.getTreeViewer().refresh();
    }

    public void test() {
    }

    public IViewerContext getCurrentViewerContext() {
        TreeViewerContext ret = new TreeViewerContext(this);
        return ret;
    }

    public boolean isExpandSingleChildAutomatically() {
        return this.expandSingleChildAutomatically;
    }

    public void setExpandSingleChildAutomatically(boolean expand) {
        this.expandSingleChildAutomatically = expand;
    }

    protected void setViewer(StructuredViewer viewer) {
        super.setViewer(viewer);
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().addTreeListener((ITreeViewerListener)new SingleChildOpener());
        }
    }

    private class SingleChildOpener
    implements ITreeViewerListener {
        private SingleChildOpener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object element;
            if (SapAbstractTreeViewer.this.isExpandSingleChildAutomatically() && (element = event.getElement()) != null) {
                Object node = element;
                TreeViewer treeViewer = SapAbstractTreeViewer.this.getTreeViewer();
                IContentProvider contentProvider = treeViewer.getContentProvider();
                int level = 0;
                if (contentProvider instanceof ITreeContentProvider) {
                    ITreeContentProvider treeContentProvider = (ITreeContentProvider)contentProvider;
                    boolean cont = true;
                    do {
                        Object[] children;
                        if ((children = treeContentProvider.getChildren(node)) != null && children.length == 1) {
                            node = children[0];
                            ++level;
                            continue;
                        }
                        cont = false;
                    } while (cont);
                }
                if (level > 0) {
                    treeViewer.expandToLevel(element, level);
                }
            }
        }
    }
}

