/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.table.column;

import com.tssap.util.ui.viewer.table.column.TextColumnHandler;
import javax.swing.table.TableModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

class ComboBoxColumnHandler
extends TextColumnHandler {
    private String[] comboItems;

    protected ComboBoxColumnHandler(TableModel pTableModel, int pColNum, String[] pComboBoxItems) {
        super(pTableModel, pColNum);
        this.comboItems = pComboBoxItems;
    }

    public CellEditor getCellEditor(Composite pParent) {
        return new ComboBoxCellEditor(pParent, this.getComboItems());
    }

    public String getText(int pRow) {
        Integer value = (Integer)this.getValue(pRow);
        return this.getComboItems()[value];
    }

    public Object getValue(int pRow) {
        Object value = super.getValue(pRow);
        Integer retValue = new Integer(0);
        String[] comboItems = this.getComboItems();
        int c = 0;
        while (c < comboItems.length) {
            if (value.toString().equals(comboItems[c])) {
                retValue = new Integer(c);
            }
            ++c;
        }
        return retValue;
    }

    public void modify(int pRow, Object pNewValue) {
        int comboPos = (Integer)pNewValue;
        super.modify(pRow, this.getComboItems()[comboPos]);
    }

    public String[] getComboItems() {
        return this.comboItems;
    }

    public void setComboItems(String[] pComboItems) {
        this.comboItems = pComboItems;
    }
}

