/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.table.column;

import com.tssap.util.ui.viewer.table.column.IColumnHandler;
import javax.swing.table.TableModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

abstract class AbstractColumnHandler
implements IColumnHandler {
    private TableModel tableModel;
    private int columnNumber;

    protected AbstractColumnHandler(TableModel pTableModel, int pColNum) {
        this.tableModel = pTableModel;
        this.columnNumber = pColNum;
    }

    public boolean canModify(int pRow) {
        boolean canModifyFlag = this.getTableModel().isCellEditable(pRow, this.getColumnNumber());
        return canModifyFlag;
    }

    public void modify(int pRow, Object pNewValue) {
        if (pNewValue != null) {
            this.getTableModel().setValueAt(pNewValue, pRow, this.getColumnNumber());
        }
    }

    public Object getValue(int pRow) {
        Object value = this.getTableModel().getValueAt(pRow, this.getColumnNumber());
        return value;
    }

    public Image getImage(int pRow) {
        return null;
    }

    public String getText(int pRow) {
        Object value = this.getValue(pRow);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public abstract CellEditor getCellEditor(Composite var1);

    protected TableModel getTableModel() {
        return this.tableModel;
    }

    protected int getColumnNumber() {
        return this.columnNumber;
    }
}

