/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.table;

import com.tssap.util.ui.viewer.IViewerContext;
import com.tssap.util.ui.viewer.SapViewer;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableLabelProvider;
import com.tssap.util.ui.viewer.table.SapTableModelAdaptor;
import com.tssap.util.ui.viewer.table.SapTableRow;
import com.tssap.util.ui.viewer.table.TableViewerContext;
import com.tssap.util.ui.viewer.table.column.ColumnHandlerFactory;
import com.tssap.util.ui.viewer.table.column.IColumnHandler;
import javax.swing.table.TableModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SapTableViewer
extends SapViewer
implements ISapTableViewer {
    protected final int DEFAULT_COL_WIDTH = 80;
    private SapTableModelAdaptor sapTableModelAdaptor;
    private TableModel swingTableModel;

    SapTableViewer(Composite pParent, TableModel pTableModel) {
        this(pParent, pTableModel, false);
    }

    SapTableViewer(Composite pParent, TableModel pTableModel, boolean pSingleSelection) {
        FillLayout compoLayout = new FillLayout();
        compoLayout.type = 512;
        pParent.setLayout((Layout)compoLayout);
        int style = 68352;
        style = pSingleSelection ? (style |= 4) : (style |= 2);
        Table table = new Table(pParent, style);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewer newTabViewer = new TableViewer(table);
        this.setViewer((StructuredViewer)newTabViewer);
        int colNum = pTableModel.getColumnCount();
        String[] colProperties = new String[colNum];
        int c = 0;
        while (c < colNum) {
            colProperties[c] = Integer.toString(c);
            TableColumn swtTableColumn = new TableColumn(table, 0, c);
            swtTableColumn.setText(pTableModel.getColumnName(c));
            int colWidth = 80;
            swtTableColumn.setWidth(colWidth);
            ++c;
        }
        newTabViewer.setColumnProperties(colProperties);
        this.setLabelProvider(new SapTableLabelProvider());
        newTabViewer.setContentProvider((IContentProvider)new InnerTableContentProvider());
        newTabViewer.setCellModifier((ICellModifier)new InnerTableCellModifier());
        this.setTableModel(pTableModel);
    }

    public static ISapTableViewer createTableViewer(Composite pParent, TableModel pTableModel) {
        return SapTableViewer.createTableViewer(pParent, pTableModel, false);
    }

    public static ISapTableViewer createTableViewer(Composite pParent, TableModel pTableModel, boolean pSingleSelection) {
        SapTableViewer ret = new SapTableViewer(pParent, pTableModel, pSingleSelection);
        return ret;
    }

    public void setLabelProvider(SapTableLabelProvider pNewLabelProvider) {
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)pNewLabelProvider);
    }

    public Table getTable() {
        return this.getTableViewer().getTable();
    }

    public TableViewer getTableViewer() {
        TableViewer ret = null;
        if (this.getViewer() instanceof TableViewer) {
            ret = (TableViewer)this.getViewer();
        }
        return ret;
    }

    protected SapTableModelAdaptor getSapTableModelAdaptor() {
        return this.sapTableModelAdaptor;
    }

    protected void setSapTableModelAdaptor(SapTableModelAdaptor sapTableModelAdaptor) {
        this.sapTableModelAdaptor = sapTableModelAdaptor;
    }

    public void setBooleanColumnHandler(int pColNum) {
        this.setColumnHandler(pColNum, ColumnHandlerFactory.createBooleanColumnHandler(this.getSapTableModelAdaptor().getTableModel(), pColNum));
    }

    public void setNumerikColumnHandler(int pColNum) {
        this.setColumnHandler(pColNum, ColumnHandlerFactory.createNumerikColumnHandler(this.getSapTableModelAdaptor().getTableModel(), pColNum));
    }

    public void setComboBoxColumnHandler(int pColNum, String[] pComboItems) {
        this.setColumnHandler(pColNum, ColumnHandlerFactory.createComboBoxColumnHandler(this.getSapTableModelAdaptor().getTableModel(), pColNum, pComboItems));
    }

    public void setColumnHandler(int pColNum, IColumnHandler pColHandler) {
        this.getSapTableModelAdaptor().setColumnHandler(pColNum, pColHandler);
        this.setCellEditors();
    }

    public void setTableModel(TableModel pNewTableModel) {
        int c;
        this.swingTableModel = pNewTableModel;
        TableViewer tabViewer = (TableViewer)this.getViewer();
        this.setSapTableModelAdaptor(new SapTableModelAdaptor(pNewTableModel, tabViewer));
        int newColNum = pNewTableModel.getColumnCount();
        int currentColNum = ((TableViewer)this.getViewer()).getTable().getColumnCount();
        if (newColNum > currentColNum) {
            c = currentColNum;
            while (c < newColNum) {
                new TableColumn(((TableViewer)this.getViewer()).getTable(), 0, c);
                ++c;
            }
        }
        if (newColNum < currentColNum) {
            c = newColNum;
            while (c <= currentColNum) {
                TableColumn currentCol = ((TableViewer)this.getViewer()).getTable().getColumn(c);
                currentCol.setText("");
                currentCol.setWidth(0);
                ++c;
            }
        }
        String[] colProperties = new String[newColNum];
        int c2 = 0;
        while (c2 < newColNum) {
            colProperties[c2] = Integer.toString(c2);
            TableColumn swtTableColumn = ((TableViewer)this.getViewer()).getTable().getColumn(c2);
            swtTableColumn.setText(pNewTableModel.getColumnName(c2));
            swtTableColumn.setWidth(80);
            ++c2;
        }
        tabViewer.setColumnProperties(colProperties);
        this.setCellEditors();
    }

    public TableModel getTableModel() {
        return this.swingTableModel;
    }

    private void setCellEditors() {
        int colNum = this.getSapTableModelAdaptor().getTableModel().getColumnCount();
        Table parentTable = ((TableViewer)this.getViewer()).getTable();
        CellEditor[] colEditors = new CellEditor[colNum];
        int c = 0;
        while (c < colNum) {
            colEditors[c] = this.getSapTableModelAdaptor().getColumnHandler(c).getCellEditor((Composite)parentTable);
            ++c;
        }
        ((TableViewer)this.getViewer()).setCellEditors(colEditors);
        ((TableViewer)this.getViewer()).setInput((Object)this.getSapTableModelAdaptor());
    }

    public IViewerContext getCurrentViewerContext() {
        TableViewerContext ret = new TableViewerContext(this);
        return ret;
    }

    private class InnerTableContentProvider
    implements IStructuredContentProvider {
        private InnerTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) throws IllegalArgumentException {
            if (inputElement instanceof SapTableModelAdaptor) {
                SapTableModelAdaptor tableModelAdaptor = (SapTableModelAdaptor)inputElement;
                return tableModelAdaptor.getTableRows();
            }
            throw new IllegalArgumentException("SapTableModelAdaptor as input element expected !");
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class InnerTableCellModifier
    implements ICellModifier {
        private InnerTableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            SapTableRow tableRow = this.getTableRow(element);
            SapTableModelAdaptor tableModelAdaptor = tableRow.getSapTableModel();
            int tableRowNum = tableRow.getRowNum();
            boolean canModifyFlag = tableModelAdaptor.getColumnHandler(property).canModify(tableRowNum);
            return canModifyFlag;
        }

        public Object getValue(Object element, String property) {
            SapTableRow tableRow = this.getTableRow(element);
            SapTableModelAdaptor tableModelAdaptor = tableRow.getSapTableModel();
            int tableRowNum = tableRow.getRowNum();
            Object retValue = tableModelAdaptor.getColumnHandler(property).getValue(tableRowNum);
            return retValue;
        }

        public void modify(Object element, String property, Object value) {
            SapTableRow tableRow = this.getTableRow(element);
            SapTableModelAdaptor tableModelAdaptor = tableRow.getSapTableModel();
            int tableRowNum = tableRow.getRowNum();
            tableModelAdaptor.getColumnHandler(property).modify(tableRowNum, value);
            SapTableViewer.super.getViewer().update((Object)tableRow, new String[]{property});
        }

        private SapTableRow getTableRow(Object element) {
            if (element instanceof SapTableRow) {
                SapTableRow row = (SapTableRow)element;
                return row;
            }
            if (element instanceof TableItem) {
                TableItem item = (TableItem)element;
                return (SapTableRow)item.getData();
            }
            return null;
        }
    }
}

