/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.viewer.table;

import com.tssap.util.ui.viewer.table.SapTableRow;
import com.tssap.util.ui.viewer.table.column.ColumnHandlerFactory;
import com.tssap.util.ui.viewer.table.column.IColumnHandler;
import java.util.Hashtable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.eclipse.jface.viewers.TableViewer;

public class SapTableModelAdaptor {
    private TableModel tableModel;
    private TableViewer tableViewer;
    private SapTableRow[] tableRows = new SapTableRow[0];
    private Hashtable colHandlerStringDict = new Hashtable();
    private Hashtable colHandlerIntDict = new Hashtable();
    private IColumnHandler[] colHandlers;

    public SapTableModelAdaptor(TableModel pTableModel, TableViewer pTableViewer) {
        this.tableViewer = pTableViewer;
        this.tableModel = pTableModel;
        if (this.tableModel != null) {
            this.tableRows = this.computeRows4Model(pTableModel);
            this.tableModel.addTableModelListener(new InnerTableModelListener());
            int colNum = this.tableModel.getColumnCount();
            this.colHandlers = new IColumnHandler[colNum];
        }
    }

    public void setColumnHandler(int pColNum, IColumnHandler pColHandler) {
        this.colHandlers[pColNum] = pColHandler;
    }

    public IColumnHandler getColumnHandler(int pColNum) {
        IColumnHandler retColHandler = this.colHandlers[pColNum];
        if (retColHandler == null) {
            this.colHandlers[pColNum] = retColHandler = ColumnHandlerFactory.createDefaultColumnHandler(this.tableModel, pColNum);
        }
        return retColHandler;
    }

    public IColumnHandler getColumnHandler(Integer pColNumAsInt) {
        int colNum;
        IColumnHandler retColHandler = (IColumnHandler)this.colHandlerIntDict.get(pColNumAsInt);
        if (retColHandler == null && (retColHandler = this.getColumnHandler(colNum = pColNumAsInt.intValue())) != null) {
            this.colHandlerIntDict.put(pColNumAsInt, retColHandler);
        }
        return retColHandler;
    }

    public IColumnHandler getColumnHandler(String pColNumAsString) {
        IColumnHandler retColHandler = (IColumnHandler)this.colHandlerStringDict.get(pColNumAsString);
        if (retColHandler == null) {
            try {
                int colNum = Integer.parseInt(pColNumAsString);
                retColHandler = this.getColumnHandler(colNum);
                if (retColHandler != null) {
                    this.colHandlerStringDict.put(pColNumAsString, retColHandler);
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        return retColHandler;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public SapTableRow[] getTableRows() {
        return this.tableRows;
    }

    public SapTableRow getTableRows(int pRowNum) {
        if (pRowNum < this.tableRows.length) {
            return this.tableRows[pRowNum];
        }
        return null;
    }

    protected void setTableRows(SapTableRow[] tableRows) {
        this.tableRows = tableRows;
    }

    protected SapTableRow[] computeRows4Model(TableModel tableModel) {
        int rowNum = tableModel.getRowCount();
        SapTableRow[] tableRows = new SapTableRow[rowNum];
        int row = 0;
        while (row < rowNum) {
            tableRows[row] = new SapTableRow(this, row);
            ++row;
        }
        return tableRows;
    }

    private class InnerTableModelListener
    implements TableModelListener {
        private InnerTableModelListener() {
        }

        public void tableChanged(TableModelEvent tabEvt) {
            int firstRow = tabEvt.getFirstRow();
            int lastRow = tabEvt.getLastRow();
            int currentRowNum = SapTableModelAdaptor.this.tableRows.length;
            SapTableRow[] currentTableRows = SapTableModelAdaptor.this.getTableRows();
            switch (tabEvt.getType()) {
                case 1: {
                    SapTableRow[] newTableRows = new SapTableRow[currentRowNum + (lastRow - firstRow + 1)];
                    SapTableRow[] additionalTableRows = new SapTableRow[lastRow - firstRow + 1];
                    int rNew = newTableRows.length;
                    int rCurrent = currentTableRows.length;
                    while (--rNew >= 0) {
                        SapTableRow newRow;
                        if (rNew > lastRow || rNew < firstRow) {
                            SapTableRow currentRow = currentTableRows[--rCurrent];
                            currentRow.setRowNum(rNew);
                            newTableRows[rNew] = currentRow;
                            continue;
                        }
                        additionalTableRows[rNew - firstRow] = newRow = new SapTableRow(SapTableModelAdaptor.this, rNew);
                        newTableRows[rNew] = newRow;
                    }
                    int maxIndex = SapTableModelAdaptor.this.getTableRows().length;
                    int r = 0;
                    while (r < additionalTableRows.length) {
                        SapTableRow additionalRow = additionalTableRows[r];
                        int newIndex = additionalRow.getRowNum();
                        if (newIndex < maxIndex) {
                            SapTableModelAdaptor.this.getTableViewer().insert((Object)additionalRow, newIndex);
                            ++maxIndex;
                        } else {
                            SapTableModelAdaptor.this.getTableViewer().add((Object)additionalRow);
                        }
                        ++r;
                    }
                    SapTableModelAdaptor.this.setTableRows(newTableRows);
                    break;
                }
                case -1: {
                    SapTableRow[] newTableRows = new SapTableRow[currentRowNum - (lastRow - firstRow + 1)];
                    Object[] removalTableRows = new SapTableRow[lastRow - firstRow + 1];
                    int rNew = newTableRows.length;
                    int rCurrent = currentTableRows.length;
                    while (--rCurrent >= 0) {
                        SapTableRow currentRow = currentTableRows[rCurrent];
                        if (rCurrent > lastRow || rCurrent < firstRow) {
                            currentRow.setRowNum(--rNew);
                            newTableRows[rNew] = currentRow;
                            continue;
                        }
                        removalTableRows[rCurrent - firstRow] = currentRow;
                    }
                    SapTableModelAdaptor.this.getTableViewer().remove(removalTableRows);
                    SapTableModelAdaptor.this.setTableRows(newTableRows);
                    break;
                }
                case 0: {
                    if (lastRow > currentTableRows.length) {
                        if (SapTableModelAdaptor.this.getTableModel().getRowCount() != currentTableRows.length) {
                            SapTableRow[] newTableRows = SapTableModelAdaptor.this.computeRows4Model(SapTableModelAdaptor.this.getTableModel());
                            SapTableModelAdaptor.this.setTableRows(newTableRows);
                        }
                        SapTableModelAdaptor.this.getTableViewer().refresh();
                        break;
                    }
                    Object[] updateRows = new SapTableRow[lastRow - firstRow + 1];
                    int rCurrent = currentTableRows.length;
                    int rNew = updateRows.length;
                    while (--rCurrent >= 0) {
                        if (rCurrent > lastRow || rCurrent < firstRow) continue;
                        updateRows[--rNew] = currentTableRows[rCurrent];
                    }
                    SapTableModelAdaptor.this.getTableViewer().update(updateRows, null);
                    break;
                }
            }
        }
    }
}

