/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.tree;

import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.ITreeSelectorCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;

public class TreeSelectorEditorComponent {
    private TreeSelector mySelector;
    private boolean isEditorDirty;
    private IModifiedCallback myModifiedCallback;
    private IAddRemoveCallback myAddRemoveCallback;
    private boolean refreshAfterSelectionChange = true;

    public TreeSelectorEditorComponent(TreeSelector selector) {
        this.mySelector = selector;
        this.mySelector.setTreeSelectorCallback(new MyCallback());
    }

    public void init() {
    }

    public void setTreeLabelProvider(ILabelProvider labelProvider) {
        this.mySelector.setTreeLabelProvider(labelProvider);
    }

    public void setTreeContentProvider(ITreeContentProvider contentProvider) {
        this.mySelector.setTreeContentProvider(contentProvider);
    }

    public void setTreeInput(Object obj) {
        this.mySelector.setTreeInput(obj);
        this.refreshCurrentEditor();
    }

    public void setReusableManager(IReuseableManager reusableManager) {
        this.mySelector.setReusableManager(reusableManager);
    }

    public void setViewerSorter(ViewerSorter sorter) {
        this.mySelector.setViewerSorter(sorter);
    }

    public void setEditable(boolean editable) {
        this.mySelector.setEditable(editable);
    }

    public boolean isEditable() {
        return this.mySelector.isEditable();
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifiedCallback = callback;
    }

    public void setAddRemoveCallback(IAddRemoveCallback callback) {
        this.myAddRemoveCallback = callback;
    }

    public ISelectionConverter getSelectionConverter() {
        return this.mySelector.getSelectionConverter();
    }

    public void setSelectionConverter(ISelectionConverter selectionConverter) {
        this.mySelector.setSelectionConverter(selectionConverter);
    }

    public void setSelection(Object objToSelect) {
        this.mySelector.setSelection(objToSelect);
    }

    public TreeSelector getTreeSelector() {
        return this.mySelector;
    }

    private IObjectEditorComponent getCurrentEditorComponent() {
        IObjectEditorComponent ret = null;
        IReuseable curReuseableComp = this.mySelector.getCurrentReusableComponent();
        if (curReuseableComp instanceof IObjectEditorComponent) {
            ret = (IObjectEditorComponent)curReuseableComp;
        }
        return ret;
    }

    public void refreshTree() {
        this.refreshTree(false);
    }

    public void refreshTree(boolean refreshLabels) {
        this.mySelector.refreshTree(refreshLabels);
        this.refreshCurrentEditor();
        IObjectEditorComponent currentEditor = this.getCurrentEditorComponent();
        if (currentEditor != null) {
            this.mySelector.setMessageText(currentEditor.okToLeave());
        }
    }

    private IAddRemoveCallback getAddRemoveCallback() {
        if (this.myAddRemoveCallback == null) {
            this.myAddRemoveCallback = new SimpleAddRemoveCallback();
        }
        return this.myAddRemoveCallback;
    }

    private void refreshCurrentEditor() {
        IObjectEditorComponent currentEditor = this.getCurrentEditorComponent();
        if (currentEditor != null) {
            currentEditor.refreshUIFromData();
        }
    }

    public void aboutToLeave() {
        IObjectEditorComponent currentEditor = this.getCurrentEditorComponent();
        if (currentEditor != null) {
            currentEditor.refreshDataFromUI();
        }
    }

    public String okToLeave() {
        String ret = null;
        IReuseable currentReusable = this.mySelector.getCurrentReusableComponent();
        if (currentReusable instanceof IObjectEditorComponent) {
            ret = ((IObjectEditorComponent)currentReusable).okToLeave();
        }
        return ret;
    }

    public boolean isRefreshAfterSelectionChange() {
        return this.refreshAfterSelectionChange;
    }

    public void setRefreshAfterSelectionChange(boolean refreshAfterSelectionChange) {
        this.refreshAfterSelectionChange = refreshAfterSelectionChange;
    }

    class SimpleAddRemoveCallback
    implements IAddRemoveCallback {
        SimpleAddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            return null;
        }

        public boolean canAddElement(Object currentSelection) {
            return false;
        }

        public boolean canRemoveElement(Object currentSelection) {
            return false;
        }

        public boolean removeElement(Object currentSelection) {
            return false;
        }
    }

    private class MyCallback
    implements ITreeSelectorCallback,
    IModifiedCallback {
        private MyCallback() {
        }

        public void selectionAboutToChange(Object currentSelection, IReuseable currentUIComponent) {
            if (currentUIComponent instanceof IObjectEditorComponent) {
                IObjectEditorComponent currentEditor = (IObjectEditorComponent)currentUIComponent;
                currentEditor.refreshDataFromUI();
            }
        }

        public void selectionChanged(Object currentSelection, IReuseable currentUIComponent) {
            if (currentSelection != null && currentUIComponent instanceof IObjectEditorComponent) {
                IObjectEditorComponent currentEditor = (IObjectEditorComponent)currentUIComponent;
                currentEditor.setData(TreeSelectorEditorComponent.this.getSelectionConverter().convertSelection(currentSelection));
                currentEditor.refreshUIFromData();
                currentEditor.setModifiedCallback(this);
            }
            if (TreeSelectorEditorComponent.this.isRefreshAfterSelectionChange()) {
                TreeSelectorEditorComponent.this.refreshTree(true);
            }
        }

        public String okToChangeSelection(IReuseable currentUIComponent) {
            String ret = null;
            if (currentUIComponent instanceof IObjectEditorComponent) {
                IObjectEditorComponent currentEditor = (IObjectEditorComponent)currentUIComponent;
                ret = currentEditor.okToLeave();
            }
            return ret;
        }

        public Object addElement(Object currentSelection) {
            Object newElement = TreeSelectorEditorComponent.this.getAddRemoveCallback().addElement(currentSelection);
            if (newElement != null) {
                this.dataModified(true);
            }
            return newElement;
        }

        public boolean canAddElement(Object currentSelection) {
            return TreeSelectorEditorComponent.this.getAddRemoveCallback().canAddElement(currentSelection);
        }

        public boolean canRemoveElement(Object currentSelection) {
            return TreeSelectorEditorComponent.this.getAddRemoveCallback().canRemoveElement(currentSelection);
        }

        public boolean removeElement(Object currentSelection) {
            boolean removeSucceed = TreeSelectorEditorComponent.this.getAddRemoveCallback().removeElement(currentSelection);
            if (removeSucceed) {
                this.dataModified(true);
            }
            return removeSucceed;
        }

        public void dataModified(boolean modified) {
            TreeSelectorEditorComponent.this.isEditorDirty |= modified;
            if (TreeSelectorEditorComponent.this.myModifiedCallback != null) {
                TreeSelectorEditorComponent.this.myModifiedCallback.dataModified(TreeSelectorEditorComponent.this.isEditorDirty);
            }
            if (TreeSelectorEditorComponent.this.getTreeSelector() != null && TreeSelectorEditorComponent.this.getTreeSelector().getCurrentReusableComponent() instanceof IObjectEditorComponent) {
                TreeSelectorEditorComponent.this.mySelector.setMessageText(((IObjectEditorComponent)TreeSelectorEditorComponent.this.getTreeSelector().getCurrentReusableComponent()).okToLeave());
            }
        }
    }
}

