/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.tree;

import com.tssap.util.ui.IEditable;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IGenericComponent;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.ObjectEditorComponentUtil;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.ITreeSelector;
import com.tssap.util.ui.reuse.tree.ITreeSelectorCallback;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSelector
extends GenericComponent
implements ITreeSelector {
    private static final int SPLITTER_WEIGHTH_DEFAULT = 4;
    private static final String DEFAULT_TITLE = "";
    private static final int GRID_COL_NUM = 1;
    private static final boolean GRID_EQUAL_COLSIZE = false;
    private static final String ADD_BUT_TXT = "Add";
    private static final String REMOVE_BUT_TXT = "Remove";
    private static final int SEL_STATUS_NONE = 0;
    private static final int SEL_STATUS_REFRESH = 1;
    private static final int SEL_STATUS_FORCE = 2;
    private TreeViewer myTreeViewer;
    private ITreeContentProvider myContentProvider;
    private IReuseableManager myReuseabeManager;
    private ILabelProvider myLabelProvider;
    private ViewerSorter myViewerSorter;
    private ISelectionConverter mySelectionConverter;
    private Object treeInput;
    private ISashPane splitterPane;
    private IGridLayoutPane rightGridPane;
    private ISimplePane rightSidePane;
    private IReuseable currentReusableComponent;
    private TreeItem currentSelection;
    private Object currentData;
    private ITreeSelectorCallback myTreeSelectorCallback;
    private ISelectionChangedListener myTreeSelectioChangeListener;
    private Composite rightSideContainer;
    private Button button_add;
    private Button button_remove;
    private Label msgLable;
    private int splitterWeight = 4;
    private boolean hasAddRemoveButtons = true;
    private Object initialSelection;
    private int mySelectionStatus = 0;

    public TreeSelector() {
    }

    public TreeSelector(String title) {
        super(title);
    }

    public TreeSelector(boolean hasAddRemoveButtons) {
        this.hasAddRemoveButtons = hasAddRemoveButtons;
    }

    public TreeSelector(String title, boolean hasAddRemoveButtons) {
        super(title);
        this.hasAddRemoveButtons = hasAddRemoveButtons;
    }

    public void setSelection(Object objToSelect) {
        if (objToSelect == null) {
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().setSelection(null, false);
            }
            return;
        }
        this.initialSelection = objToSelect;
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().reveal(objToSelect);
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection(objToSelect), true);
        }
    }

    public void initContainer(IGridLayoutPane userArea) {
        this.splitterPane = userArea.addHorizontalSashPane(userArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane treeGlp = this.splitterPane.addGridLayoutPane(2);
        TreeViewer treeViewer = treeGlp.addTreeViewer(false, treeGlp.createGridLayoutData(4, 4, true, true, 2, 1));
        this.myTreeSelectioChangeListener = new MySelectionChangeListener();
        treeViewer.addSelectionChangedListener(this.myTreeSelectioChangeListener);
        treeViewer.setLabelProvider((IBaseLabelProvider)this.getTreeLabelProvider());
        treeViewer.setContentProvider((IContentProvider)this.getTreeContentProvider());
        if (this.getViewerSorter() != null) {
            treeViewer.setSorter(this.getViewerSorter());
        }
        this.setTreeViewer(treeViewer);
        if (this.hasAddRemoveButton()) {
            this.button_add = treeGlp.addPushButton(ADD_BUT_TXT);
            this.button_add.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TreeSelector.this.handleAddButtonPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    TreeSelector.this.handleAddButtonPressed();
                }
            });
            this.button_remove = treeGlp.addPushButton(REMOVE_BUT_TXT);
            this.button_remove.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TreeSelector.this.handleRemoveButtonPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    TreeSelector.this.handleRemoveButtonPressed();
                }
            });
            GridData gd = new GridData();
            gd.heightHint = -1;
            gd.widthHint = this.button_remove.computeSize((int)-1, (int)-1).x;
            this.button_add.setLayoutData((Object)gd);
        }
        this.rightGridPane = this.splitterPane.addGridLayoutPane(1);
        this.rightSidePane = this.rightGridPane.addSimplePane(this.rightGridPane.createGridLayoutData(4, 4, true, true));
        this.rightSideContainer = this.rightSidePane.getComposite();
        this.msgLable = this.rightGridPane.addTextLabel(DEFAULT_TITLE, this.rightGridPane.createGridLayoutData(4, 3, true, false));
        this.msgLable.setForeground(this.msgLable.getDisplay().getSystemColor(3));
        treeViewer.setInput(this.getTreeInput() != null ? this.getTreeInput() : DEFAULT_TITLE);
        treeViewer.getTree().setEnabled(this.isEnabled());
        this.splitterPane.setWeights(new int[]{1, this.splitterWeight});
        this.updateButtonState();
    }

    private boolean hasAddRemoveButton() {
        return this.hasAddRemoveButtons;
    }

    protected IReuseable getCurrentReusableComponent() {
        return this.currentReusableComponent;
    }

    private void handleRemoveButtonPressed() {
        if (this.currentSelection != null && !this.currentSelection.isDisposed() && MessageDialog.openConfirm(null, (String)"Please confirm", (String)"Delete the selected Element?")) {
            TreeItem[] newSelTreeItems;
            Object elementToDelete = this.getCurrentSelectionData();
            TreeItem[] currentSubElements = this.currentSelection.getParentItem() != null ? this.currentSelection.getParentItem().getItems() : this.currentSelection.getParent().getItems();
            TreeItem newSelection = null;
            int currentIndex = -1;
            int i = 0;
            while (i < currentSubElements.length && currentIndex == -1) {
                if (currentSubElements[i].equals(this.currentSelection)) {
                    currentIndex = i;
                }
                ++i;
            }
            if (currentIndex != -1) {
                newSelection = currentIndex + 1 < currentSubElements.length ? currentSubElements[++currentIndex] : (currentIndex - 1 >= 0 ? currentSubElements[--currentIndex] : this.currentSelection.getParentItem());
            }
            if (newSelection != null && !newSelection.isDisposed()) {
                newSelTreeItems = new TreeItem[]{newSelection};
                this.currentSelection = newSelection;
            } else {
                newSelTreeItems = new TreeItem[]{};
                this.currentSelection = null;
            }
            this.getTreeViewer().getTree().setSelection(newSelTreeItems);
            this.updateSelection(newSelTreeItems);
            this.getTreeSelectorCallback().removeElement(elementToDelete);
            this.refreshTree(true);
            this.updateSelection(this.getTreeViewer().getTree().getSelection());
        }
    }

    private void updateSelection(TreeItem[] newSelection) {
        this.setMessageText(DEFAULT_TITLE);
        if (newSelection != null && newSelection.length > 0) {
            this.currentSelection = newSelection[0];
            this.currentData = this.currentSelection.getData();
        } else {
            this.currentSelection = null;
            this.currentData = null;
        }
        this.currentReusableComponent = this.myReuseabeManager.getReusable(this.getCovertedCurrentSelectionData());
        if (this.rightSideContainer != null) {
            Control[] children = this.rightSideContainer.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        if (this.currentReusableComponent == null) {
            this.currentReusableComponent = new SimpleIReuseable();
        }
        if (this.currentReusableComponent instanceof IEditable) {
            IEditable editable = (IEditable)((Object)this.currentReusableComponent);
            editable.setEditable(this.isEditable());
        }
        this.currentReusableComponent.setEnabled(this.isEnabled());
        if (this.rightSideContainer != null) {
            Control newControl = null;
            if (this.currentReusableComponent instanceof IGenericComponent) {
                IGridLayoutPane glp = PaneFactory.createGridLayoutPane(this.rightSideContainer, 1, this.rightSidePane.getWidgetFactory());
                newControl = ((IGenericComponent)this.currentReusableComponent).createPartControl(glp);
            } else {
                newControl = this.currentReusableComponent.createPartControl(this.rightSideContainer);
            }
            Point containerSize = this.rightSideContainer.getSize();
            --containerSize.x;
            this.rightSideContainer.setSize(containerSize);
            ++containerSize.x;
            this.rightSideContainer.setSize(containerSize);
            newControl.setVisible(true);
        }
        this.handleSelectionChanged();
    }

    private void handleAddButtonPressed() {
        this.selectionAboutToChange();
        Object newElement = this.getTreeSelectorCallback().addElement(this.getCurrentSelectionData());
        this.refreshTree();
        if (newElement != null) {
            this.setSelection(newElement);
        }
    }

    public IReuseableManager getReusableManager() {
        if (this.myReuseabeManager == null) {
            this.myReuseabeManager = new SimpleReuseableManager();
        }
        return this.myReuseabeManager;
    }

    public void setReusableManager(IReuseableManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("IReuseableManager must not be null");
        }
        this.myReuseabeManager = manager;
    }

    public TreeViewer getTreeViewer() {
        return this.myTreeViewer;
    }

    protected void setTreeViewer(TreeViewer treeViewer) {
        this.myTreeViewer = treeViewer;
    }

    public ISelectionConverter getSelectionConverter() {
        if (this.mySelectionConverter == null) {
            this.mySelectionConverter = new SimpleSelectionConverter();
        }
        return this.mySelectionConverter;
    }

    public void setSelectionConverter(ISelectionConverter selectionConverter) {
        this.mySelectionConverter = selectionConverter;
    }

    public int getSplitterWeight() {
        return this.splitterWeight;
    }

    public void setSplitterWeight(int splitterWeight) {
        this.splitterWeight = splitterWeight;
        if (this.splitterPane != null) {
            this.splitterPane.setWeights(new int[]{1, splitterWeight});
        }
    }

    public ViewerSorter getViewerSorter() {
        return this.myViewerSorter;
    }

    public void setViewerSorter(ViewerSorter viewerSorter) {
        this.myViewerSorter = viewerSorter;
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSorter(viewerSorter);
        }
    }

    public Object getTreeInput() {
        return this.treeInput;
    }

    public void setTreeInput(Object treeInput) {
        this.treeInput = treeInput;
        if (this.getTreeViewer() != null) {
            this.setSelectionStatus(2);
            this.getTreeViewer().setInput(treeInput);
            this.setSelectionStatus(0);
            this.updateButtonState();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setEnabled(enabled);
        }
        if (this.getCurrentReusableComponent() != null) {
            this.getCurrentReusableComponent().setEnabled(enabled);
        }
    }

    public void refreshTree() {
        this.refreshTree(false);
    }

    public void refreshTree(boolean refreshLabels) {
        this.setSelectionStatus(1);
        this.getTreeViewer().refresh(refreshLabels);
        this.setSelectionStatus(0);
    }

    private Object getCurrentSelectionData() {
        Object ret = null;
        if (this.currentSelection != null) {
            if (this.currentSelection.isDisposed()) {
                TreeItem[] selItems = this.getTreeViewer().getTree().getSelection();
                if (selItems != null && selItems.length > 0) {
                    Object data = selItems[0].getData();
                    this.setSelection(data);
                } else {
                    this.setSelection(null);
                }
            }
            if (this.currentSelection != null && !this.currentSelection.isDisposed()) {
                ret = this.currentSelection.getData();
            }
        }
        return ret;
    }

    private Object getCovertedCurrentSelectionData() {
        return this.getSelectionConverter().convertSelection(this.getCurrentSelectionData());
    }

    private void handleSelectionChanged() {
        this.getTreeSelectorCallback().selectionChanged(this.getCurrentSelectionData(), this.currentReusableComponent);
        this.updateButtonState();
    }

    public void updateButtonState() {
        if (this.hasAddRemoveButtons) {
            if (this.isEnabled() && this.isEditable()) {
                if (this.button_add != null) {
                    this.button_add.setEnabled(this.getTreeSelectorCallback().canAddElement(this.getCurrentSelectionData()));
                }
                if (this.button_remove != null) {
                    this.button_remove.setEnabled(this.getTreeSelectorCallback().canRemoveElement(this.getCurrentSelectionData()));
                }
            } else {
                if (this.button_add != null) {
                    this.button_add.setEnabled(false);
                }
                if (this.button_remove != null) {
                    this.button_remove.setEnabled(false);
                }
            }
        }
    }

    private void selectionAboutToChange() {
        this.getTreeSelectorCallback().selectionAboutToChange(this.currentReusableComponent != null && this.currentSelection != null && !this.currentSelection.isDisposed() ? this.getCurrentSelectionData() : null, this.currentReusableComponent);
    }

    private String changeAllowed() {
        return this.getTreeSelectorCallback().okToChangeSelection(this.currentReusableComponent);
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public ITreeContentProvider getTreeContentProvider() {
        if (this.myContentProvider == null) {
            this.myContentProvider = new SimpleTreeContentProvider();
        }
        return this.myContentProvider;
    }

    public ILabelProvider getTreeLabelProvider() {
        if (this.myLabelProvider == null) {
            this.myLabelProvider = new LabelProvider();
        }
        return this.myLabelProvider;
    }

    public void setTreeContentProvider(ITreeContentProvider myContentProvider) {
        this.myContentProvider = myContentProvider;
        if (this.myTreeViewer != null) {
            this.myTreeViewer.setContentProvider((IContentProvider)this.getTreeContentProvider());
        }
    }

    public void setTreeLabelProvider(ILabelProvider myLabelProvider) {
        this.myLabelProvider = myLabelProvider;
        if (this.myTreeViewer != null) {
            this.myTreeViewer.setLabelProvider((IBaseLabelProvider)this.getTreeLabelProvider());
        }
    }

    public void setTreeSelectorCallback(ITreeSelectorCallback callback) {
        this.myTreeSelectorCallback = callback;
    }

    public void setMessageText(String text) {
        this.msgLable.setText(text != null ? ObjectEditorComponentUtil.removeMsgPrefix(text) : DEFAULT_TITLE);
        this.setMessageColor(text);
    }

    private void setMessageColor(String text) {
        if (text != null) {
            int msgIndex = ObjectEditorComponentUtil.getMsgPrefixIndex(text);
            if (msgIndex == 0) {
                this.msgLable.setForeground(this.msgLable.getDisplay().getSystemColor(2));
            } else if (msgIndex == 1) {
                this.msgLable.setForeground(this.msgLable.getDisplay().getSystemColor(8));
            } else {
                this.msgLable.setForeground(this.msgLable.getDisplay().getSystemColor(3));
            }
        }
    }

    private boolean isChangeAllowed(String changeAllowedComment) {
        boolean ret = true;
        if (changeAllowedComment != null && ObjectEditorComponentUtil.getMsgPrefixIndex(changeAllowedComment) >= 2) {
            ret = false;
        }
        return ret;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getCurrentReusableComponent() instanceof IEditable) {
            IEditable editable = (IEditable)((Object)this.getCurrentReusableComponent());
            editable.setEditable(this.isEditable());
        }
        if (this.getTreeViewer() != null && this.getTreeViewer().getTree() != null) {
            Color background = this.isEditable() ? SWTUtil.getEditableViewerBackground() : SWTUtil.getReadOnlyViewerBackground();
            this.getTreeViewer().getTree().setBackground(background);
        }
        this.updateButtonState();
    }

    private ITreeSelectorCallback getTreeSelectorCallback() {
        if (this.myTreeSelectorCallback == null) {
            this.myTreeSelectorCallback = new EmptyCallback();
        }
        return this.myTreeSelectorCallback;
    }

    private int getSelectionStatus() {
        return this.mySelectionStatus;
    }

    private void setSelectionStatus(int status) {
        this.mySelectionStatus = status;
    }

    class SimpleSelectionConverter
    implements ISelectionConverter {
        SimpleSelectionConverter() {
        }

        public Object convertSelection(Object selectedObject) {
            return selectedObject;
        }
    }

    class EmptyCallback
    implements ITreeSelectorCallback {
        EmptyCallback() {
        }

        public void selectionAboutToChange(Object currentSelection, IReuseable currentUIComponent) {
        }

        public void selectionChanged(Object currentSelection, IReuseable currentUIComponent) {
        }

        public String okToChangeSelection(IReuseable currentUIComponent) {
            return null;
        }

        public Object addElement(Object currentSelection) {
            return null;
        }

        public boolean canAddElement(Object currentSelection) {
            return false;
        }

        public boolean canRemoveElement(Object currentSelection) {
            return false;
        }

        public boolean removeElement(Object currentSelection) {
            return false;
        }
    }

    class SimpleTreeContentProvider
    implements ITreeContentProvider {
        SimpleTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class SimpleIReuseable
    implements IReuseable {
        SimpleIReuseable() {
        }

        public Control createPartControl(Composite parent) {
            return parent;
        }

        public Control createPartControl(IGridLayoutPane glp) {
            return glp.getComposite();
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean enabled) {
        }
    }

    class SimpleReuseableManager
    implements IReuseableManager {
        SimpleReuseableManager() {
        }

        public IReuseable getReusable(Object obj) {
            return new SimpleIReuseable();
        }
    }

    class MySelectionChangeListener
    implements ISelectionChangedListener {
        MySelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean selectionRevertable;
            TreeItem[] selection = TreeSelector.this.myTreeViewer.getTree().getSelection();
            String changeAllowedComment = TreeSelector.this.changeAllowed();
            boolean bl = selectionRevertable = TreeSelector.this.currentSelection != null && !TreeSelector.this.currentSelection.isDisposed();
            if (selectionRevertable) {
                Object data = TreeSelector.this.currentSelection.getData();
                if (data != null) {
                    selectionRevertable = data.equals(TreeSelector.this.currentData);
                } else {
                    boolean bl2 = selectionRevertable = TreeSelector.this.currentData == null;
                }
            }
            if (TreeSelector.this.getSelectionStatus() == 0) {
                if (TreeSelector.this.isChangeAllowed(changeAllowedComment) || !selectionRevertable) {
                    TreeSelector.this.selectionAboutToChange();
                    TreeSelector.this.updateSelection(selection);
                } else {
                    TreeSelector.this.myTreeViewer.getTree().setSelection(new TreeItem[]{TreeSelector.this.currentSelection});
                    TreeSelector.this.setMessageText(changeAllowedComment);
                }
            } else if (TreeSelector.this.getSelectionStatus() == 2) {
                TreeSelector.this.updateSelection(selection);
            } else if (TreeSelector.this.getSelectionStatus() == 1) {
                if (TreeSelector.this.isChangeAllowed(changeAllowedComment) || !selectionRevertable) {
                    TreeSelector.this.selectionAboutToChange();
                    TreeSelector.this.updateSelection(selection);
                } else {
                    TreeSelector.this.myTreeViewer.getTree().setSelection(new TreeItem[]{TreeSelector.this.currentSelection});
                    TreeSelector.this.setMessageText(changeAllowedComment);
                }
            }
        }
    }
}

