/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.tree;

import com.tssap.util.core.IFilter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class LogicalCheckedTreeViewer {
    public static final int LEAVE_FILTER = 1;
    public static final int LOGIC_NONE = 0;
    public static final int LOGIC_TYPE1 = 1;
    public static final int LOGIC_TYPE2 = 2;
    public static final int LOGIC_TYPE3 = 3;
    public static final int LOGIC_TYPE4 = 4;
    public static final int LOGIC_TYPE5 = 5;
    private CheckboxTreeViewer checkboxTreeViewer;
    private ITreeContentProvider treeContentProvider;
    private ArrayList checkedElements;
    private ArrayList grayedElements;
    private int myExpandLevel;
    private InnerBaseCheckStateListener checkStateListener;
    private IFilter resultFilter;

    public LogicalCheckedTreeViewer(CheckboxTreeViewer checkboxTreeViewer) {
        if (checkboxTreeViewer == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.checkboxTreeViewer = checkboxTreeViewer;
    }

    public IFilter getResultFilter() {
        return this.resultFilter;
    }

    public void setResultFilter(IFilter filter) {
        this.resultFilter = filter;
    }

    public void setResultFilterType(int filterType) {
        switch (filterType) {
            case 1: {
                this.setResultFilter(new LeaveFilter());
                break;
            }
        }
    }

    private ITreeContentProvider getContentProvider() {
        return this.treeContentProvider;
    }

    public CheckboxTreeViewer getCheckboxTreeViewer() {
        return this.checkboxTreeViewer;
    }

    private InnerBaseCheckStateListener getCheckStateListener() {
        return this.checkStateListener;
    }

    public Object[] getFilteredSelection() {
        ArrayList checkedEl = this.getStoredChecked();
        if (this.getResultFilter() == null) {
            return checkedEl.toArray(new Object[checkedEl.size()]);
        }
        ArrayList arL = new ArrayList(checkedEl.size());
        Iterator iter = ((AbstractList)checkedEl).iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!this.getResultFilter().accept(element)) continue;
            arL.add(element);
        }
        return arL.toArray(new Object[arL.size()]);
    }

    public void clearSelection() {
        ArrayList checked = this.getStoredChecked();
        Iterator iter = checked.iterator();
        while (iter.hasNext()) {
            this.checkboxTreeViewer.setChecked(iter.next(), false);
        }
        checked.clear();
        ArrayList grayed = this.getStoredGrayed();
        Iterator iter2 = grayed.iterator();
        while (iter2.hasNext()) {
            this.checkboxTreeViewer.setGrayed(iter2.next(), false);
        }
        grayed.clear();
    }

    private ArrayList getStoredChecked() {
        if (this.checkedElements == null) {
            this.checkedElements = new ArrayList();
        }
        return this.checkedElements;
    }

    private ArrayList getStoredGrayed() {
        if (this.grayedElements == null) {
            this.grayedElements = new ArrayList();
        }
        return this.grayedElements;
    }

    public void preCheckElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.checkboxTreeViewer.setChecked(elements[i], true);
            if (this.getCheckStateListener() != null) {
                this.getCheckStateListener().checkElement(elements[i], true);
            }
            ++i;
        }
    }

    public void preGrayedElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.checkboxTreeViewer.setGrayed(elements[i], true);
            this.setCheckedState(elements, false, true);
            ++i;
        }
    }

    public void refreshTreeViewer() {
        if (this.checkboxTreeViewer != null) {
            this.checkboxTreeViewer.refresh();
        }
    }

    private void setCheckedState(Object element, boolean checkedState, boolean grayedState) {
        if (checkedState) {
            if (!this.getStoredChecked().contains(element)) {
                this.getStoredChecked().add(element);
            }
        } else {
            ((AbstractCollection)this.getStoredChecked()).remove(element);
        }
        if (grayedState) {
            if (!this.getStoredGrayed().contains(element)) {
                this.getStoredGrayed().add(element);
            }
        } else {
            ((AbstractCollection)this.getStoredGrayed()).remove(element);
        }
    }

    private void setCheckStateListener(InnerBaseCheckStateListener listener) {
        if (this.getCheckStateListener() != null) {
            this.checkboxTreeViewer.removeCheckStateListener((ICheckStateListener)this.getCheckStateListener());
        }
        this.checkStateListener = listener;
        this.checkboxTreeViewer.addCheckStateListener((ICheckStateListener)listener);
    }

    public void setContentProvider(ITreeContentProvider lProvider) {
        this.treeContentProvider = lProvider;
        if (this.checkboxTreeViewer != null) {
            this.checkboxTreeViewer.setContentProvider((IContentProvider)lProvider);
            this.refreshTreeViewer();
        }
    }

    public void setLabelProvider(ILabelProvider lProvider) {
        if (this.checkboxTreeViewer != null) {
            this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)lProvider);
        }
    }

    public void setTreeInput(Object treeInput) {
        if (this.checkboxTreeViewer != null) {
            this.checkboxTreeViewer.setInput(treeInput);
        }
    }

    public void setSelectionLogicType(int type) {
        InnerBaseCheckStateListener checkListener = null;
        switch (type) {
            case 0: {
                checkListener = new InnerEmptyCheckStateListener(this.checkboxTreeViewer);
                break;
            }
            case 1: {
                checkListener = new InnerType1CheckStateListener(this.checkboxTreeViewer);
                break;
            }
            case 2: {
                checkListener = new InnerType2CheckStateListener(this.checkboxTreeViewer);
                break;
            }
            case 3: {
                checkListener = new InnerType3CheckStateListener(this.checkboxTreeViewer);
                break;
            }
            case 4: {
                checkListener = new InnerType4CheckStateListener(this.checkboxTreeViewer);
                break;
            }
            case 5: {
                checkListener = new InnerType5CheckStateListener(this.checkboxTreeViewer);
                break;
            }
        }
        this.setCheckStateListener(checkListener);
    }

    public void toggleElement(Object element) {
        this.toggleElements(new Object[]{element});
    }

    public void toggleElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            boolean newState = this.checkboxTreeViewer.getChecked(elements[i]) ^ true;
            this.checkboxTreeViewer.setChecked(elements[i], newState);
            if (this.getCheckStateListener() != null) {
                this.getCheckStateListener().checkElement(elements[i], newState);
            }
            ++i;
        }
    }

    public void expandToLevel(int level) {
        this.myExpandLevel = level;
        if (this.checkboxTreeViewer != null) {
            this.checkboxTreeViewer.expandToLevel(level);
        }
    }

    public class LeaveFilter
    implements IFilter {
        public boolean accept(Object o) {
            return !LogicalCheckedTreeViewer.this.getContentProvider().hasChildren(o);
        }
    }

    class InnerType5CheckStateListener
    extends InnerBaseCheckStateListener {
        public InnerType5CheckStateListener(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        protected void checkElement(Object element, boolean state) {
            Object checkedElement = element;
            boolean checkState = state;
            boolean checkedIsGrayed = this.getTreeViewer().getGrayed(checkedElement);
            if (checkedIsGrayed) {
                this.getTreeViewer().setChecked(checkedElement, checkState ^ true);
            } else {
                Object[] checkedElements = this.getTreeViewer().getCheckedElements();
                int i = 0;
                while (i < checkedElements.length) {
                    if (!this.getTreeViewer().getGrayed(checkedElements[i])) {
                        LogicalCheckedTreeViewer.this.setCheckedState(checkedElements[i], false, false);
                        this.getTreeViewer().setChecked(checkedElements[i], false);
                    }
                    ++i;
                }
                LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkState, false);
                this.getTreeViewer().setChecked(checkedElement, true);
            }
        }
    }

    class InnerType4CheckStateListener
    extends InnerBaseCheckStateListener {
        public InnerType4CheckStateListener(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        protected void checkElement(Object element, boolean state) {
            Object checkedElement = element;
            boolean checkState = state;
            boolean checkedIsGrayed = this.getTreeViewer().getGrayed(checkedElement);
            if (checkedIsGrayed) {
                this.getTreeViewer().setChecked(checkedElement, checkState ^ true);
            } else {
                LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkState, false);
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, checkedElement, checkState){
                    private final /* synthetic */ Object val$checkedElement;
                    private final /* synthetic */ boolean val$checkState;
                    private final /* synthetic */ InnerType4CheckStateListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$checkedElement = val$checkedElement;
                        this.val$checkState = val$checkState;
                    }

                    public void run() {
                        InnerType4CheckStateListener.access$400(this.this$1, this.val$checkedElement, this.val$checkState);
                    }
                });
            }
        }

        private void uncheckSiblings(Object checkedElement, boolean checkState) {
            boolean grayed = false;
            this.getTreeViewer().setGrayed(checkedElement, grayed);
            LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkState, grayed);
            if (checkState) {
                Object[] sibs = this.getSiblings((TreeViewer)this.getTreeViewer(), checkedElement);
                int i = 0;
                while (i < sibs.length) {
                    if (!sibs[i].equals(checkedElement) && !LogicalCheckedTreeViewer.this.checkboxTreeViewer.getGrayed(sibs[i])) {
                        this.getTreeViewer().setChecked(sibs[i], false);
                        this.getTreeViewer().setGrayed(sibs[i], grayed);
                        LogicalCheckedTreeViewer.this.setCheckedState(sibs[i], checkState, grayed);
                    }
                    ++i;
                }
            }
        }

        static /* synthetic */ void access$400(InnerType4CheckStateListener x0, Object x1, boolean x2) {
            x0.uncheckSiblings(x1, x2);
        }
    }

    class InnerType3CheckStateListener
    extends InnerBaseCheckStateListener {
        public InnerType3CheckStateListener(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        protected void checkElement(Object element, boolean state) {
            Object checkedElement = element;
            boolean checkState = state;
            boolean checkedIsGrayed = this.getTreeViewer().getGrayed(checkedElement);
            if (checkedIsGrayed) {
                this.getTreeViewer().setChecked(checkedElement, checkState ^ true);
            } else {
                LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkState, false);
            }
        }
    }

    class InnerType2CheckStateListener
    extends InnerBaseCheckStateListener {
        public InnerType2CheckStateListener(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        protected void checkElement(Object element, boolean state) {
            Object checkedElement = element;
            boolean checkState = state;
            boolean checkedIsGrayed = this.getTreeViewer().getGrayed(checkedElement);
            if (checkedIsGrayed) {
                this.getTreeViewer().setChecked(checkedElement, checkState ^ true);
            } else {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, checkedElement, checkState){
                    private final /* synthetic */ Object val$checkedElement;
                    private final /* synthetic */ boolean val$checkState;
                    private final /* synthetic */ InnerType2CheckStateListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$checkedElement = val$checkedElement;
                        this.val$checkState = val$checkState;
                    }

                    public void run() {
                        InnerType2CheckStateListener.access$300(this.this$1, this.val$checkedElement, this.val$checkState);
                    }
                });
            }
        }

        private void checkElementsDownward(Object checkedElement, boolean checkState) {
            this.getTreeViewer().setGrayed(checkedElement, false);
            LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkState, false);
            Object[] children = this.getAllChildren(checkedElement);
            int i = 0;
            while (i < children.length) {
                this.getTreeViewer().setChecked(children[i], checkState);
                this.getTreeViewer().setGrayed(children[i], checkState);
                LogicalCheckedTreeViewer.this.setCheckedState(children[i], checkState, checkState);
                ++i;
            }
        }

        static /* synthetic */ void access$300(InnerType2CheckStateListener x0, Object x1, boolean x2) {
            x0.checkElementsDownward(x1, x2);
        }
    }

    class InnerType1CheckStateListener
    extends InnerBaseCheckStateListener {
        public InnerType1CheckStateListener(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        protected void checkElement(Object element, boolean state) {
            Object checkedElement = element;
            boolean checkState = state;
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, checkedElement, checkState){
                private final /* synthetic */ Object val$checkedElement;
                private final /* synthetic */ boolean val$checkState;
                private final /* synthetic */ InnerType1CheckStateListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$checkedElement = val$checkedElement;
                    this.val$checkState = val$checkState;
                }

                public void run() {
                    InnerType1CheckStateListener.access$100(this.this$1, this.val$checkedElement, this.val$checkState);
                    InnerType1CheckStateListener.access$200(this.this$1, this.val$checkedElement, this.val$checkState);
                }
            });
        }

        private void checkElementsDownward(Object checkedElement, boolean checkState) {
            boolean grayed = false;
            this.getTreeViewer().setGrayed(checkedElement, grayed);
            LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkState, grayed);
            Object[] children = this.getAllChildren(checkedElement);
            int i = 0;
            while (i < children.length) {
                this.getTreeViewer().setChecked(children[i], checkState);
                this.getTreeViewer().setGrayed(children[i], grayed);
                LogicalCheckedTreeViewer.this.setCheckedState(children[i], checkState, grayed);
                ++i;
            }
        }

        private void checkElementsUpward(Object element, boolean newCheckState) {
            Object[] siblings = this.getSiblings((TreeViewer)this.getTreeViewer(), element);
            int checkedNum = this.countChecked(siblings);
            int grayedNum = this.countGrayed(siblings);
            Object parent = this.getParent((TreeViewer)this.getTreeViewer(), element);
            if (parent != null) {
                if (grayedNum == 0) {
                    if (checkedNum == 0) {
                        this.getTreeViewer().setGrayed(parent, false);
                        this.getTreeViewer().setChecked(parent, false);
                        LogicalCheckedTreeViewer.this.setCheckedState(parent, false, false);
                        this.checkElementsUpward(parent, false);
                    } else if (checkedNum == siblings.length) {
                        this.getTreeViewer().setGrayed(parent, false);
                        this.getTreeViewer().setChecked(parent, true);
                        LogicalCheckedTreeViewer.this.setCheckedState(parent, true, false);
                        this.checkElementsUpward(parent, true);
                    } else if (checkedNum == 1 | checkedNum == siblings.length - 1) {
                        this.getTreeViewer().setGrayed(parent, true);
                        this.getTreeViewer().setChecked(parent, true);
                        LogicalCheckedTreeViewer.this.setCheckedState(parent, true, true);
                        this.checkElementsUpward(parent, true);
                    }
                } else {
                    this.getTreeViewer().setGrayed(parent, true);
                    this.getTreeViewer().setChecked(parent, true);
                    LogicalCheckedTreeViewer.this.setCheckedState(parent, true, true);
                    this.checkElementsUpward(parent, true);
                }
            }
        }

        static /* synthetic */ void access$100(InnerType1CheckStateListener x0, Object x1, boolean x2) {
            x0.checkElementsDownward(x1, x2);
        }

        static /* synthetic */ void access$200(InnerType1CheckStateListener x0, Object x1, boolean x2) {
            x0.checkElementsUpward(x1, x2);
        }
    }

    class InnerEmptyCheckStateListener
    extends InnerBaseCheckStateListener {
        public InnerEmptyCheckStateListener(CheckboxTreeViewer viewer) {
            super(viewer);
        }

        protected void checkElement(Object element, boolean state) {
            Object checkedElement = element;
            boolean checkState = state;
            boolean checkedIsGrayed = this.getTreeViewer().getGrayed(checkedElement);
            LogicalCheckedTreeViewer.this.setCheckedState(checkedElement, checkState, checkedIsGrayed);
        }
    }

    abstract class InnerBaseCheckStateListener
    implements ICheckStateListener {
        protected final Object[] EMPTY_OBJ_AR = new Object[0];
        private CheckboxTreeViewer myTreeViewer;

        public InnerBaseCheckStateListener(CheckboxTreeViewer viewer) {
            this.myTreeViewer = viewer;
        }

        private void addChilds(ITreeContentProvider tcp, Object element, ArrayList arL) {
            Object[] ch = tcp.getChildren(element);
            arL.addAll(Arrays.asList(ch));
            int i = 0;
            while (i < ch.length) {
                this.addChilds(tcp, ch[i], arL);
                ++i;
            }
        }

        protected abstract void checkElement(Object var1, boolean var2);

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.checkElement(event.getElement(), event.getChecked());
        }

        protected int countChecked(Object[] elements) {
            int ret = 0;
            int i = 0;
            while (i < elements.length) {
                if (this.getTreeViewer().getChecked(elements[i])) {
                    ++ret;
                }
                ++i;
            }
            return ret;
        }

        protected int countGrayed(Object[] elements) {
            int ret = 0;
            int i = 0;
            while (i < elements.length) {
                if (this.getTreeViewer().getGrayed(elements[i])) {
                    ++ret;
                }
                ++i;
            }
            return ret;
        }

        protected Object[] getAllChildren(Object element) {
            ArrayList arL = new ArrayList();
            this.addChilds((ITreeContentProvider)this.getTreeViewer().getContentProvider(), element, arL);
            return arL.toArray(new Object[arL.size()]);
        }

        protected Object getParent(TreeViewer treeViewer, Object element) {
            return this.getTreeContentProvider(treeViewer).getParent(element);
        }

        protected Object[] getSiblings(TreeViewer tv, Object element) {
            Object parent = this.getTreeContentProvider(tv).getParent(element);
            return parent != null ? this.getTreeContentProvider(tv).getChildren(parent) : this.EMPTY_OBJ_AR;
        }

        private ITreeContentProvider getTreeContentProvider(TreeViewer treeViewer) {
            return (ITreeContentProvider)treeViewer.getContentProvider();
        }

        protected CheckboxTreeViewer getTreeViewer() {
            return this.myTreeViewer;
        }
    }
}

