/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.table;

import com.tssap.util.ui.reuse.table.ITableColumn;

public class TableUtil {
    public static ITableColumn[] getMappedColumns(ITableColumn[] unmappedColumns) {
        ITableColumn[] mappedColumns = new ITableColumn[unmappedColumns.length];
        int tc = 0;
        while (tc < unmappedColumns.length) {
            ITableColumn iTableColumn = unmappedColumns[tc];
            if (mappedColumns[iTableColumn.getColumnNumber()] != null) {
                throw new RuntimeException("Wrong table column numbering !");
            }
            mappedColumns[iTableColumn.getColumnNumber()] = iTableColumn;
            ++tc;
        }
        return mappedColumns;
    }

    public static String[] getMappedColumnLabels(ITableColumn[] unmappedColumns) {
        String[] columnLabels = new String[unmappedColumns.length];
        ITableColumn[] mappedColumns = TableUtil.getMappedColumns(unmappedColumns);
        int i = 0;
        while (i < mappedColumns.length) {
            columnLabels[i] = mappedColumns[i].getColumnLabel();
            ++i;
        }
        return columnLabels;
    }

    public static int[] getMappedColumnWidths(ITableColumn[] unmappedColumns) {
        int[] columnWidths = new int[unmappedColumns.length];
        ITableColumn[] mappedColumns = TableUtil.getMappedColumns(unmappedColumns);
        int i = 0;
        while (i < mappedColumns.length) {
            columnWidths[i] = mappedColumns[i].getColumnWidth();
            ++i;
        }
        return columnWidths;
    }

    public static boolean[] getMappedReadOnlyFlags(ITableColumn[] unmappedColumns) {
        boolean[] columnReadOnlyFlags = new boolean[unmappedColumns.length];
        ITableColumn[] mappedColumns = TableUtil.getMappedColumns(unmappedColumns);
        int i = 0;
        while (i < mappedColumns.length) {
            columnReadOnlyFlags[i] = mappedColumns[i].isReadOnly();
            ++i;
        }
        return columnReadOnlyFlags;
    }

    public static boolean[] getMappedReadMandatoryFlags(ITableColumn[] unmappedColumns) {
        boolean[] columnMandatoryFlags = new boolean[unmappedColumns.length];
        ITableColumn[] mappedColumns = TableUtil.getMappedColumns(unmappedColumns);
        int i = 0;
        while (i < mappedColumns.length) {
            columnMandatoryFlags[i] = mappedColumns[i].isMandatory();
            ++i;
        }
        return columnMandatoryFlags;
    }
}

