/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.table;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericMultiTableComponent;
import com.tssap.util.ui.reuse.table.IMutableTable;
import com.tssap.util.ui.reuse.table.ITableAdapter;
import com.tssap.util.ui.reuse.table.ITableColumn;
import com.tssap.util.ui.reuse.table.ITableComponent;
import com.tssap.util.ui.reuse.table.ITableModifyListener;
import com.tssap.util.ui.reuse.table.ITableRow;
import com.tssap.util.ui.reuse.table.TableUtil;
import com.tssap.util.ui.reuse.table.impl.TableContentProvider;
import com.tssap.util.ui.reuse.table.impl.TableLabelProvider;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableItem;

public class TableComponent
extends GenericMultiTableComponent
implements IMutableTable,
ITableComponent {
    private static final int NUM_OF_COLS = 2;
    private static final boolean EQUAL_SIZE_FLAG = false;
    private ITableAdapter tableAdapter;
    private int sortColumn = -1;
    private boolean multiSelection = true;
    private Boolean[] readOnlyColumns = new Boolean[0];
    private Hashtable tableRows = new Hashtable();
    private Vector tableModifyListener = new Vector();
    private ITableRow[] selectedTableRows = new ITableRow[0];

    public TableComponent(ITableAdapter adapter) {
        this.setTableAdapter(adapter);
    }

    private void intClear() {
        Enumeration tabRowEnum = this.getTableRows().elements();
        while (tabRowEnum.hasMoreElements()) {
            ITableRow tableRow = (ITableRow)tabRowEnum.nextElement();
            this.getTableViewer().remove((Object)tableRow);
        }
        this.getTableRows().clear();
    }

    private void intAddRows(ITableRow[] rows) {
        int r = 0;
        while (r < rows.length) {
            ITableRow oldTableEntry = this.getTableRows().put(rows[r].getKey(), rows[r]);
            if (oldTableEntry != null) {
                this.getTableViewer().update((Object)rows[r], null);
            } else {
                this.getTableViewer().add((Object)rows[r]);
            }
            ++r;
        }
        this.setSelectedTableRows(rows);
    }

    private void intRemoveRows(ITableRow[] rows) {
        int r = 0;
        while (r < rows.length) {
            ITableRow oldRow = (ITableRow)this.getTableRows().remove(rows[r].getKey());
            if (oldRow != null) {
                this.getTableViewer().remove((Object)oldRow);
            }
            ++r;
        }
    }

    public void addRow(ITableRow row) {
        ITableRow[] additionalRows = new ITableRow[]{row};
        this.addRows(additionalRows);
    }

    public void addRows(ITableRow[] rows) {
        TableViewer tabViewer = this.getTableViewer();
        if (tabViewer != null) {
            this.intAddRows(rows);
            Enumeration listenerEnum = this.getTableModifyListener().elements();
            while (listenerEnum.hasMoreElements()) {
                ITableModifyListener tabModListener = (ITableModifyListener)listenerEnum.nextElement();
                tabModListener.rowsAdded(rows);
            }
        }
    }

    public void removeRow(ITableRow row) {
        ITableRow[] removalRows = new ITableRow[]{row};
        this.removeRows(removalRows);
    }

    public void removeRows(ITableRow[] rows) {
        TableViewer tabViewer = this.getTableViewer();
        if (tabViewer != null) {
            this.intRemoveRows(rows);
            Enumeration listenerEnum = this.getTableModifyListener().elements();
            while (listenerEnum.hasMoreElements()) {
                ITableModifyListener tabModListener = (ITableModifyListener)listenerEnum.nextElement();
                tabModListener.rowsRemoved(rows);
            }
        }
    }

    public void clearTable() {
        TableViewer tabViewer = this.getTableViewer();
        if (tabViewer != null) {
            this.intClear();
            Enumeration listenerEnum = this.getTableModifyListener().elements();
            while (listenerEnum.hasMoreElements()) {
                ITableModifyListener tabModListener = (ITableModifyListener)listenerEnum.nextElement();
                tabModListener.tableCleared();
            }
        }
    }

    public void changeRow(ITableRow row, int colNum, String value) {
        ITableRow tableRow = (ITableRow)this.getTableRows().get(row.getKey());
        if (tableRow != null) {
            tableRow.getValues()[colNum] = value;
            TableViewer tabViewer = this.getTableViewer();
            if (tabViewer != null) {
                tabViewer.update((Object)tableRow, null);
                Enumeration listenerEnum = this.getTableModifyListener().elements();
                while (listenerEnum.hasMoreElements()) {
                    ITableModifyListener tabModListener = (ITableModifyListener)listenerEnum.nextElement();
                    tabModListener.rowChanged(row, colNum, value);
                }
            }
        }
    }

    public void initializeTable(ITableRow[] rows) {
        TableViewer tabViewer = this.getTableViewer();
        if (tabViewer != null) {
            this.intClear();
            this.intAddRows(rows);
            Enumeration listenerEnum = this.getTableModifyListener().elements();
            while (listenerEnum.hasMoreElements()) {
                ITableModifyListener tabModListener = (ITableModifyListener)listenerEnum.nextElement();
                tabModListener.tableInitialized(rows);
            }
        }
    }

    public boolean addTableModifyListener(ITableModifyListener modListener) {
        return this.getTableModifyListener().add(modListener);
    }

    public boolean removeTableModifyListener(ITableModifyListener modListener) {
        return this.getTableModifyListener().remove(modListener);
    }

    private void createTableViewer(IGridLayoutPane userArea, int xSpan, int ySpan) {
        String[] colLabels = TableUtil.getMappedColumnLabels(this.getColumns());
        int[] colWidths = TableUtil.getMappedColumnWidths(this.getColumns());
        TableViewer tabViewer = userArea.addTableViewer(this.isMultiSelection(), colLabels, colWidths, userArea.createGridLayoutData(4, 4, true, true, xSpan, ySpan));
        tabViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        tabViewer.setContentProvider((IContentProvider)new TableContentProvider());
        tabViewer.setColumnProperties(colLabels);
        tabViewer.addSelectionChangedListener((ISelectionChangedListener)new InnerTableSelectionListener());
        tabViewer.setCellModifier((ICellModifier)new InnerTabelCellModifier());
        tabViewer.setInput((Object)this.getTableRows());
        this.setTableViewer(tabViewer);
    }

    public void initContainer(IGridLayoutPane userArea) {
        SelectionAdapter addButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITableRow[] additionalRows = TableComponent.this.getTableAdapter().getNewRows();
                TableComponent.this.addRows(additionalRows);
            }
        };
        SelectionAdapter removeButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITableRow[] removeableRows = TableComponent.this.getSelectedTableRows();
                TableComponent.this.removeRows(removeableRows);
            }
        };
        switch (this.getButtonOrientation()) {
            case 128: {
                IGridLayoutPane buttonPane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(1, 1, false, false));
                this.createAddButton(buttonPane, (SelectionListener)addButtonListener);
                this.createRemoveButton(buttonPane, (SelectionListener)removeButtonListener);
                this.createTableViewer(userArea, 2, 1);
                break;
            }
            case 131072: {
                IGridLayoutPane buttonPane = userArea.addGridLayoutPane(1, true, userArea.createGridLayoutData(1, 1, false, false, 1, 2));
                this.createTableViewer(userArea, 1, 2);
                this.createAddButton(buttonPane, (SelectionListener)addButtonListener);
                this.createRemoveButton(buttonPane, (SelectionListener)removeButtonListener);
                break;
            }
            case 16384: {
                IGridLayoutPane buttonPane = userArea.addGridLayoutPane(1, true, userArea.createGridLayoutData(1, 1, false, false, 1, 2));
                this.createTableViewer(userArea, 1, 2);
                this.createAddButton(buttonPane, (SelectionListener)addButtonListener);
                this.createRemoveButton(buttonPane, (SelectionListener)removeButtonListener);
                break;
            }
            case 1024: {
                this.createTableViewer(userArea, 2, 1);
                IGridLayoutPane buttonPane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(1, 1, false, false));
                this.createAddButton(buttonPane, (SelectionListener)addButtonListener);
                this.createRemoveButton(buttonPane, (SelectionListener)removeButtonListener);
            }
        }
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    protected Hashtable getTableRows() {
        return this.tableRows;
    }

    protected Vector getTableModifyListener() {
        return this.tableModifyListener;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("Multiple selection");
        }
        this.multiSelection = multiSelection;
    }

    public ITableColumn[] getColumns() {
        return this.getTableAdapter().getColumns();
    }

    public ITableRow[] getSelectedTableRows() {
        return this.selectedTableRows;
    }

    private void setSelectedTableRows(ITableRow[] selectedTableRows) {
        this.selectedTableRows = selectedTableRows;
    }

    public ITableAdapter getTableAdapter() {
        return this.tableAdapter;
    }

    public void refreshFromAdapter() {
        this.initializeTable(this.getTableAdapter().getInitialRows());
    }

    public void setTableAdapter(ITableAdapter adapter) {
        this.getTableModifyListener().remove(this.tableAdapter);
        this.getTableModifyListener().add(adapter);
        this.tableAdapter = adapter;
    }

    private class InnerTabelCellModifier
    implements ICellModifier {
        private InnerTabelCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            boolean[] readOnlyColumns = TableUtil.getMappedReadOnlyFlags(TableComponent.this.getColumns());
            int colNum = this.getColumnNumber(property);
            return colNum < 0 || readOnlyColumns.length <= colNum || !readOnlyColumns[colNum];
        }

        public Object getValue(Object element, String property) {
            int colNum = this.getColumnNumber(property);
            if (element instanceof ITableRow) {
                ITableRow tabRow = (ITableRow)element;
                return tabRow.getValues()[colNum];
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            int colNum = this.getColumnNumber(property);
            ITableRow tableRow = null;
            if (element instanceof TableItem) {
                TableItem tabItem = (TableItem)element;
                tableRow = (ITableRow)tabItem.getData();
            } else if (element instanceof ITableRow) {
                tableRow = (ITableRow)element;
            }
            if (tableRow != null) {
                String newValue = value.toString();
                TableComponent.this.changeRow(tableRow, colNum, newValue);
            }
        }

        private int getColumnNumber(String property) {
            int colNum = -1;
            String[] properties = TableUtil.getMappedColumnLabels(TableComponent.this.getColumns());
            int col = 0;
            while (col < properties.length) {
                if (property.equals(properties[col])) {
                    colNum = col;
                    col = properties.length;
                }
                ++col;
            }
            return colNum;
        }
    }

    private class InnerTableSelectionListener
    implements ISelectionChangedListener {
        private InnerTableSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                TableComponent.super.setRemoveEnabled(sel.size() > 0);
                ITableRow[] tableRows = new ITableRow[sel.size()];
                Iterator keyIter = sel.iterator();
                int count = 0;
                while (keyIter.hasNext()) {
                    tableRows[count++] = (ITableRow)keyIter.next();
                }
                TableComponent.this.setSelectedTableRows(tableRows);
                Enumeration listenerEnum = TableComponent.this.getTableModifyListener().elements();
                while (listenerEnum.hasMoreElements()) {
                    ITableModifyListener tabModListener = (ITableModifyListener)listenerEnum.nextElement();
                    tabModListener.selectionChanged(tableRows);
                }
            }
        }
    }
}

