/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.table;

import com.tssap.util.ui.reuse.table.ITableAdapter;
import com.tssap.util.ui.reuse.table.ITableColumn;
import com.tssap.util.ui.reuse.table.ITableRow;
import com.tssap.util.ui.reuse.table.TableUtil;

public abstract class AbstractTableAdapter
implements ITableAdapter {
    public static final String DEFAULT_NAME = "<..>";
    public static final String DEFAULT_VALUE = "<..>";
    public static final String DEFAULT_DESCRIPTION = "";
    public static final int NAME_COL_NUMBER = 0;
    public static final int VALUE_COL_NUMBER = 1;
    public static final int DESCRIPTION_COL_NUMBER = 2;
    public static final String NAME_COL_LABEL = "Name";
    public static final String VALUE_COL_LABEL = "Value";
    public static final String DESCRIPTION_COL_LABEL = "Description";

    public abstract ITableColumn[] getColumns();

    public final String[] getColumnLabels() {
        return TableUtil.getMappedColumnLabels(this.getColumns());
    }

    public final int[] getColumnWidths() {
        return TableUtil.getMappedColumnWidths(this.getColumns());
    }

    public final void rowChanged(ITableRow row, int colNum, String newValue) {
        try {
            ITableColumn column = TableUtil.getMappedColumns(this.getColumns())[colNum];
            this.updateModel(row, column, newValue);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("column number out of range !");
        }
    }

    public final ITableRow[] getInitialRows() {
        ITableRow[] initialRows = this.retrieveFromModel();
        return initialRows;
    }

    public final ITableRow[] getNewRows() {
        ITableRow[] newTableRows = this.createNewRows();
        return newTableRows;
    }

    public final void rowsAdded(ITableRow[] rows) {
        int i = 0;
        while (i < rows.length) {
            ITableRow iTableRow = rows[i];
            if (iTableRow.getUserObject() == null) {
                Object newObject = this.createInModel(iTableRow);
                iTableRow.setUserObject(newObject);
            }
            ++i;
        }
    }

    public final void rowsRemoved(ITableRow[] rows) {
        int i = 0;
        while (i < rows.length) {
            this.removeFromModel(rows[i]);
            ++i;
        }
    }

    public void selectionChanged(ITableRow[] selectedRows) {
    }

    public void tableCleared() {
    }

    public void tableInitialized(ITableRow[] rows) {
    }

    protected abstract ITableRow[] createNewRows();

    protected abstract Object createInModel(ITableRow var1);

    protected abstract ITableRow[] retrieveFromModel();

    protected abstract void removeFromModel(ITableRow var1);

    protected abstract void updateModel(ITableRow var1, ITableColumn var2, String var3);
}

