/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.radio;

import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.chooser.IDropDownSelector;
import com.tssap.util.ui.reuse.chooser.IRadioChooser;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.radio.IRadioButtonComponent;
import com.tssap.util.ui.reuse.radio.RadioButtonComponentEventData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Button;

public class RadioButtonComponent
extends GenericComponent
implements IRadioButtonComponent {
    private static final boolean DEFAULT_SELECTOR_HAS_PUSH_BUTTON = true;
    private boolean initialCompact = false;
    private int initialSelectionIndex = 0;
    private IRadioChooser[] initialRadioChoosers;
    private Button[] radioButtons;
    private IDropDownSelector[] dropDownSelectors;
    private String[] selectorTextEntries;
    private boolean selectorHasPushButton;

    public RadioButtonComponent(String title, IRadioChooser[] radioChoosers, boolean compact, int selectionIndex) {
        super(title);
        this.setRadioChoosers(radioChoosers);
        this.setCompact(compact);
        this.setSelectionIndex(selectionIndex);
    }

    public RadioButtonComponent(String title, IRadioChooser[] radioChoosers, boolean compact) {
        this(title, radioChoosers, compact, 0);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IRadioChooser[] radios = this.getRadioChoosers();
        this.setRadioButtons(new Button[radios.length]);
        this.setDropDownSelectors(new DropDownSelector[radios.length]);
        int i = 0;
        while (i < radios.length) {
            IRadioChooser radio = radios[i];
            IGridLayoutData buttonLD = userArea.createGridLayoutData();
            if (!this.isCompact()) {
                buttonLD = userArea.createGridLayoutData(1, 1, this.getUserGridNumOfColumns(), 1);
            }
            Button button = userArea.addRadioButton(radio.getRadioLabel(), buttonLD);
            button.setSelection(i == this.getSelectionIndex());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(i));
            this.setRadioButton(button, i);
            DropDownSelector dropDownSelector = new DropDownSelector(0);
            dropDownSelector.setSelectorDescription("");
            dropDownSelector.setDescriptionPositionLeft(true);
            if (this.getSelectorTextEntries() != null && this.getSelectorTextEntries()[i] != null) {
                dropDownSelector.setText(this.getSelectorTextEntries()[i]);
            }
            dropDownSelector.setButtonText(radio.getButtonText());
            dropDownSelector.setButtonImage(radio.getButtonImage());
            dropDownSelector.setHasPushButton(this.isSelectorHasPushButton());
            dropDownSelector.setPushButtonChooser(radio);
            dropDownSelector.addModifyListener(new ModifyAdapter(i));
            this.setDropDownSelector(dropDownSelector, i);
            dropDownSelector.setEditable(i == this.getSelectionIndex());
            dropDownSelector.createPartControl(userArea);
            ++i;
        }
        this.getRadioButton(this.getSelectionIndex()).setSelection(true);
    }

    public void refresh() {
        IRadioChooser[] radios = this.getRadioChoosers();
        this.setRadioChoosers(radios);
        int i = 0;
        while (i < radios.length) {
            IRadioChooser radio = radios[i];
            Button button = this.getRadioButton(i);
            button.setSelection(i == this.getSelectionIndex());
            this.setRadioButton(button, i);
            button.setText(radio.getRadioLabel());
            IDropDownSelector dropDownSelector = this.getDropDownSelector(i);
            dropDownSelector.setEditable(i == this.getSelectionIndex() && this.isEditable());
            if (dropDownSelector.getText() == null && radio.getTextEntry() != null) {
                dropDownSelector.setText(radio.getTextEntry());
            }
            this.setDropDownSelector(dropDownSelector, i);
            ++i;
        }
        this.getRadioButton(this.getSelectionIndex()).setSelection(true);
    }

    public boolean isCompact() {
        return this.isInitialCompact();
    }

    public void setCompact(boolean compact) {
        if (this.isComposable()) {
            this.setInitialCompact(compact);
        } else {
            this.throwFeatureNotModifyableException("compact");
        }
    }

    public void setRadioChooser(IRadioChooser radioChooser, int index) {
        this.setInitialRadioChooser(radioChooser, index);
    }

    private void setInitialRadioChooser(IRadioChooser radioChooser, int index) {
        if (this.getDropDownSelector(index) != null) {
            this.getRadioChoosers()[index] = radioChooser;
            this.getDropDownSelector(index).setText(radioChooser.getTextEntry());
            this.getDropDownSelector(index).setHistory(new String[0]);
            this.getDropDownSelector(index).setItemsMaxLength(0);
        }
    }

    public IRadioChooser getRadioChooser(int index) {
        IRadioChooser ret = this.getRadioChoosers()[index];
        return ret;
    }

    public void setRadioChoosers(IRadioChooser[] radioChoosers) {
        block5: {
            block3: {
                block4: {
                    if (this.getInitialRadioChoosers() == null) break block3;
                    int rChooserLength = 0;
                    rChooserLength = this.getInitialRadioChoosers().length;
                    this.setInitialRadioChoosers(radioChoosers);
                    if (radioChoosers.length != rChooserLength) break block4;
                    if (this.isComposable()) break block5;
                    int i = 0;
                    while (i < radioChoosers.length) {
                        this.setRadioChooser(radioChoosers[i], i);
                        ++i;
                    }
                    break block5;
                }
                this.throwFeatureNotModifyableException("initialRadioChoosers");
                break block5;
            }
            this.setInitialRadioChoosers(radioChoosers);
            if (!this.isComposable()) {
                int i = 0;
                while (i < radioChoosers.length) {
                    this.setRadioChooser(radioChoosers[i], i);
                    ++i;
                }
            }
        }
    }

    public IRadioChooser[] getRadioChoosers() {
        return this.getInitialRadioChoosers();
    }

    public int getSelectionIndex() {
        int ret = this.getInitialSelectionIndex();
        int i = 0;
        while (i < this.getRadioButtons().length) {
            Button button = this.getRadioButton(i);
            if (button != null && button.getSelection()) {
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public void setSelectionIndex(int selectionIndex) {
        this.setInitialSelectionIndex(selectionIndex);
        if (this.getRadioButton(selectionIndex) != null) {
            this.getRadioButton(selectionIndex).setSelection(true);
        }
    }

    public void setDeselectionIndex(int deselectionIndex) {
        if (this.getRadioButton(deselectionIndex) != null) {
            this.getRadioButton(deselectionIndex).setSelection(false);
        }
    }

    private Button[] getRadioButtons() {
        return this.radioButtons;
    }

    private Button getRadioButton(int index) {
        Button ret = null;
        if (this.getRadioButtons() != null) {
            ret = this.getRadioButtons()[index];
        }
        return ret;
    }

    private void setRadioButton(Button button, int index) {
        this.getRadioButtons()[index] = button;
    }

    private void setRadioButtons(Button[] radioButtons) {
        this.radioButtons = radioButtons;
    }

    public int getUserGridNumOfColumns() {
        int ddsNumOfColumns = new DropDownSelector().getUserGridNumOfColumns();
        int ret = this.isCompact() ? ddsNumOfColumns + 1 : ddsNumOfColumns;
        return ret;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private IDropDownSelector[] getDropDownSelectors() {
        return this.dropDownSelectors;
    }

    private IDropDownSelector getDropDownSelector(int index) {
        return this.getDropDownSelectors()[index];
    }

    private void setDropDownSelectors(IDropDownSelector[] dropDownSelectors) {
        this.dropDownSelectors = dropDownSelectors;
    }

    private void setDropDownSelector(IDropDownSelector dropDownSelector, int index) {
        this.getDropDownSelectors()[index] = dropDownSelector;
    }

    private boolean isInitialCompact() {
        return this.initialCompact;
    }

    private int getInitialSelectionIndex() {
        return this.initialSelectionIndex;
    }

    private void setInitialCompact(boolean initialCompact) {
        this.initialCompact = initialCompact;
    }

    private void setInitialSelectionIndex(int initialSelectionIndex) {
        this.initialSelectionIndex = initialSelectionIndex;
    }

    private TypedEvent improveEvent(TypedEvent e, int index) {
        TypedEvent ret = e;
        e.data = new RadioButtonComponentEventData(index, this.getRadioChooser(index));
        return ret;
    }

    private String[] getSelectorTextEntries() {
        return this.selectorTextEntries;
    }

    private void setSelectorTextEntries(String[] selectorTextEntries) {
        this.selectorTextEntries = selectorTextEntries;
    }

    public IRadioChooser[] getInitialRadioChoosers() {
        return this.initialRadioChoosers;
    }

    public void setInitialRadioChoosers(IRadioChooser[] initialRadioChoosers) {
        this.initialRadioChoosers = initialRadioChoosers;
    }

    public void setEnabled(boolean enabled) {
        int i;
        super.setEnabled(enabled);
        if (this.getRadioButtons() != null) {
            i = 0;
            while (i < this.getRadioButtons().length) {
                Button radioButton = this.getRadioButtons()[i];
                radioButton.setEnabled(enabled);
                ++i;
            }
        }
        if (this.getDropDownSelectors() != null) {
            i = 0;
            while (i < this.getDropDownSelectors().length) {
                IDropDownSelector ddSelector = this.getDropDownSelectors()[i];
                if (!enabled || i == this.getSelectionIndex()) {
                    ddSelector.setEnabled(enabled);
                }
                ++i;
            }
        }
    }

    private boolean isSelectorHasPushButton() {
        return this.selectorHasPushButton;
    }

    public void setSelectorHasPushButton(boolean selectorHasPushButton) {
        this.setInitialSelectorHasPushButton(selectorHasPushButton);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("selectorHasPushButton");
        }
    }

    public void setInitialSelectorHasPushButton(boolean selectorHasPushButton) {
        this.selectorHasPushButton = selectorHasPushButton;
    }

    protected void updateEditableBehavior() {
        Button[] radioButtons;
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        IDropDownSelector[] dropDownSelectors = this.getDropDownSelectors();
        if (dropDownSelectors != null) {
            int i = 0;
            while (i < dropDownSelectors.length) {
                if (dropDownSelectors[i] != null) {
                    dropDownSelectors[i].setEditable(editable && this.getSelectionIndex() == i);
                }
                ++i;
            }
        }
        if ((radioButtons = this.getRadioButtons()) != null) {
            int i = 0;
            while (i < radioButtons.length) {
                if (radioButtons[i] != null) {
                    radioButtons[i].setEnabled(editable);
                }
                ++i;
            }
        }
    }

    private abstract class Adapter {
        private int index;

        public Adapter(int index) {
            this.setIndex(index);
        }

        protected int getIndex() {
            return this.index;
        }

        private void setIndex(int index) {
            this.index = index;
        }
    }

    private class SelectionAdapter
    extends Adapter
    implements SelectionListener {
        public SelectionAdapter(int index) {
            super(index);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    RadioButtonComponent.this.getDropDownSelector(this.getIndex()).setEditable(RadioButtonComponent.this.isEditable());
                    RadioButtonComponent.this.improveEvent((TypedEvent)e, this.getIndex());
                    RadioButtonComponent.super.fireWidgetDefaultSelected(e);
                } else {
                    RadioButtonComponent.this.getDropDownSelector(this.getIndex()).setEditable(false);
                }
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }

    class ModifyAdapter
    extends Adapter
    implements ModifyListener {
        public ModifyAdapter(int index) {
            super(index);
        }

        public void modifyText(ModifyEvent e) {
            RadioButtonComponent.this.improveEvent((TypedEvent)e, this.getIndex());
            RadioButtonComponent.super.fireModifyText(e);
        }
    }
}

