/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.list;

import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.reuse.GenericMultiTableComponent;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.list.IListElement;
import com.tssap.util.ui.reuse.list.IListElementGridLayoutPaneContainer;
import com.tssap.util.ui.reuse.list.IListSelector;
import com.tssap.util.ui.reuse.list.IListSelectorCallback;
import com.tssap.util.ui.reuse.list.ListElement;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;

public class ListSelector
extends GenericMultiTableComponent
implements IListSelector {
    private static final int SPLITTER_WEIGHTH = 4;
    private static final int TABLE_COLUMN_WIDTH = 128;
    private static final int NUM_OF_COLS = 1;
    private static final boolean EQUAL_SIZE_FLAG = false;
    private static final String DEFAULT_TITLE = "";
    private final ListLabelProvider DEFAULT_LABEL_PROVIDER = new ListLabelProvider();
    private boolean securityRemove = false;
    private String defaultEntry;
    private IListSelectorCallback callback;
    private IGridLayoutPane userGridLayoutPane;
    private IListElementGridLayoutPaneContainer gridLayoutPaneContainer;
    private Vector listElementVector;
    private IListElement lastSelectedListElement;
    private LabelProvider labelProvider;

    public ListSelector(IListSelectorCallback callback, IListElementGridLayoutPaneContainer gridLayoutPaneContainer) {
        this.setCallback(callback);
        this.setGridLayoutPaneContainer(gridLayoutPaneContainer);
    }

    public ListSelector(String title, IListSelectorCallback callback, IListElementGridLayoutPaneContainer gridLayoutPaneContainer) {
        super(title);
        this.setCallback(callback);
        this.setGridLayoutPaneContainer(gridLayoutPaneContainer);
    }

    public void initContainer(IGridLayoutPane userArea) {
        ISashPane splitterPane = userArea.addHorizontalSashPane(userArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane listGlp = splitterPane.addGridLayoutPane(2);
        String[] columnLabels = new String[]{DEFAULT_TITLE};
        int[] columnWidths = new int[]{128};
        TableViewer tableViewer = listGlp.addTableViewer(false, columnLabels, columnWidths, listGlp.createGridLayoutData(4, 4, true, true, 2, 1));
        this.setTableViewer(tableViewer);
        if (this.hasAddRemoveButtons()) {
            this.createAddButton(listGlp, (SelectionListener)new AddButtonListener());
            this.createRemoveButton(listGlp, (SelectionListener)new RemoveButtonListener());
        }
        IGridLayoutPane userGridLayoutPane = splitterPane.addGridLayoutPane(DEFAULT_TITLE, this.getGridLayoutPaneContainer().getUserGridNumOfColumns(), this.getGridLayoutPaneContainer().isUserGridEqualColSize());
        this.getGridLayoutPaneContainer().initContainer(userGridLayoutPane);
        this.setUserGridLayoutPane(userGridLayoutPane);
        splitterPane.setWeights(new int[]{1, 4});
        tableViewer.getTable().setHeaderVisible(false);
        tableViewer.getTable().setLinesVisible(false);
        tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        if (this.getLabelProvider() != null) {
            tableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        } else {
            tableViewer.setLabelProvider((IBaseLabelProvider)this.DEFAULT_LABEL_PROVIDER);
        }
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)new ListSelectionAdapter());
        tableViewer.setInput((Object)new IListElement[0]);
        if (this.getElements() != null && this.getElements().length > 0) {
            this.setSelection(0);
        }
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public String getDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(String defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    private IGridLayoutPane getUserGridLayoutPane() {
        return this.userGridLayoutPane;
    }

    private void setUserGridLayoutPane(IGridLayoutPane gridLayoutPane) {
        this.userGridLayoutPane = gridLayoutPane;
    }

    public IListSelectorCallback getCallback() {
        return this.callback;
    }

    public void setCallback(IListSelectorCallback callback) {
        this.callback = callback;
    }

    public boolean isSecurityRemove() {
        return this.securityRemove;
    }

    public void setSecurityRemove(boolean secure) {
        this.securityRemove = secure;
    }

    public IListElementGridLayoutPaneContainer getGridLayoutPaneContainer() {
        return this.gridLayoutPaneContainer;
    }

    public void setGridLayoutPaneContainer(IListElementGridLayoutPaneContainer gridLayoutPaneContainer) {
        this.gridLayoutPaneContainer = gridLayoutPaneContainer;
    }

    public void setButtonOrientation(int buttonOrientation) {
        throw new RuntimeException("Set button orientation not support on list selector !");
    }

    private Vector getListElementVector() {
        if (this.listElementVector == null) {
            this.listElementVector = new Vector();
        }
        return this.listElementVector;
    }

    private void setListElementVector(Vector listElementVector) {
        this.listElementVector = listElementVector;
    }

    public IListElement getElement(IListElement listElement) {
        return this.getElement(listElement.getKey());
    }

    private IListElement getElement(Object key) {
        IListElement ret = null;
        Enumeration elemEnum = this.getListElementVector().elements();
        while (elemEnum.hasMoreElements() && ret == null) {
            IListElement iListElement = (IListElement)elemEnum.nextElement();
            if (!iListElement.getKey().equals(key)) continue;
            ret = iListElement;
        }
        return ret;
    }

    public IListElement[] getElements() {
        IListElement[] ret = new IListElement[]{};
        ret = this.getListElementVector().toArray(ret);
        return ret;
    }

    private boolean containsElement(Object key) {
        boolean ret = this.getElement(key) != null;
        return ret;
    }

    public boolean containsElement(IListElement listElement) {
        boolean ret = this.getElement(listElement) != null;
        return ret;
    }

    public boolean removeElement(IListElement listElement) {
        boolean ret = this.getListElementVector().remove(listElement);
        if (this.getTableViewer() != null) {
            this.getTableViewer().remove((Object)listElement);
        }
        return ret;
    }

    private boolean removeElement(Object key) {
        IListElement element = this.getElement(key);
        return this.removeElement(element);
    }

    public int removeElements(IListElement[] listElements) {
        int ret = 0;
        int i = 0;
        while (i < listElements.length) {
            IListElement iListElement = listElements[i];
            if (this.removeElement(iListElement)) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public void removeAll() {
        this.removeElements(this.getElements());
        if (this.getTableViewer() != null) {
            this.getTableViewer().refresh(true);
            this.getTableViewer().setInput((Object)"refresh");
        }
    }

    public void setElements(IListElement[] listElements) {
        this.setListElementVector(new Vector<IListElement>(Arrays.asList(listElements)));
        if (this.getTableViewer() != null) {
            this.getTableViewer().refresh();
        }
    }

    public boolean changeElement(IListElement listElement, String newName, Object userObject) {
        if (listElement != null) {
            listElement.setName(newName);
            listElement.setUserObject(userObject);
            if (this.getTableViewer() != null) {
                this.getTableViewer().update((Object)listElement, null);
            }
            return true;
        }
        return false;
    }

    public boolean addElement(String value, Object userObject) {
        ListElement listElement = new ListElement(value, userObject);
        return this.addElement(listElement);
    }

    public int addElements(IListElement[] listElements) {
        int ret = 0;
        int i = 0;
        while (i < listElements.length) {
            IListElement iListElement = listElements[i];
            if (this.addElement(iListElement)) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public boolean addElement(IListElement listElement) {
        boolean ret = false;
        if (!this.containsElement(listElement)) {
            this.getListElementVector().add(listElement);
            if (this.getTableViewer() != null) {
                this.getTableViewer().add((Object)listElement);
            }
            ret = true;
        }
        return ret;
    }

    public IListElement getSelection() {
        return this.getFirstSelectedElement();
    }

    public void setSelection(IListElement listElement) {
        if (this.getTableViewer() != null && this.getListElementVector().contains(listElement)) {
            this.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)listElement));
        }
    }

    public void setSelection(int elementIndex) {
        if (this.getListElementVector() != null && this.getListElementVector().size() > elementIndex) {
            Object listElement = this.getListElementVector().get(elementIndex);
            if (this.getTableViewer() != null && listElement != null) {
                this.getTableViewer().setSelection((ISelection)new StructuredSelection(listElement));
            }
        }
    }

    private IListElement getFirstSelectedElement() {
        IStructuredSelection structuredSelection;
        Object obj;
        IListElement ret = null;
        if (this.getTableViewer() != null && this.getTableViewer().getSelection() instanceof IStructuredSelection && (obj = (structuredSelection = (IStructuredSelection)this.getTableViewer().getSelection()).getFirstElement()) instanceof IListElement) {
            ret = (IListElement)obj;
        }
        return ret;
    }

    private IListElement getLastSelectedListElement() {
        return this.lastSelectedListElement;
    }

    private void setLastSelectedListElement(IListElement lastSelectedListElement) {
        this.lastSelectedListElement = lastSelectedListElement;
    }

    public void refresh() {
        super.refresh();
        this.setElements(this.getElements());
        String selName = DEFAULT_TITLE;
        if (this.getFirstSelectedElement() != null) {
            selName = this.getFirstSelectedElement().getName();
        }
        this.getUserGridLayoutPane().setTitle(selName);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getTableViewer() != null) {
            this.getTableViewer().getTable().setEnabled(enabled);
        }
        if (this.getGridLayoutPaneContainer() != null && this.getGridLayoutPaneContainer() instanceof IReuseable) {
            ((IReuseable)((Object)this.getGridLayoutPaneContainer())).setEnabled(enabled);
        }
    }

    private LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getGridLayoutPaneContainer() != null) {
            this.getGridLayoutPaneContainer().setEditable(editable);
        }
    }

    private class RemoveButtonListener
    extends SelectionAdapter {
        private RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IListElement removalElement = ListSelector.this.getFirstSelectedElement();
            if (ListSelector.this.getCallback().isRemovePossible(removalElement)) {
                int removalIndex = ListSelector.this.getListElementVector().indexOf(removalElement);
                ListSelector.this.removeElement(removalElement);
                ListSelector.this.getCallback().elementRemoved(removalElement);
                int elementCount = ListSelector.this.getListElementVector().size();
                if (elementCount > 0) {
                    if (elementCount > removalIndex) {
                        ListSelector.this.setSelection(removalIndex);
                    } else {
                        ListSelector.this.setSelection(removalIndex - 1);
                    }
                }
            }
        }
    }

    private class AddButtonListener
    extends SelectionAdapter {
        private AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ListSelector.this.getCallback() != null) {
                IListElement[] newElements = ListSelector.this.getCallback().getNewElements();
                int i = 0;
                while (i < newElements.length) {
                    IListElement iListElement = newElements[i];
                    if (iListElement != null) {
                        ListSelector.this.addElement(iListElement);
                        ListSelector.this.getCallback().elementAdded(iListElement);
                        ListSelector.this.setSelection(iListElement);
                    }
                    ++i;
                }
            }
        }
    }

    private class ListSelectionAdapter
    implements ISelectionChangedListener {
        private ListSelectionAdapter() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean isElementSelected;
            IListElement firstSelectedElement = ListSelector.this.getFirstSelectedElement();
            String selName = ListSelector.DEFAULT_TITLE;
            boolean bl = isElementSelected = firstSelectedElement != null;
            if (firstSelectedElement != null) {
                selName = firstSelectedElement.getName();
            }
            if (ListSelector.this.getLastSelectedListElement() == null || !ListSelector.this.getLastSelectedListElement().equals(firstSelectedElement)) {
                ListSelector.this.getUserGridLayoutPane().setTitle(selName);
                ListSelector.this.getGridLayoutPaneContainer().updateContainer(ListSelector.this.getLastSelectedListElement(), firstSelectedElement);
                ListSelector.this.setLastSelectedListElement(firstSelectedElement);
                ListSelector.super.setRemoveEnabled(isElementSelected && ListSelector.this.isEditable());
                ListSelector.this.updateEditableBehavior();
            }
        }
    }

    private class ListLabelProvider
    extends LabelProvider {
        private Image listImage = SapIdeUtilImages.getSapImage(SapImage.ICON_LED_GREEN);

        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.listImage;
        }

        public String getText(Object obj) {
            String ret = null;
            if (obj instanceof IListElement) {
                IListElement element = (IListElement)obj;
                ret = element.getName();
            }
            return ret;
        }
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] ret = ListSelector.this.getElements();
            return ret;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IListElement[]) {
                ListSelector.this.setElements((IListElement[])newInput);
            }
        }
    }
}

