/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.list;

import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.reuse.GenericMultiListComponent;
import com.tssap.util.ui.reuse.list.IListElement;
import com.tssap.util.ui.reuse.list.IListSelectorCallback;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.List;

public class ListComponent
extends GenericMultiListComponent {
    private boolean securityRemove = false;
    private IListSelectorCallback callback;
    private IGridLayoutPane userArea;
    private List myList;
    private IListElement element;
    private IListElement[] elements;
    private Vector listElementVector;

    public ListComponent() {
    }

    public ListComponent(IListSelectorCallback callback) {
        this.setCallback(callback);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane listGlp = userArea.addGridLayoutPane(2, userArea.createGridLayoutData(4, 4, true, true, 2, 1));
        IGridLayoutData gridData = listGlp.createGridLayoutData(4, 4, true, true, 2, 1);
        ISimplePane listSimplePane = listGlp.addSimplePane(gridData);
        this.myList = new List(listSimplePane.getComposite(), 4);
        this.createAddButton(listGlp, (SelectionListener)new AddButtonListener());
        this.createRemoveButton(listGlp, (SelectionListener)new RemoveButtonListener());
        this.setEnabled(false);
        this.setAddRemoveButtonsEnabled(false);
        this.myList.setItems(new String[0]);
        this.elements = this.getElements();
        if (this.elements != null) {
            String[] listElementArr = new String[this.elements.length];
            if (this.elements != null && this.elements.length > 0) {
                int j = 0;
                while (j < this.elements.length) {
                    listElementArr[j] = this.elements[j].getName();
                    ++j;
                }
                this.myList.setItems(listElementArr);
                this.myList.setSelection(0);
            }
        }
        this.setList(this.myList);
    }

    private IListSelectorCallback getCallback() {
        return this.callback;
    }

    private void setCallback(IListSelectorCallback callback) {
        this.callback = callback;
    }

    private String getFirstSelectedElement() {
        int selectionIndex;
        String selection = null;
        if (this.getList() != null && this.getList().getSelection() != null && (selectionIndex = this.getList().getSelectionIndex()) != -1) {
            selection = this.getList().getItem(selectionIndex);
        }
        return selection;
    }

    private boolean removeElement(int elementIndex) {
        String element = this.getList().getItem(elementIndex);
        return this.removeElement(element);
    }

    private boolean removeElement(String element) {
        if (this.getList() != null) {
            this.getList().remove(element);
            return true;
        }
        return false;
    }

    public boolean containsElement(IListElement listElement) {
        String[] listItems = this.getList().getItems();
        int k = 0;
        while (k < listItems.length) {
            if (listItems[k].equals(listElement)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private boolean addElement(IListElement listElement) {
        boolean ret = false;
        if (!this.containsElement(listElement)) {
            if (this.getList() != null) {
                this.getList().add(listElement.getName());
            }
            ret = true;
        }
        return ret;
    }

    private String getListElement(int elementIndex) {
        String listElement = null;
        if (this.getList() != null) {
            listElement = this.getList().getItem(elementIndex);
        }
        return listElement;
    }

    public String[] getListElements() {
        String[] listElements = null;
        this.elements = this.getElements();
        if (this.elements != null) {
            listElements = new String[this.elements.length];
            if (this.elements != null) {
                int i = 0;
                while (i < this.elements.length) {
                    listElements[i] = this.elements[i].getName();
                    ++i;
                }
            }
        }
        return listElements;
    }

    public void setSelection(int elementIndex) {
        if (this.getList() != null) {
            this.getList().setSelection(elementIndex);
        }
    }

    public boolean isSecurityRemove() {
        return this.securityRemove;
    }

    public void setSecurityRemove(boolean securityRemove) {
        this.securityRemove = securityRemove;
    }

    public IListElement[] getElements() {
        return this.elements;
    }

    public void setElements(IListElement[] elements) {
        this.elements = elements;
        int i = 0;
        while (i < elements.length) {
            this.getList().add(elements[i].getName());
            ++i;
        }
        this.getList().update();
    }

    private class RemoveButtonListener
    extends SelectionAdapter {
        private RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IListElement[] listElements;
            String removalElement = ListComponent.this.getFirstSelectedElement();
            int removalIndex = ListComponent.this.getList().getSelectionIndex();
            if (removalIndex != -1) {
                ListComponent.this.removeElement(removalIndex);
            }
            if ((listElements = ListComponent.this.getElements()) != null) {
                int j = 0;
                while (j < listElements.length) {
                    if (listElements[j].getName().equals(removalElement)) {
                        ListComponent.this.getCallback().elementRemoved(listElements[j]);
                    }
                    ++j;
                }
                int elementCount = ListComponent.this.getListElements().length;
                if (elementCount > 0) {
                    if (elementCount > removalIndex) {
                        ListComponent.this.setSelection(removalIndex);
                    } else {
                        ListComponent.this.setSelection(removalIndex - 1);
                    }
                }
            }
        }
    }

    private class AddButtonListener
    extends SelectionAdapter {
        private AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ListComponent.this.getCallback() != null) {
                IListElement[] newElements = ListComponent.this.getCallback().getNewElements();
                int i = 0;
                while (i < newElements.length) {
                    IListElement iListElement = newElements[i];
                    if (iListElement != null) {
                        ListComponent.this.addElement(iListElement);
                        ListComponent.this.getCallback().elementAdded(iListElement);
                        ListComponent.this.setSelection(i);
                    }
                    ++i;
                }
            }
        }
    }
}

