/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.core.IConstants;
import com.tssap.util.ui.reuse.java.IJavaData;
import com.tssap.util.ui.reuse.java.ITypeData;
import com.tssap.util.ui.reuse.java.JavaData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

public class TypeData
extends JavaData
implements ITypeData {
    private String fullQualifiedTypeName;
    private int arrayDimension = 0;

    public TypeData() {
    }

    public TypeData(String name) {
        this();
        this.setFullQualifiedTypeName(name);
    }

    public TypeData(String name, int arrayDim) {
        this.setFullQualifiedTypeName(name);
        this.setArrayDimension(arrayDim);
    }

    public String getFullQualifiedTypeName() {
        return this.fullQualifiedTypeName;
    }

    public void setFullQualifiedTypeName(String newName) {
        String oldName = this.fullQualifiedTypeName;
        if (newName != oldName) {
            this.fullQualifiedTypeName = newName;
            this.getPropertyChangeSupport().firePropertyChange("fullQualifiedTypeName", oldName, newName);
        }
    }

    public String getSignature() {
        String ret = this.getFullQualifiedTypeName();
        int arrayDim = this.getArrayDimension();
        int i = 1;
        while (i <= arrayDim && i <= 10) {
            ret = ret + "[]";
            ++i;
        }
        if (arrayDim > 10) {
            ret = ret + "...";
        }
        return ret;
    }

    public IStatus getValidationStatus() {
        IStatus ret = super.getValidationStatus();
        if (ret.isOK()) {
            String fullQualifiedTypeName = this.getFullQualifiedTypeName();
            boolean found = false;
            int i = 0;
            while (!found && i < IConstants.DATA_TYPES.length) {
                found = IConstants.DATA_TYPES[i].equals(fullQualifiedTypeName);
                ++i;
            }
            if (!found) {
                ret = JavaConventions.validateJavaTypeName((String)fullQualifiedTypeName);
            }
        }
        return ret;
    }

    public int getArrayDimension() {
        int ret = this.arrayDimension;
        if (ret > 0 && this.getFullQualifiedTypeName().equals("void")) {
            ret = 0;
        }
        return ret;
    }

    public void setArrayDimension(int arrayDim) {
        if (this.arrayDimension >= 0) {
            if (this.arrayDimension != arrayDim) {
                int oldArrayDimension = this.arrayDimension;
                this.arrayDimension = arrayDim;
                this.getPropertyChangeSupport().firePropertyChange("arrayDimension", oldArrayDimension, arrayDim);
            }
        } else {
            throw new IllegalArgumentException("Array dimension has to be greater than or equal to 0");
        }
    }

    public boolean equalsSignature(IJavaData javaData) {
        boolean ret = false;
        if (javaData instanceof ITypeData) {
            ITypeData otherTypeData = (ITypeData)javaData;
            if (this.getFullQualifiedTypeName().equals(otherTypeData.getFullQualifiedTypeName()) && this.getArrayDimension() == otherTypeData.getArrayDimension()) {
                ret = true;
            }
        }
        return ret;
    }
}

