/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.core.IConstants;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.IDropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.java.ITypeData;
import com.tssap.util.ui.reuse.java.JavaComponent;
import com.tssap.util.ui.reuse.java.TypeData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class TypeComponent2
extends JavaComponent {
    private Button arrayCheckbox;
    private Text arrayDimensionField;
    private IDropDownSelector typeNameSelector;
    private IChooser typeChooser;
    private boolean showArrayCheckbox = true;
    private boolean isArrayCheckboxEditable = true;
    private boolean isFullQualifiedNameLabelVisible = true;

    public TypeComponent2() {
    }

    public TypeComponent2(String title) {
        super(title);
    }

    public TypeComponent2(ITypeData typeData) {
        this();
        this.setTypeData(typeData);
    }

    public TypeComponent2(String title, ITypeData typeData) {
        this(title);
        this.setTypeData(typeData);
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setMargin(0, 0);
        userArea.setSpacing(0, 0);
        IGridLayoutPane glp = userArea.addGridLayoutPane(2, userArea.createGridLayoutData(4, 4, true, false));
        glp.setMargin(0, 0);
        glp.setSpacing(0, 0);
        this.typeNameSelector = new DropDownSelector(0);
        this.typeNameSelector.setIsGrabHorizontal(true);
        this.typeNameSelector.setDescriptionPositionLeft(false);
        if (this.isFullQualifiedNameLabelVisible()) {
            this.typeNameSelector.setSelectorDescription("Fully Qualified Name");
        }
        this.typeNameSelector.setPushButtonChooser(this.getTypeChooser());
        this.typeNameSelector.createPartControl(glp);
        if (this.showArrayCheckbox) {
            this.arrayCheckbox = glp.addCheckBox("Array");
            IGridLayoutPane layoutingGlp = glp.addGridLayoutPane(5, true, glp.createGridLayoutData(4, 4, true, false));
            this.arrayDimensionField = layoutingGlp.addTextField("0", layoutingGlp.createGridLayoutData(4, 4, true, false));
            this.arrayDimensionField.setToolTipText("Dimension");
        }
        this.decorateComponents();
    }

    private void decorateComponents() {
        if (this.isAutoRefreshUI()) {
            this.refreshUIFromData();
        }
        this.getTypeNameSelector().addModifyListener(this.getModifyAdapterSingleton());
        this.getTypeNameSelector().addModifyListener(new TypeNameModifyListener());
        SelectionAdapter selListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeComponent2.this.handleEvent();
                TypeComponent2.super.fireWidgetSelected(e);
                TypeComponent2.this.updateArrayDimensionField();
            }
        };
        if (this.arrayCheckbox != null) {
            this.arrayCheckbox.addSelectionListener((SelectionListener)selListener);
        }
        this.updateArrayDimensionField();
        if (this.arrayDimensionField != null) {
            this.arrayDimensionField.addModifyListener(this.getModifyAdapterSingleton());
        }
    }

    private void updateArrayDimensionField() {
        if (this.isShowArrayCheckbox() && this.arrayCheckbox != null && this.arrayDimensionField != null) {
            if (this.arrayCheckbox.getSelection()) {
                String dimText = this.arrayDimensionField.getText();
                int dim = 0;
                try {
                    dim = dimText != null && dimText.length() > 0 ? Integer.parseInt(dimText) : 0;
                }
                catch (NumberFormatException nfe) {
                    dim = 0;
                }
                if (dim < 1) {
                    this.arrayDimensionField.setText("1");
                }
                this.arrayDimensionField.setVisible(true);
            } else {
                this.arrayDimensionField.setVisible(false);
            }
        }
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        super.refreshDataFromUI();
        if (this.getTypeNameSelector() != null) {
            this.getTypeData().setFullQualifiedTypeName(this.getTypeNameSelector().getText());
        }
        if (this.arrayCheckbox != null && this.arrayDimensionField != null) {
            boolean selected = this.arrayCheckbox.getSelection();
            String dimText = this.arrayDimensionField.getText();
            int dim = 0;
            try {
                dim = dimText != null && dimText.length() > 0 ? Integer.parseInt(dimText) : 0;
            }
            catch (NumberFormatException nfe) {
                dim = 1;
            }
            if (dim < 0) {
                dim = 1;
            }
            if (selected) {
                this.getTypeData().setArrayDimension(dim);
            } else {
                this.getTypeData().setArrayDimension(0);
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        super.refreshUIFromData();
        if (this.getTypeNameSelector() != null) {
            this.getTypeNameSelector().setText(this.getTypeData().getFullQualifiedTypeName());
        }
        if (this.arrayCheckbox != null && this.arrayDimensionField != null) {
            int arrayDim = this.getTypeData().getArrayDimension();
            if (arrayDim > 0) {
                this.arrayCheckbox.setSelection(true);
                this.arrayDimensionField.setText(Integer.toString(arrayDim));
            } else {
                this.arrayCheckbox.setSelection(false);
                this.arrayDimensionField.setText(Integer.toString(0));
            }
        }
        this.updateArrayDimensionField();
        this.stopRefreshingUI();
    }

    public ITypeData getTypeData() {
        ITypeData ret = null;
        if (this.getData() == null) {
            this.setData(new TypeData());
        }
        if (this.getData() instanceof ITypeData) {
            ret = (ITypeData)this.getData();
        }
        return ret;
    }

    public void setTypeData(ITypeData data) {
        if (data instanceof ITypeData) {
            this.setData(data);
            if (this.isAutoRefreshUI()) {
                this.refreshUIFromData();
            }
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof ITypeData)) {
            ret = "this is not a type data";
        }
        return ret;
    }

    public void setTypeChooser(IChooser typeChooser) {
        this.typeChooser = typeChooser;
        if (this.getTypeNameSelector() != null) {
            this.getTypeNameSelector().setPushButtonChooser(typeChooser);
        }
    }

    private IChooser getTypeChooser() {
        return this.typeChooser;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getTypeNameSelector() != null) {
            this.getTypeNameSelector().setEditable(editable);
        }
        if (this.arrayCheckbox != null) {
            if (!this.isArrayCheckboxEditable) {
                this.arrayCheckbox.setEnabled(this.isArrayCheckboxEditable);
            } else {
                this.arrayCheckbox.setEnabled(editable);
            }
        }
    }

    public IStatus getValidationStatus() {
        IStatus ret = super.getValidationStatus();
        if (ret.isOK() && this.getTypeNameSelector() != null) {
            String fullQualifiedTypeName = this.getTypeNameSelector().getText();
            boolean found = false;
            int i = 0;
            while (!found && i < IConstants.DATA_TYPES.length) {
                found = IConstants.DATA_TYPES[i].equals(fullQualifiedTypeName);
                ++i;
            }
            if (!found) {
                ret = JavaConventions.validateJavaTypeName((String)fullQualifiedTypeName);
            }
        }
        if (ret.isOK() && this.arrayCheckbox != null && this.arrayCheckbox.getSelection() && this.arrayDimensionField != null && this.arrayDimensionField.isVisible()) {
            int dim;
            String dimText = this.arrayDimensionField.getText();
            try {
                dim = dimText != null ? Integer.parseInt(dimText) : 0;
            }
            catch (NumberFormatException e) {
                dim = -1;
            }
            if (dim < 1) {
                ret = new JavaModelStatus(4, "No valid array dimension.");
            }
        }
        return ret;
    }

    private boolean isShowArrayCheckbox() {
        return this.showArrayCheckbox;
    }

    public void setShowArrayCheckbox(boolean showArrayCheckbox) {
        this.showArrayCheckbox = showArrayCheckbox;
    }

    private boolean isArrayCheckboxEditable() {
        return this.isArrayCheckboxEditable;
    }

    public void setArrayCheckboxEditable(boolean isArrayCheckboxEditable) {
        this.isArrayCheckboxEditable = isArrayCheckboxEditable;
    }

    private boolean isFullQualifiedNameLabelVisible() {
        return this.isFullQualifiedNameLabelVisible;
    }

    public void setFullQualifiedNameLabelVisible(boolean isFullQualifiedNameLabelVisible) {
        this.isFullQualifiedNameLabelVisible = isFullQualifiedNameLabelVisible;
    }

    public void setTypeNameSelector(IDropDownSelector typeNameSelector) {
        this.typeNameSelector = typeNameSelector;
    }

    public IDropDownSelector getTypeNameSelector() {
        return this.typeNameSelector;
    }

    public class TypeNameModifyListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            if (TypeComponent2.this.isShowArrayCheckbox() && TypeComponent2.this.getTypeNameSelector() != null && TypeComponent2.this.arrayCheckbox != null && TypeComponent2.this.arrayDimensionField != null) {
                String typeName = TypeComponent2.this.getTypeNameSelector().getText();
                if (typeName.equals("void")) {
                    TypeComponent2.this.arrayCheckbox.setEnabled(false);
                    TypeComponent2.this.arrayDimensionField.setEditable(false);
                } else if (TypeComponent2.this.isArrayCheckboxEditable() && TypeComponent2.this.isEditable()) {
                    TypeComponent2.this.arrayCheckbox.setEnabled(true);
                    TypeComponent2.this.arrayDimensionField.setEditable(true);
                }
            }
            TypeComponent2.super.fireModifyText(e);
        }
    }
}

