/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.ui.reuse.java.IJavaData;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.ISignatureProvider;
import com.tssap.util.ui.reuse.java.ITypeData;
import com.tssap.util.ui.reuse.java.NamedModifierData;
import com.tssap.util.ui.reuse.java.TypeData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

public class ParameterData
extends NamedModifierData
implements IParameterData {
    private ITypeData typeData;

    public ParameterData(String name, int modifier) {
        this(name);
        this.setModifier(modifier);
    }

    public ParameterData() {
    }

    public ParameterData(String name) {
        super(name);
    }

    public ParameterData(String name, String fullQualifiedTypeName) {
        super(name);
        this.setName(name);
        this.setFullQualifiedTypeName(fullQualifiedTypeName);
    }

    public ParameterData(String name, String fullQualifiedTypeName, int arrayDim) {
        this(name, fullQualifiedTypeName);
        this.setArrayDimension(arrayDim);
    }

    public String getFullQualifiedTypeName() {
        return this.getTypeData().getFullQualifiedTypeName();
    }

    public void setFullQualifiedTypeName(String name) {
        this.getTypeData().setFullQualifiedTypeName(name);
    }

    public int getArrayDimension() {
        return this.getTypeData().getArrayDimension();
    }

    public void setArrayDimension(int arrayDim) {
        this.getTypeData().setArrayDimension(arrayDim);
    }

    private ITypeData getTypeData() {
        if (this.typeData == null) {
            this.typeData = new TypeData();
        }
        return this.typeData;
    }

    public String getSignature() {
        String modifierString = super.getSignature();
        if (modifierString.length() > 0) {
            modifierString = modifierString + " ";
        }
        String typeSignature = "";
        if (this.getTypeData() instanceof ISignatureProvider) {
            typeSignature = ((ISignatureProvider)((Object)this.getTypeData())).getSignature();
        }
        String ret = modifierString + " " + typeSignature + " " + this.getName();
        return ret;
    }

    public IStatus getValidationStatus() {
        IStatus ret = super.getValidationStatus();
        if (ret.isOK()) {
            ret = this.getTypeData().getValidationStatus();
        }
        if (ret.isOK()) {
            String name = this.getName();
            ret = JavaConventions.validateFieldName((String)name);
        }
        return ret;
    }

    public boolean equalsSignature(IJavaData javaData) {
        boolean ret = false;
        if (javaData instanceof IParameterData) {
            IParameterData otherParameterData = (IParameterData)javaData;
            if (this.getName().equals(otherParameterData.getName())) {
                return true;
            }
        }
        return ret;
    }
}

