/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.java.IModifierData;
import com.tssap.util.ui.reuse.java.IParameterCallback;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.JavaComponent;
import com.tssap.util.ui.reuse.java.ModifierComponent;
import com.tssap.util.ui.reuse.java.ModifierData;
import com.tssap.util.ui.reuse.java.ParameterData;
import com.tssap.util.ui.reuse.java.TypeComponent2;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.swt.widgets.Text;

public class ParameterComponent
extends JavaComponent {
    private static final IModifierData POSSIBLE_MODIFIER_DATA = new ModifierData(32);
    private Text nameTextField;
    private TypeComponent2 typeComponent;
    private ModifierComponent modifierComponent;
    private IChooser typeChooser;
    private IParameterCallback callback;
    private boolean modifiersVisible = true;
    private boolean modifiersEditable = true;

    public ParameterComponent() {
    }

    public ParameterComponent(String title) {
        super(title);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane nameArea = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 2, true, false));
        nameArea.addTextLabel("Name", nameArea.createGridLayoutData(1, 2));
        this.nameTextField = nameArea.addTextField("", nameArea.createGridLayoutData(4, 2, true, false));
        this.typeComponent = new TypeComponent2("Type", this.getParameterData());
        this.typeComponent.setTypeChooser(this.getTypeChooser());
        this.typeComponent.createPartControl(userArea, true, false);
        if (this.isModifiersVisible()) {
            this.modifierComponent = new ModifierComponent("Modifiers", this.getParameterData(), this.getPossibleModifiers(), this.getPossibleModifiers());
            this.modifierComponent.createPartControl(userArea, true, false);
            this.modifierComponent.setEditable(this.isModifiersEditable());
        }
        this.setEnabled(this.isEnabled());
        this.decorateComponents();
    }

    protected boolean showVoidAsPossibleType() {
        return false;
    }

    private void decorateComponents() {
        if (this.isAutoRefreshUI()) {
            this.refreshUIFromData();
        }
        if (this.nameTextField != null) {
            this.nameTextField.addModifyListener(this.getModifyAdapterSingleton());
        }
        if (this.typeComponent != null) {
            this.typeComponent.setAutoRefreshData(false);
            this.typeComponent.addModifyListener(this.getModifyAdapterSingleton());
            this.typeComponent.setModifiedCallback(this.getModifiedCallback());
        }
        if (this.modifierComponent != null && this.isModifiersVisible()) {
            this.modifierComponent.setAutoRefreshData(false);
            this.modifierComponent.addModifyListener(this.getModifyAdapterSingleton());
            this.modifierComponent.setModifiedCallback(this.getModifiedCallback());
        }
    }

    protected IModifierData getPossibleModifiers() {
        return POSSIBLE_MODIFIER_DATA;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        super.refreshDataFromUI();
        IParameterData parameterData = this.getParameterData();
        if (parameterData != null) {
            if (this.nameTextField != null) {
                parameterData.setName(this.nameTextField.getText());
            }
            if (this.typeComponent != null) {
                this.typeComponent.refreshDataFromUI();
            }
            if (this.modifierComponent != null) {
                this.modifierComponent.refreshDataFromUI();
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        super.refreshUIFromData();
        IParameterData parameterData = this.getParameterData();
        if (parameterData != null) {
            if (this.nameTextField != null) {
                this.nameTextField.setText(parameterData.getName());
            }
            if (this.typeComponent != null) {
                this.typeComponent.setTypeData(parameterData);
                this.typeComponent.refreshUIFromData();
            }
            if (this.modifierComponent != null) {
                this.modifierComponent.setModifierData(parameterData);
                this.modifierComponent.refreshUIFromData();
            }
        }
        this.stopRefreshingUI();
    }

    public IParameterData getParameterData() {
        IParameterData ret = null;
        if (this.getData() == null) {
            this.setData(new ParameterData());
        } else if (this.getData() instanceof IParameterData) {
            ret = (IParameterData)this.getData();
        }
        return ret;
    }

    public void setParameterData(IParameterData data) {
        if (data instanceof IParameterData) {
            this.setData(data);
            if (this.isAutoRefreshUI()) {
                this.refreshUIFromData();
            }
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IParameterData)) {
            ret = "this is not a parameter data";
        }
        return ret;
    }

    protected void updateSignatureTooltip() {
        super.updateSignatureTooltip();
        if (this.typeComponent != null) {
            this.typeComponent.updateSignatureTooltip();
        }
        if (this.modifierComponent != null) {
            this.modifierComponent.updateSignatureTooltip();
        }
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        super.setModifiedCallback(callback);
        if (this.typeComponent != null) {
            this.typeComponent.setModifiedCallback(callback);
        }
        if (this.modifierComponent != null) {
            this.modifierComponent.setModifiedCallback(callback);
        }
    }

    public IStatus getValidationStatus() {
        String name;
        IStatus ret = super.getValidationStatus();
        if (ret.isOK() && this.typeComponent != null) {
            ret = this.typeComponent.getValidationStatus();
        }
        if (ret.isOK() && this.nameTextField != null) {
            name = this.nameTextField.getText();
            ret = JavaConventions.validateFieldName((String)name);
        }
        if (ret.isOK() && this.getCallback() != null && this.nameTextField != null) {
            name = this.nameTextField.getText();
            List<String> namesList = Arrays.asList(this.getCallback().getDisapprovedNames());
            if (namesList.contains(name)) {
                ret = new JavaModelStatus(4, "Parameter name already used.");
            }
        }
        return ret;
    }

    public void setTypeChooser(IChooser typeChooser) {
        this.typeChooser = typeChooser;
        if (this.typeComponent != null) {
            this.typeComponent.setTypeChooser(typeChooser);
        }
    }

    private IChooser getTypeChooser() {
        return this.typeChooser;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.nameTextField != null) {
            this.nameTextField.setEditable(this.isEditable());
        }
        if (this.typeComponent != null) {
            this.typeComponent.setEditable(this.isEditable());
        }
        if (this.modifierComponent != null) {
            this.modifierComponent.setEditable(this.isEditable());
        }
    }

    public IParameterCallback getCallback() {
        return this.callback;
    }

    public void setCallback(IParameterCallback callback) {
        this.callback = callback;
    }

    public boolean isModifiersEditable() {
        return this.modifiersEditable;
    }

    public boolean isModifiersVisible() {
        return this.modifiersVisible;
    }

    public void setModifiersEditable(boolean modifiersEditable) {
        this.modifiersEditable = modifiersEditable;
        if (this.modifierComponent != null) {
            this.modifierComponent.setEditable(modifiersEditable && this.isEditable());
        }
    }

    public void setModifiersVisible(boolean modifiersVisible) {
        this.modifiersVisible = modifiersVisible;
    }
}

