/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.ui.reuse.java.Data;
import com.tssap.util.ui.reuse.java.IJavaData;
import com.tssap.util.ui.reuse.java.IModifierData;
import com.tssap.util.ui.reuse.java.IValidatable;
import org.eclipse.core.runtime.IStatus;

public class ModifierData
extends Data
implements IModifierData {
    private int modifier = 511;

    public ModifierData() {
    }

    public ModifierData(int mod) {
        this();
        this.setModifier(mod);
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int newMod) {
        int oldMod = this.modifier;
        if (newMod != oldMod) {
            this.modifier = newMod;
            this.getPropertyChangeSupport().firePropertyChange("modifier", oldMod, newMod);
        }
    }

    public boolean hasModifier(int mod) {
        boolean ret = (this.getModifier() & mod) != 0;
        return ret;
    }

    public void setModifier(int mod, boolean set) {
        int oldMod = this.getModifier();
        int delete = ~mod;
        int newMod = set ? mod : 0;
        this.setModifier(oldMod & delete | newMod);
    }

    public String getSignature() {
        String ret = "";
        if (this.hasModifier(1)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "public";
        }
        if (this.hasModifier(8)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "protected";
        }
        if (this.hasModifier(4)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "private";
        }
        if (this.hasModifier(32)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "final";
        }
        if (this.hasModifier(64)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "static";
        }
        if (this.hasModifier(256)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "native";
        }
        if (this.hasModifier(128)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "synchronized";
        }
        if (this.hasModifier(16)) {
            ret = ModifierData.addSpaceIfNeeded(ret);
            ret = ret + "abstract";
        }
        return ret;
    }

    private static String addSpaceIfNeeded(String ret) {
        if (ret.length() > 0) {
            ret = ret + " ";
        }
        return ret;
    }

    public IStatus getValidationStatus() {
        IStatus ret = IValidatable.STATUS_OK;
        return ret;
    }

    public boolean equalsSignature(IJavaData javaData) {
        boolean ret = false;
        if (javaData instanceof IModifierData) {
            IModifierData otherModifierData = (IModifierData)javaData;
            if (this.getSignature().equals(otherModifierData.getSignature())) {
                ret = true;
            }
        }
        return ret;
    }
}

