/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.java.IModifierData;
import com.tssap.util.ui.reuse.java.JavaComponent;
import com.tssap.util.ui.reuse.java.ModifierData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public class ModifierComponent
extends JavaComponent {
    private IModifierData modifierEnabling = new ModifierData(511);
    private IModifierData modifierVisiblity = new ModifierData(511);
    private Button radioPublic;
    private Button radioProtected;
    private Button radioDefault;
    private Button radioPrivate;
    private Button checkAbstract;
    private Button checkFinal;
    private Button checkStatic;
    private Button checkSynchronized;
    private Button checkNative;

    public ModifierComponent() {
    }

    public ModifierComponent(IModifierData modifierData) {
        this();
        this.setModifierData(modifierData);
    }

    public ModifierComponent(IModifierData modifierData, IModifierData modifierEnabling) {
        this(modifierData);
        this.setModifierEnabling(modifierEnabling);
    }

    public ModifierComponent(IModifierData modifierData, IModifierData modifierEnabling, IModifierData modifierVisiblity) {
        this(modifierData);
        this.setModifierEnabling(modifierEnabling);
        this.setModifierVisiblity(modifierVisiblity);
    }

    public ModifierComponent(String title) {
        super(title);
    }

    public ModifierComponent(String title, IModifierData modifierData) {
        this(title);
        this.setModifierData(modifierData);
    }

    public ModifierComponent(String title, IModifierData modifierData, IModifierData modifierEnabling) {
        this(title, modifierData);
        this.setModifierEnabling(modifierEnabling);
    }

    public ModifierComponent(String title, IModifierData modifierData, IModifierData modifierEnabling, IModifierData modifierVisiblity) {
        this(title, modifierData, modifierEnabling);
        this.setModifierVisiblity(modifierVisiblity);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IModifierData modVisibility = this.getModifierVisiblity();
        if (modVisibility.hasModifier(1) || modVisibility.hasModifier(2) || modVisibility.hasModifier(4) || modVisibility.hasModifier(8)) {
            IGridLayoutPane radioArea = userArea.addGridLayoutPane(4, false, userArea.createGridLayoutData(4, 2, true, false));
            if (modVisibility.hasModifier(1)) {
                this.radioPublic = radioArea.addRadioButton("public");
            }
            if (modVisibility.hasModifier(8)) {
                this.radioProtected = radioArea.addRadioButton("protected");
            }
            if (modVisibility.hasModifier(2)) {
                this.radioDefault = radioArea.addRadioButton("default (package)");
            }
            if (modVisibility.hasModifier(4)) {
                this.radioPrivate = radioArea.addRadioButton("private");
            }
        }
        if (modVisibility.hasModifier(16) || modVisibility.hasModifier(32) || modVisibility.hasModifier(64) || modVisibility.hasModifier(128) || modVisibility.hasModifier(256)) {
            IGridLayoutPane checkArea = userArea.addGridLayoutPane(5, false, userArea.createGridLayoutData(4, 2, true, false));
            if (modVisibility.hasModifier(16)) {
                this.checkAbstract = checkArea.addCheckBox("abstract", false);
            }
            if (modVisibility.hasModifier(32)) {
                this.checkFinal = checkArea.addCheckBox("final", false);
            }
            if (modVisibility.hasModifier(64)) {
                this.checkStatic = checkArea.addCheckBox("static", false);
            }
            if (modVisibility.hasModifier(128)) {
                this.checkSynchronized = checkArea.addCheckBox("synchronized", false);
            }
            if (modVisibility.hasModifier(256)) {
                this.checkNative = checkArea.addCheckBox("native", false);
            }
        }
        this.updateModifierEnablingInUi();
        this.decorateComponents();
    }

    private void decorateComponents() {
        if (this.isAutoRefreshUI()) {
            this.refreshUIFromData();
        }
        SelectionAdapter selListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModifierComponent.this.handleEvent();
                ModifierComponent.super.fireWidgetSelected(e);
            }
        };
        if (this.radioPublic != null) {
            this.radioPublic.addSelectionListener((SelectionListener)selListener);
        }
        if (this.radioProtected != null) {
            this.radioProtected.addSelectionListener((SelectionListener)selListener);
        }
        if (this.radioDefault != null) {
            this.radioDefault.addSelectionListener((SelectionListener)selListener);
        }
        if (this.radioPrivate != null) {
            this.radioPrivate.addSelectionListener((SelectionListener)selListener);
        }
        if (this.checkAbstract != null) {
            this.checkAbstract.addSelectionListener((SelectionListener)selListener);
        }
        if (this.checkFinal != null) {
            this.checkFinal.addSelectionListener((SelectionListener)selListener);
        }
        if (this.checkStatic != null) {
            this.checkStatic.addSelectionListener((SelectionListener)selListener);
        }
        if (this.checkSynchronized != null) {
            this.checkSynchronized.addSelectionListener((SelectionListener)selListener);
        }
        if (this.checkNative != null) {
            this.checkNative.addSelectionListener((SelectionListener)selListener);
        }
        this.refreshUIFromData();
    }

    private void updateModifierEnablingInUi() {
        if (this.getModifierEnabling() != null && !this.isComposable()) {
            IModifierData modEnabling = this.getModifierEnabling();
            boolean editable = this.isEditable();
            if (this.radioPublic != null) {
                this.radioPublic.setEnabled(editable && modEnabling.hasModifier(1));
            }
            if (this.radioDefault != null) {
                this.radioDefault.setEnabled(editable && modEnabling.hasModifier(2));
            }
            if (this.radioPrivate != null) {
                this.radioPrivate.setEnabled(editable && modEnabling.hasModifier(4));
            }
            if (this.radioProtected != null) {
                this.radioProtected.setEnabled(editable && modEnabling.hasModifier(8));
            }
            if (this.checkAbstract != null) {
                this.checkAbstract.setEnabled(editable && modEnabling.hasModifier(16));
            }
            if (this.checkFinal != null) {
                this.checkFinal.setEnabled(editable && modEnabling.hasModifier(32));
            }
            if (this.checkStatic != null) {
                this.checkStatic.setEnabled(editable && modEnabling.hasModifier(64));
            }
            if (this.checkSynchronized != null) {
                this.checkSynchronized.setEnabled(editable && modEnabling.hasModifier(128));
            }
            if (this.checkNative != null) {
                this.checkNative.setEnabled(editable && modEnabling.hasModifier(256));
            }
        }
    }

    public IModifierData getModifierData() {
        IModifierData ret = null;
        if (this.getData() == null) {
            this.setData(new ModifierData());
        } else if (this.getData() instanceof IModifierData) {
            ret = (IModifierData)this.getData();
        }
        return ret;
    }

    public void setModifierData(IModifierData modifierData) {
        if (modifierData instanceof IModifierData) {
            this.setData(modifierData);
            if (this.isAutoRefreshUI()) {
                this.refreshUIFromData();
            }
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IModifierData)) {
            ret = "this is not a modifier data";
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        super.refreshDataFromUI();
        IModifierData modifierData = this.getModifierData();
        if (modifierData != null) {
            boolean state;
            if (this.radioPublic != null) {
                state = this.radioPublic.getSelection();
                modifierData.setModifier(1, state);
            }
            if (this.radioProtected != null) {
                state = this.radioProtected.getSelection();
                modifierData.setModifier(8, state);
            }
            if (this.radioDefault != null) {
                state = this.radioDefault.getSelection();
                modifierData.setModifier(2, state);
            }
            if (this.radioPrivate != null) {
                state = this.radioPrivate.getSelection();
                modifierData.setModifier(4, state);
            }
            if (this.checkAbstract != null) {
                state = this.checkAbstract.getSelection();
                modifierData.setModifier(16, state);
            }
            if (this.checkStatic != null) {
                state = this.checkStatic.getSelection();
                modifierData.setModifier(64, state);
            }
            if (this.checkSynchronized != null) {
                state = this.checkSynchronized.getSelection();
                modifierData.setModifier(128, state);
            }
            if (this.checkFinal != null) {
                state = this.checkFinal.getSelection();
                modifierData.setModifier(32, state);
            }
            if (this.checkNative != null) {
                state = this.checkNative.getSelection();
                modifierData.setModifier(256, state);
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        super.refreshUIFromData();
        IModifierData modifierData = this.getModifierData();
        if (modifierData != null) {
            boolean state;
            if (this.radioPublic != null) {
                state = modifierData.hasModifier(1);
                this.radioPublic.setSelection(state);
            }
            if (this.radioProtected != null) {
                state = modifierData.hasModifier(8);
                this.radioProtected.setSelection(state);
            }
            if (this.radioDefault != null) {
                state = modifierData.hasModifier(2);
                this.radioDefault.setSelection(state);
            }
            if (this.radioPrivate != null) {
                state = modifierData.hasModifier(4);
                this.radioPrivate.setSelection(state);
            }
            if (this.checkAbstract != null) {
                state = modifierData.hasModifier(16);
                this.checkAbstract.setSelection(state);
            }
            if (this.checkStatic != null) {
                state = modifierData.hasModifier(64);
                this.checkStatic.setSelection(state);
            }
            if (this.checkSynchronized != null) {
                state = modifierData.hasModifier(128);
                this.checkSynchronized.setSelection(state);
            }
            if (this.checkNative != null) {
                state = modifierData.hasModifier(256);
                this.checkNative.setSelection(state);
            }
            if (this.checkFinal != null) {
                state = modifierData.hasModifier(32);
                this.checkFinal.setSelection(state);
            }
        }
        this.stopRefreshingUI();
    }

    private IModifierData getModifierEnabling() {
        return this.modifierEnabling;
    }

    private void setModifierEnabling(IModifierData modifierEnabling) {
        this.modifierEnabling = modifierEnabling;
        this.updateModifierEnablingInUi();
    }

    private IModifierData getModifierVisiblity() {
        return this.modifierVisiblity;
    }

    private void setModifierVisiblity(IModifierData modifierVisiblity) {
        this.modifierVisiblity = modifierVisiblity;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        this.updateModifierEnablingInUi();
    }
}

