/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.ui.reuse.java.IJavaData;
import com.tssap.util.ui.reuse.java.IMethodData;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.ISignatureProvider;
import com.tssap.util.ui.reuse.java.ParameterData;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.core.JavaModelStatus;

public class MethodData
extends ParameterData
implements IMethodData {
    private IParameterData[] parameters;

    public MethodData(String name) {
        this(name, 511);
    }

    public MethodData(String name, int modifier) {
        super(name, modifier);
    }

    public MethodData(String name, IParameterData[] parameters) {
        this(name);
        this.setParameters(parameters);
    }

    public MethodData() {
    }

    public MethodData(String name, String fullQualifiedTypeName) {
        super(name, fullQualifiedTypeName);
    }

    public MethodData(String name, String fullQualifiedTypeName, int arrayDim) {
        super(name, fullQualifiedTypeName, arrayDim);
    }

    public MethodData(String name, int modifier, IParameterData[] parameters) {
        this(name, modifier);
        this.setParameters(parameters);
    }

    public IParameterData[] getParameters() {
        if (this.parameters == null) {
            this.parameters = new IParameterData[0];
        }
        return this.parameters;
    }

    public void setParameters(IParameterData[] newParameters) {
        IParameterData[] oldParameters = this.getParameters();
        if (!newParameters.equals(oldParameters)) {
            this.parameters = newParameters;
        }
    }

    public String getSignature() {
        String ret = super.getSignature();
        ret = ret + "(";
        IParameterData[] paramDatas = this.getParameters();
        int i = 0;
        while (i < paramDatas.length) {
            IParameterData param = paramDatas[i];
            String paramSignature = "";
            if (param instanceof ISignatureProvider) {
                paramSignature = ((ISignatureProvider)((Object)param)).getSignature();
            }
            ret = ret + paramSignature;
            if (i < paramDatas.length - 1) {
                ret = ret + ", ";
            }
            ++i;
        }
        ret = ret + ")";
        return ret;
    }

    protected int getDefaultModifier() {
        return 1;
    }

    public IStatus getValidationStatus() {
        IStatus ret = super.getValidationStatus();
        int i = 0;
        while (ret.isOK() && i < this.getParameters().length) {
            IParameterData paramData = this.getParameters()[i];
            ret = paramData.getValidationStatus();
            ++i;
        }
        if (ret.isOK() && this.containsDuplicateParameters() != null) {
            ret = new JavaModelStatus(4, "Duplicate parameter name: " + this.containsDuplicateParameters());
        }
        return ret;
    }

    private String containsDuplicateParameters() {
        String ret = null;
        String EXISTS = "";
        HashMap<String, String> parameterNamesCollection = new HashMap<String, String>();
        int i = 0;
        while (ret == null && i < this.getParameters().length) {
            IParameterData paramData = this.getParameters()[i];
            String name = paramData.getName();
            if (parameterNamesCollection.containsKey(name)) {
                ret = name;
            } else {
                parameterNamesCollection.put(name, "");
            }
            ++i;
        }
        return ret;
    }

    public boolean equalsSignature(IJavaData javaData) {
        boolean ret = false;
        if (javaData instanceof IMethodData) {
            IParameterData[] params2;
            IParameterData[] params1;
            IMethodData otherMethod = (IMethodData)javaData;
            if (this.getName().equals(otherMethod.getName()) && (params1 = this.getParameters()).length == (params2 = otherMethod.getParameters()).length) {
                int paramCount = params1.length;
                if (paramCount == 0) {
                    ret = true;
                } else {
                    int equalsParamCounter = 0;
                    int i = 0;
                    while (i < paramCount) {
                        String fqtName1 = params1[i].getFullQualifiedTypeName();
                        String fqtName2 = params2[i].getFullQualifiedTypeName();
                        int arrayDim1 = params1[i].getArrayDimension();
                        int arrayDim2 = params2[i].getArrayDimension();
                        if (fqtName1.equals(fqtName2) && arrayDim1 == arrayDim2) {
                            ++equalsParamCounter;
                        }
                        ++i;
                    }
                    if (equalsParamCounter == paramCount) {
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }
}

