/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.Util;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.ObjectEditorComponentUtil;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.java.IMethodCallback;
import com.tssap.util.ui.reuse.java.IMethodComponent;
import com.tssap.util.ui.reuse.java.IMethodData;
import com.tssap.util.ui.reuse.java.IModifierData;
import com.tssap.util.ui.reuse.java.IParameterCallback;
import com.tssap.util.ui.reuse.java.IParameterData;
import com.tssap.util.ui.reuse.java.JavaComponent;
import com.tssap.util.ui.reuse.java.MethodData;
import com.tssap.util.ui.reuse.java.ModifierComponent;
import com.tssap.util.ui.reuse.java.ModifierData;
import com.tssap.util.ui.reuse.java.ParameterComponent;
import com.tssap.util.ui.reuse.java.ParameterData;
import com.tssap.util.ui.reuse.java.TypeComponent2;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class MethodComponent
extends JavaComponent
implements IModifiedCallback,
IMethodComponent {
    private static final TracerI T = TracingManager.getTracer(class$com$tssap$util$ui$reuse$java$MethodComponent == null ? (class$com$tssap$util$ui$reuse$java$MethodComponent = MethodComponent.class$("com.tssap.util.ui.reuse.java.MethodComponent")) : class$com$tssap$util$ui$reuse$java$MethodComponent);
    private static final IModifierData POSSIBLE_MODIFIER_DATA = new ModifierData(511);
    private IMethodCallback methodCallback;
    private Text nameTextField;
    private TypeComponent2 typeComponent;
    private ModifierComponent modifierComponent;
    private TreeSelectorEditorComponent parameterSelectorEditorComponent;
    private boolean returnTypeVisible = true;
    private boolean returnTypeEditable = true;
    private boolean modifiersVisible = true;
    private boolean modifiersEditable = true;
    private boolean parametersVisible = true;
    private boolean parametersEditable = true;
    private IGridLayoutPane parameterArea;
    private IChooser returnTypeChooser;
    private IChooser parameterTypeChooser;
    private boolean nameEditable = true;
    static /* synthetic */ Class class$com$tssap$util$ui$reuse$java$MethodComponent;

    public MethodComponent() {
    }

    public MethodComponent(String title) {
        super(title);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane nameArea = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 2, true, false));
        nameArea.addTextLabel("Name", nameArea.createGridLayoutData(1, 2));
        this.nameTextField = nameArea.addTextField("", nameArea.createGridLayoutData(4, 2, true, false));
        this.nameTextField.setEditable(this.isNameEditable());
        this.typeComponent = new TypeComponent2("Return Type", this.getMethodData());
        if (this.isReturnTypeVisible()) {
            this.typeComponent.setTypeChooser(this.getReturnTypeChooser());
            this.typeComponent.setEditable(this.isReturnTypeEditable());
            this.typeComponent.createPartControl(userArea, true, false);
        }
        if (this.isModifiersVisible()) {
            this.modifierComponent = new ModifierComponent("Modifiers", this.getMethodData(), this.getPossibleModifiers(), this.getPossibleModifiers());
            this.modifierComponent.createPartControl(userArea, true, false);
            this.modifierComponent.setEditable(this.isModifiersEditable());
        }
        if (this.isParametersVisible()) {
            this.parameterArea = userArea.addGridLayoutPane("Parameters", 1, false, userArea.createGridLayoutData(4, 4, true, true));
            TreeSelector treeSelector = new TreeSelector(true);
            treeSelector.setTreeContentProvider(new MyParametersContentProvider());
            treeSelector.setTreeLabelProvider(new MyParametersLabelProvider());
            treeSelector.setSplitterWeight(2);
            treeSelector.setTreeInput(this.getMethodData());
            this.parameterSelectorEditorComponent = new TreeSelectorEditorComponent(treeSelector);
            this.parameterSelectorEditorComponent.setReusableManager(new ParameterReusableManager());
            this.parameterSelectorEditorComponent.setAddRemoveCallback(new MyAddRemoveParameterCallback());
            this.parameterSelectorEditorComponent.getTreeSelector().setEditable(this.isParametersEditable());
            treeSelector.createPartControl(this.parameterArea, true, true);
        }
        this.decorateComponents();
    }

    private void decorateComponents() {
        this.nameTextField.addModifyListener(this.getModifyAdapterSingleton());
        if (this.isReturnTypeVisible()) {
            this.typeComponent.setAutoRefreshData(false);
            this.typeComponent.addModifyListener(this.getModifyAdapterSingleton());
            this.typeComponent.setModifiedCallback(this);
        }
        if (this.isModifiersVisible()) {
            this.modifierComponent.setAutoRefreshData(false);
            this.modifierComponent.addModifyListener(this.getModifyAdapterSingleton());
            this.modifierComponent.setModifiedCallback(this);
        }
        if (this.isParametersVisible()) {
            this.parameterSelectorEditorComponent.getTreeSelector().addModifyListener(this.getModifyAdapterSingleton());
            this.parameterSelectorEditorComponent.setModifiedCallback(new ParameterModifiedCallback());
        }
        if (this.isAutoRefreshUI()) {
            this.refreshUIFromData();
        }
        this.setEditable(this.isEditable());
        this.setEnabled(this.isEnabled());
    }

    protected IModifierData getPossibleModifiers() {
        return POSSIBLE_MODIFIER_DATA;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        super.refreshDataFromUI();
        IMethodData methodData = this.getMethodData();
        if (methodData != null) {
            if (this.nameTextField != null) {
                methodData.setName(this.nameTextField.getText());
            }
            if (this.typeComponent != null) {
                this.typeComponent.refreshDataFromUI();
            }
            if (this.modifierComponent != null) {
                this.modifierComponent.refreshDataFromUI();
            }
        }
        if (this.parameterSelectorEditorComponent != null) {
            this.parameterSelectorEditorComponent.aboutToLeave();
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        super.refreshUIFromData();
        IMethodData methodData = this.getMethodData();
        if (methodData != null) {
            if (this.nameTextField != null) {
                this.nameTextField.setText(methodData.getName());
            }
            if (this.typeComponent != null) {
                this.typeComponent.setTypeData(methodData);
                this.typeComponent.refreshUIFromData();
            }
            if (this.modifierComponent != null) {
                this.modifierComponent.setModifierData(methodData);
                this.modifierComponent.refreshUIFromData();
            }
            if (this.parameterSelectorEditorComponent != null) {
                this.parameterSelectorEditorComponent.setTreeInput(methodData);
            }
        }
        this.stopRefreshingUI();
    }

    public IMethodData getMethodData() {
        IMethodData ret = null;
        if (this.getData() == null) {
            this.setData(new MethodData());
        } else if (this.getData() instanceof IMethodData) {
            ret = (IMethodData)this.getData();
        }
        return ret;
    }

    public void setMethodData(IMethodData data) {
        if (data instanceof IMethodData) {
            this.setData(data);
            if (this.isAutoRefreshUI()) {
                this.refreshUIFromData();
            }
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IMethodData)) {
            ret = "this is not a method data";
        }
        return ret;
    }

    protected void updateSignatureTooltip() {
        super.updateSignatureTooltip();
        if (this.typeComponent != null) {
            this.typeComponent.updateSignatureTooltip();
        }
        if (this.modifierComponent != null) {
            this.modifierComponent.updateSignatureTooltip();
        }
    }

    public void dataModified(boolean modified) {
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(modified);
        }
    }

    public boolean isModifiersEditable() {
        return this.modifiersEditable && this.isEditable();
    }

    public boolean isModifiersVisible() {
        return this.modifiersVisible;
    }

    public boolean isParametersVisible() {
        return this.parametersVisible;
    }

    public boolean isReturnTypeEditable() {
        return this.returnTypeEditable && this.isEditable();
    }

    public boolean isReturnTypeVisible() {
        return this.returnTypeVisible;
    }

    public void setModifiersEditable(boolean modifiersEditable) {
        this.modifiersEditable = modifiersEditable;
        if (this.modifierComponent != null) {
            this.modifierComponent.setEditable(modifiersEditable && this.isEditable());
        }
    }

    public void setModifiersVisible(boolean modifiersVisible) {
        this.modifiersVisible = modifiersVisible;
    }

    public void setParametersVisible(boolean parametersVisible) {
        this.parametersVisible = parametersVisible;
    }

    public void setReturnTypeEditable(boolean returnTypeEditable) {
        this.returnTypeEditable = returnTypeEditable;
        if (this.typeComponent != null) {
            this.typeComponent.setEditable(returnTypeEditable);
        }
    }

    public void setReturnTypeVisible(boolean returnTypeVisible) {
        this.returnTypeVisible = returnTypeVisible;
    }

    public boolean isNameEditable() {
        return this.nameEditable && this.isEditable();
    }

    public void setNameEditable(boolean nameEditable) {
        this.nameEditable = nameEditable;
        if (this.nameTextField != null) {
            this.nameTextField.setEditable(nameEditable && this.isEditable());
        }
    }

    public void setReturnTypeChooser(IChooser returnTypeChooser) {
        this.returnTypeChooser = returnTypeChooser;
        if (this.typeComponent != null) {
            this.typeComponent.setTypeChooser(returnTypeChooser);
        }
    }

    public IChooser getReturnTypeChooser() {
        return this.returnTypeChooser;
    }

    public IStatus getValidationStatus() {
        String okToLeave;
        IStatus ret = super.getValidationStatus();
        if (ret.isOK() && this.nameTextField != null) {
            String name = this.nameTextField.getText();
            ret = JavaConventions.validateFieldName((String)name);
        }
        if (ret.isOK() && this.typeComponent != null) {
            ret = this.typeComponent.getValidationStatus();
        }
        if (ret.isOK() && this.modifierComponent != null) {
            ret = this.modifierComponent.getValidationStatus();
        }
        if (ret.isOK() && this.parameterSelectorEditorComponent != null && (okToLeave = this.parameterSelectorEditorComponent.okToLeave()) != null) {
            int msgPrefixIndex = ObjectEditorComponentUtil.getMsgPrefixIndex(okToLeave);
            ret = msgPrefixIndex == 0 ? new JavaModelStatus(1, okToLeave) : (msgPrefixIndex == 1 ? new JavaModelStatus(2, okToLeave) : new JavaModelStatus(4, okToLeave));
        }
        if (ret.isOK() && this.getMethodCallback() != null && this.getMethodData() != null) {
            this.refreshDataFromUI();
            IMethodData currentMethod = this.getMethodData();
            IMethodData[] disapprovedMethods = this.getMethodCallback().getDisapprovedMethods();
            int i = 0;
            while (ret.isOK() && i < disapprovedMethods.length) {
                IMethodData disapprovedMethod = disapprovedMethods[i];
                if (currentMethod.equalsSignature(disapprovedMethod)) {
                    ret = new JavaModelStatus(4, "Duplicate method definition.");
                }
                ++i;
            }
        }
        return ret;
    }

    public boolean isParametersEditable() {
        return this.parametersEditable && this.isEditable();
    }

    public void setParametersEditable(boolean parametersEditable) {
        this.parametersEditable = parametersEditable;
        if (this.parameterSelectorEditorComponent != null) {
            this.parameterSelectorEditorComponent.setEditable(parametersEditable && this.isEditable());
        }
    }

    public void setParameterTypeChooser(IChooser parameterTypeChooser) {
        this.parameterTypeChooser = parameterTypeChooser;
    }

    public IChooser getParameterTypeChooser() {
        return this.parameterTypeChooser;
    }

    public void setMethodCallback(IMethodCallback methodCallback) {
        this.methodCallback = methodCallback;
    }

    public IMethodCallback getMethodCallback() {
        return this.methodCallback;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean modifiersEditable = this.isModifiersEditable();
        boolean parametersEditable = this.isParametersEditable();
        boolean returnTypeEditable = this.isReturnTypeEditable();
        boolean nameEditable = this.isNameEditable();
        boolean editable = this.isEditable();
        if (this.nameTextField != null) {
            this.nameTextField.setEditable(editable && nameEditable);
        }
        if (this.parameterSelectorEditorComponent != null) {
            this.parameterSelectorEditorComponent.setEditable(editable && parametersEditable);
        }
        if (this.typeComponent != null) {
            this.typeComponent.setEditable(editable && returnTypeEditable);
        }
        if (this.modifierComponent != null) {
            this.modifierComponent.setEditable(editable && modifiersEditable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParameterModifiedCallback
    implements IModifiedCallback {
        public void dataModified(boolean modified) {
            MethodComponent.this.dataModified(modified);
            MethodComponent.this.updateSignatureTooltip();
            TreeViewer tv = MethodComponent.this.parameterSelectorEditorComponent.getTreeSelector().getTreeViewer();
            TreeItem[] selection = tv.getTree().getSelection();
            int i = 0;
            while (i < selection.length) {
                tv.refresh(selection[i].getData(), true);
                ++i;
            }
        }
    }

    private class MyAddRemoveParameterCallback
    implements IAddRemoveCallback {
        public boolean canAddElement(Object currentSelection) {
            boolean ret = true;
            return ret;
        }

        public Object addElement(Object currentSelection) {
            IParameterData ret = null;
            IParameterData[] parameters = MethodComponent.this.getMethodData().getParameters();
            IParameterData[] newParameters = new IParameterData[parameters.length + 1];
            int i = 0;
            while (i < parameters.length) {
                newParameters[i] = parameters[i];
                ++i;
            }
            String paramPrefix = "arg";
            String[] oldParamNames = new String[parameters.length];
            int j = 0;
            while (j < parameters.length) {
                oldParamNames[j] = parameters[j].getName();
                ++j;
            }
            String newParamName = Util.createReallyNewName("arg", oldParamNames);
            newParameters[parameters.length] = new ParameterData(newParamName, "int");
            ret = newParameters[parameters.length];
            MethodComponent.this.getMethodData().setParameters(newParameters);
            return ret;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = false;
            if (currentSelection instanceof IParameterData) {
                IParameterData parameter = (IParameterData)currentSelection;
                IParameterData[] parameters = MethodComponent.this.getMethodData().getParameters();
                ret = this.parameterContained(parameter, parameters);
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            IParameterData[] parameters;
            IParameterData parameterToRemove;
            boolean paramContained;
            boolean ret = false;
            if (currentSelection instanceof IParameterData && (paramContained = this.parameterContained(parameterToRemove = (IParameterData)currentSelection, parameters = MethodComponent.this.getMethodData().getParameters()))) {
                IParameterData[] newParameters = new IParameterData[parameters.length - 1];
                boolean found = false;
                int i = 0;
                while (i < newParameters.length) {
                    found = found || parameters[i].equals(parameterToRemove);
                    newParameters[i] = parameters[found ? i + 1 : i];
                    ++i;
                }
                MethodComponent.this.getMethodData().setParameters(newParameters);
                ret = true;
            }
            return ret;
        }

        private boolean parameterContained(IParameterData parameter, IParameterData[] parameters) {
            boolean paramContained = false;
            int i = 0;
            while (!paramContained && i < parameters.length) {
                IParameterData p = parameters[i];
                if (p.equals(parameter)) {
                    paramContained = true;
                }
                ++i;
            }
            return paramContained;
        }
    }

    private class MyParametersLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String ret = null;
            if (element instanceof IParameterData) {
                IParameterData paramData = (IParameterData)element;
                ret = paramData.getName() + " : " + paramData.getFullQualifiedTypeName();
                int arrayDim = paramData.getArrayDimension();
                int MAX_VISIBLE_ARRAY_DIM = 10;
                int i = 1;
                while (i <= arrayDim && i <= 10) {
                    ret = ret + "[]";
                    ++i;
                }
                if (arrayDim > 10) {
                    ret = ret + "...";
                }
            }
            return ret;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class MyParametersContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            Object[] ret = new Object[]{};
            if (inputElement instanceof IMethodData) {
                IMethodData methData = (IMethodData)inputElement;
                ret = methData.getParameters();
            }
            return ret;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ParameterReusableManager
    implements IReuseableManager,
    IParameterCallback {
        private IParameterData lastParametersData;

        private ParameterReusableManager() {
        }

        public IReuseable getReusable(Object obj) {
            ParameterComponent ret = null;
            if (obj instanceof IParameterData) {
                this.lastParametersData = (IParameterData)obj;
                ParameterComponent newComp = new ParameterComponent();
                newComp.setModifiersVisible(false);
                newComp.setCallback(this);
                newComp.setTypeChooser(MethodComponent.this.getParameterTypeChooser());
                newComp.setEditable(MethodComponent.this.isParametersEditable());
                ret = newComp;
            }
            return ret;
        }

        public String[] getDisapprovedNames() {
            String[] ret = new String[]{};
            IParameterData[] params = MethodComponent.this.getMethodData().getParameters();
            ArrayList<String> arl = new ArrayList<String>();
            int i = 0;
            while (i < params.length) {
                if (this.lastParametersData == null || !this.lastParametersData.equals(params[i])) {
                    arl.add(params[i].getName());
                }
                ++i;
            }
            ret = arl.toArray(ret);
            return ret;
        }
    }
}

