/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.java;

import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import com.tssap.util.ui.reuse.java.IJavaData;
import com.tssap.util.ui.reuse.java.ISignatureProvider;
import com.tssap.util.ui.reuse.java.IValidatable;
import org.eclipse.core.runtime.IStatus;

public abstract class JavaComponent
extends RefreshObjectEditorComponent
implements IValidatable {
    private static final TracerI T = TracingManager.getTracer(class$com$tssap$util$ui$reuse$java$JavaComponent == null ? (class$com$tssap$util$ui$reuse$java$JavaComponent = JavaComponent.class$("com.tssap.util.ui.reuse.java.JavaComponent")) : class$com$tssap$util$ui$reuse$java$JavaComponent);
    private boolean signatureTooltipVisible = false;
    private boolean autoRefreshData = true;
    private boolean autoRefreshUI = false;
    static /* synthetic */ Class class$com$tssap$util$ui$reuse$java$JavaComponent;

    public JavaComponent() {
    }

    public JavaComponent(String title) {
        super(title);
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        super.refreshDataFromUI();
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        super.refreshUIFromData();
        this.updateSignatureTooltip();
        this.stopRefreshingUI();
    }

    protected void updateSignatureTooltip() {
        if (this.isSignatureTooltipVisible()) {
            String signature = "";
            if (this.getJavaData() instanceof ISignatureProvider) {
                signature = ((ISignatureProvider)((Object)this.getJavaData())).getSignature();
            }
            this.setTooltip(signature);
        }
    }

    private void setTooltip(String signature) {
        if (this.getJavaData() != null && this.getUserAreaGridLayoutPane() != null && this.getUserAreaGridLayoutPane().getComposite() != null) {
            this.getUserAreaGridLayoutPane().getComposite().setToolTipText(signature);
        }
    }

    public IJavaData getJavaData() {
        IJavaData ret = null;
        if (this.getData() instanceof IJavaData) {
            ret = (IJavaData)this.getData();
        }
        return ret;
    }

    public void setJavaData(IJavaData data) {
        if (data instanceof IJavaData) {
            this.setData(data);
            if (this.isAutoRefreshUI()) {
                this.refreshUIFromData();
            }
        }
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof IJavaData)) {
            ret = ret == null ? "null" : data.getClass().getName() + " is invalid dataobject for " + this.getClass().getName();
        }
        return ret;
    }

    protected boolean isSignatureTooltipVisible() {
        return this.signatureTooltipVisible;
    }

    private void setSignatureTooltipVisible(boolean signatureTooltipVisible) {
        if (signatureTooltipVisible && !this.signatureTooltipVisible) {
            this.setTooltip("");
        }
        this.signatureTooltipVisible = signatureTooltipVisible;
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI()) {
            if (this.isAutoRefreshData()) {
                this.refreshDataFromUI();
            }
            super.handleEvent();
        }
        this.updateSignatureTooltip();
    }

    public boolean isAutoRefreshData() {
        return this.autoRefreshData;
    }

    protected boolean isAutoRefreshUI() {
        return this.autoRefreshUI;
    }

    public void setAutoRefreshData(boolean autoRefreshData) {
        this.autoRefreshData = autoRefreshData;
    }

    protected void setAutoRefreshUI(boolean autoRefreshUI) {
        this.autoRefreshUI = autoRefreshUI;
    }

    public IStatus getValidationStatus() {
        IStatus ret = IValidatable.STATUS_OK;
        return ret;
    }

    public String okToLeave() {
        String ret = super.okToLeave();
        IStatus validationStatus = this.getValidationStatus();
        if (ret == null && !validationStatus.isOK()) {
            int statusSeverity = validationStatus.getSeverity();
            ret = statusSeverity == 2 ? "{$LEAVABLE_WARNING}" + validationStatus.getMessage() : (statusSeverity == 1 ? "{$INFO}" + validationStatus.getMessage() : "{$ERROR}" + validationStatus.getMessage());
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

