/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.chooser.impl;

import com.tssap.util.ui.dialog.ResourceChooserDialog;
import com.tssap.util.ui.reuse.chooser.IDisplayableChooser;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;

public class ResourceChooser
implements IDisplayableChooser {
    private IResourceChooserCallback chooseCallback;
    private ViewerFilter viewerFilter;
    private String title;
    private String message;

    public ResourceChooser() {
    }

    public ResourceChooser(IResourceChooserCallback chooseCallback, String title, String message) {
        this.setChooseCallback(chooseCallback);
        this.title = title != null ? title : "Resource Chooser";
        this.message = message != null ? message : "Choose Resource";
    }

    public IResourceChooserCallback getChooseCallback() {
        if (this.chooseCallback == null) {
            this.chooseCallback = new InnerChooserCallback();
        }
        return this.chooseCallback;
    }

    public void setChooseCallback(IResourceChooserCallback chooseCallback) {
        this.chooseCallback = chooseCallback;
    }

    protected IResource getResourceFromTxt(String txt) {
        return this.getChooseCallback().getResourceFromTxt(txt);
    }

    protected String getTxtFromResource(IResource res) {
        return this.getChooseCallback().getTxtFromResource(res);
    }

    protected IProject[] getProjectsToChoose() {
        return this.getChooseCallback().getProjectsToChooseFrom();
    }

    public String getSelection(String currentText, Shell parentShell) {
        int pressed;
        ResourceChooserDialog chooser = new ResourceChooserDialog(parentShell, this.title, this.message);
        if (this.getViewerFilter() != null) {
            chooser.addResourceFilter(this.getViewerFilter());
        }
        return (pressed = chooser.open(this.getProjectsToChoose(), this.getResourceFromTxt(currentText))) == 0 ? this.getTxtFromResource(chooser.getSelectedResource()) : currentText;
    }

    public ViewerFilter getViewerFilter() {
        return this.viewerFilter;
    }

    public void setViewerFilter(ViewerFilter viewerFilter) {
        this.viewerFilter = viewerFilter;
    }

    class InnerChooserCallback
    implements IResourceChooserCallback {
        InnerChooserCallback() {
        }

        public IProject[] getProjectsToChooseFrom() {
            return ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }

        public IResource getResourceFromTxt(String txt) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(txt);
        }

        public String getTxtFromResource(IResource res) {
            return res.getFullPath().toString();
        }
    }
}

